StartupEvents.registry('palladium:abilities', (event) => {
	event.create('aeo:completed_blueprint')
		.addProperty('craft_type', 'string', 'completed_core', 'Check for what is being crafted')
		.icon(palladium.createItemIcon('palladium:vibranium_circuit'))
		.firstTick((entity, entry, holder, enabled) => {
			if (!enabled) return;
			if (!entity.isPlayer()) return;

			let craft_type = entry.getPropertyByName('craft_type');
			
			if (!palladium.superpowers.hasSuperpower(entity, new ResourceLocation('alienevo_aliens:galvan'))) {
				entity.tell("§cYou can't seem to make out the writing... it's almost alien to you.");
				entity.persistentData.putInt(`crafted_${craft_type}`, 0);
				return;
			}

			
			let requirements = {
				'aeo:reinforced_galvan_alloy': 4,
				'aeo:advanced_galvan_circuit': 2,
				'alienevo:upgrade_crystal': 2
			};

			
			for (let [item, amount] of Object.entries(requirements)) {
				if (entity.inventory.count(Item.of(item)) < amount) {
					entity.addTag('craftFail');
					entity.server.scheduleInTicks(4, () => {
						entity.removeTag('craftFail');
					});
					entity.persistentData.putInt(`crafted_${craft_type}`, 0);
					entity.runCommandSilent(`playsound minecraft:block.note_block.pling player @s ~ ~ ~`);

					let missingIngredientsText = Text.translate("craft.alienevo_aliens.5.fail").getString();
					let completedCoreText = Text.translate("ability.alienevo_aliens.5.completed_core").getString();
					let completedCoreRecipe = Text.translate("ingredients.alienevo_aliens.5.completed_core").getString();

					entity.tell(`§c${missingIngredientsText} ${completedCoreText}.\n${completedCoreRecipe}`);
					return;
				}
			}

			
			for (let [item, amount] of Object.entries(requirements)) {
				let remaining = amount;
				for (let slot of entity.inventory.allItems) {
					if (slot.id === item && remaining > 0) {
						let removeCount = Math.min(slot.count, remaining);
						slot.shrink(removeCount);
						remaining -= removeCount;
					}
				}
			}

			
			entity.setMainHandItem(Item.of('alienevo:omniverse_core'));

			
			entity.server.runCommandSilent(`playsound minecraft:block.anvil.place player @s ~ ~ ~`);
			entity.tell(`§aYou have successfully crafted the ${Text.translate("ability.alienevo_aliens.5.completed_core").getString()}!`);
			entity.persistentData.putInt(`crafted_${craft_type}`, 1);
		});
});

