StartupEvents.registry('palladium:abilities', (event) => {
  event.create('aeo:airbreather_module')
    .icon(palladium.createItemIcon('minecraft:nether_star'))
    .tick((entity, entry, holder, enabled) => {
      if (enabled) {
        try {
          let username = entity.getGameProfile().getName();

          let mainHandItem = entity.getMainHandItem();
          let isActive = entity.persistentData.getBoolean('AEO_AirBreather');

          try {
            palladium.scoreboard.setScore(entity, 'AEO.AirBreather', isActive ? 1 : 0);
          } catch (e) {
            try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.AirBreather ' + (isActive ? 1 : 0)); } catch (e2) { }
          }

          if (mainHandItem.isEmpty()) {
            if (isActive) {
              let circuitItem = Item.of('aeo:breathing_apparatus_module');
              if (!circuitItem.isEmpty()) {
                entity.setMainHandItem(circuitItem);
              }

              entity.persistentData.putBoolean('AEO_AirBreather', false);
              try { palladium.scoreboard.setScore(entity, 'AEO.AirBreather', 0); } catch (e) { try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.AirBreather 0'); } catch (e2) {} }
              entity.server.runCommandSilent(`execute as ${username} at @s run playsound alienevo:omniverse_decouple player @s ~ ~ ~ 0.5 1.5 0.5`);
            }
            return;
          }

          if (!mainHandItem || mainHandItem.isEmpty()) {
            return;
          }

          let itemId = mainHandItem.getId().toString();

          if (itemId !== 'aeo:breathing_apparatus_module') {
            if (isActive) {
              entity.persistentData.putBoolean('AEO_AirBreather', false);
            }
            return;
          }

          if (isActive) {
            return;
          }

          mainHandItem.shrink(1);
          entity.persistentData.putBoolean('AEO_AirBreather', true);
          try { palladium.scoreboard.setScore(entity, 'AEO.AirBreather', 1); } catch (e) { try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.AirBreather 1'); } catch (e2) {} }
          entity.server.runCommandSilent(`execute as ${username} at @s run playsound alienevo:omniverse_equip player @s ~ ~ ~ 0.5 1.5 0.5`);

        } catch (e) {
          console.warn(`[AEO Airbreather Ability Error] ${e}`);
        }
      }
    });
});

StartupEvents.registry('palladium:abilities', (event) => {
  event.create('aeo:suit_module')
    .icon(palladium.createItemIcon('minecraft:nether_star'))
    .tick((entity, entry, holder, enabled) => {
      if (enabled) {
        try {
          let username = entity.getGameProfile().getName();

          let mainHandItem = entity.getMainHandItem();
          let isActive = entity.persistentData.getBoolean('AEO_Suit');

          try {
            palladium.scoreboard.setScore(entity, 'AEO.Suit', isActive ? 1 : 0);
          } catch (e) {
            try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Suit ' + (isActive ? 1 : 0)); } catch (e2) { }
          }

          if (mainHandItem.isEmpty()) {
            if (isActive) {
              let circuitItem = Item.of('aeo:suit_module');
              if (!circuitItem.isEmpty()) {
                entity.setMainHandItem(circuitItem);
              }

              entity.persistentData.putBoolean('AEO_Suit', false);
              try { palladium.scoreboard.setScore(entity, 'AEO.Suit', 0); } catch (e) { try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Suit 0'); } catch (e2) {} }
              entity.server.runCommandSilent(`execute as ${username} at @s run playsound alienevo:omniverse_decouple player @s ~ ~ ~ 0.5 1.5 0.5`);
              entity.tags.remove('AEO.Suited');
            }
            return;
          }

          if (!mainHandItem || mainHandItem.isEmpty()) {
            return;
          }

          let itemId = mainHandItem.getId().toString();

    
          if (itemId !== 'aeo:suit_module') {
      
            if (isActive) {
              entity.persistentData.putBoolean('AEO_Suit', false);
            }
            return;
          }

          if (isActive) {
            return;
          }

          mainHandItem.shrink(1);
          entity.persistentData.putBoolean('AEO_Suit', true);
          try { palladium.scoreboard.setScore(entity, 'AEO.Suit', 1); } catch (e) { try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Suit 1'); } catch (e2) {} }
          entity.server.runCommandSilent(`execute as ${username} at @s run playsound alienevo:omniverse_equip player @s ~ ~ ~ 0.5 1.5 0.5`);

        } catch (e) {
          console.warn(`[AEO Suitz Error] ${e}`);
        }
      }
    });

    event.create('aeo:battery_upgrade_module')
      .icon(palladium.createItemIcon('minecraft:nether_star'))
      .tick((entity, entry, holder, enabled) => {
        if (enabled) {
          try {
            let username = entity.getGameProfile().getName();

            let mainHandItem = entity.getMainHandItem();
            let isActive = entity.persistentData.getBoolean('AEO_Battery');

            try { palladium.scoreboard.setScore(entity, 'AEO.Battery', isActive ? 1 : 0); } catch (e) { try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Battery ' + (isActive ? 1 : 0)); } catch (ee) {} }

            if (mainHandItem.isEmpty()) {
              if (isActive) {
                let circuitItem = Item.of('aeo:battery_upgrade_module');
                if (!circuitItem.isEmpty()) {
                  entity.setMainHandItem(circuitItem);
                }

                entity.persistentData.putBoolean('AEO_Battery', false);
                try { palladium.scoreboard.setScore(entity, 'AEO.Battery', 0); } catch (e) { try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Battery 0'); } catch (ee) {} }
                entity.server.runCommandSilent(`execute as ${username} at @s run playsound alienevo:omniverse_decouple player @s ~ ~ ~ 0.5 1.5 0.5`);
              }
              return;
            }

            if (!mainHandItem || mainHandItem.isEmpty()) {
              return;
            }

            let itemId = mainHandItem.getId().toString();

            if (itemId !== 'aeo:battery_upgrade_module') {
              if (isActive) {
                entity.persistentData.putBoolean('AEO_Battery', false);
              }
              return;
            }

            if (isActive) {
              return;
            }

            mainHandItem.shrink(1);
            entity.persistentData.putBoolean('AEO_Battery', true);
            try { palladium.scoreboard.setScore(entity, 'AEO.Battery', 1); } catch (e) { try { entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Battery 1'); } catch (ee) {} }
            entity.server.runCommandSilent(`execute as ${username} at @s run playsound alienevo:omniverse_equip player @s ~ ~ ~ 0.5 1.5 0.5`);

          } catch (e) {
            console.warn(`[AEO Battery Ability Error] ${e}`);
          }
        }
      });
});

