StartupEvents.registry('palladium:abilities', (event) => {
    const MAX_ALIEN_SLOTS = 10;
    const MIN_ALIEN_SLOT = 1;
    const OMNITRIX_PROPERTY_KEY = 'omnitrix_cycle';
    const NEXT_ALIEN_PROPERTY_KEY = 'omnitrix_next_alien';
    const NEXT_NEXT_ALIEN_PROPERTY_KEY = 'omnitrix_next_next_alien';
    const PREV_ALIEN_PROPERTY_KEY = 'omnitrix_prev_alien';
    const PREV_PREV_ALIEN_PROPERTY_KEY = 'omnitrix_prev_prev_alien';
    const CURRENT_PLAYLIST_KEY = 'current_playlist';
    const CURRENT_ALIEN_SLOT_KEY = 'current_alien_slot';
    const CYCLE_COOLDOWN_KEY = 'omnitrix_cycle_cooldown';
    const CYCLE_DELAY = 5;
    
    event.create('aeo:omnitrix_cycle_next_animated')
        .icon(palladium.createItemIcon('minecraft:blaze_rod'))
        .addProperty("property", "string", OMNITRIX_PROPERTY_KEY, "Do not change this property")
        .addProperty("next_property", "string", NEXT_ALIEN_PROPERTY_KEY, "Property for next alien in cycle")
        .addProperty("next_next_property", "string", NEXT_NEXT_ALIEN_PROPERTY_KEY, "Property for alien two ahead in cycle")
        .addProperty("prev_property", "string", PREV_ALIEN_PROPERTY_KEY, "Property for previous alien in cycle")
        .addProperty("prev_prev_property", "string", PREV_PREV_ALIEN_PROPERTY_KEY, "Property for alien two behind in cycle")
        .tick((entity, abilityEntry, abilityHolder, isEnabled) => {
            if (isEnabled && entity) {
                const omnitrixData = entity.persistentData;
                if (!omnitrixData) return;

                // Check for playlist changes first
                checkAndHandlePlaylistChange(entity, abilityEntry);

                if (omnitrixData[CYCLE_COOLDOWN_KEY] === undefined) {
                    omnitrixData[CYCLE_COOLDOWN_KEY] = 0;
                }

                if (omnitrixData[CYCLE_COOLDOWN_KEY] <= 0) {
                    cycleOmnitrixAlien(entity, abilityEntry, 1);
                    updateAdditionalAlienProperties(entity, abilityEntry);
                    omnitrixData[CYCLE_COOLDOWN_KEY] = CYCLE_DELAY;
                } else {
                    omnitrixData[CYCLE_COOLDOWN_KEY]--;
                }
            }
        });
    
    function cycleOmnitrixAlien(entity, abilityEntry, direction) {
        const omnitrixData = entity.persistentData;
        if (!omnitrixData) return;
        
        initializeOmnitrixData(omnitrixData);
        
        const currentPlaylist = omnitrixData[CURRENT_PLAYLIST_KEY];
        const currentAlienSlot = omnitrixData[CURRENT_ALIEN_SLOT_KEY];
        
        const alienCount = countAvailableAliens(omnitrixData, currentPlaylist);
                
        if (alienCount === 0) {
            return;
        }
        
        const nextAlienSlot = findNextValidAlienSlot(entity, omnitrixData, currentPlaylist, currentAlienSlot, direction);
        
        if (nextAlienSlot !== -1) {
            omnitrixData[CURRENT_ALIEN_SLOT_KEY] = nextAlienSlot;
            const nextAlienNumber = omnitrixData[`alienevo.alien_${currentPlaylist}_${nextAlienSlot}`];
                        
            palladium.setProperty(entity, abilityEntry.getPropertyByName('property'), nextAlienNumber);
        }
    }

    function updateAdditionalAlienProperties(entity, abilityEntry) {
        const omnitrixData = entity.persistentData;
        if (!omnitrixData) return;

        initializeOmnitrixData(omnitrixData);

        const currentPlaylist = omnitrixData[CURRENT_PLAYLIST_KEY];
        const currentAlienSlot = omnitrixData[CURRENT_ALIEN_SLOT_KEY];

        const nextPropName = abilityEntry.getPropertyByName('next_property');
        const nextNextPropName = abilityEntry.getPropertyByName('next_next_property');
        const prevPropName = abilityEntry.getPropertyByName('prev_property');
        const prevPrevPropName = abilityEntry.getPropertyByName('prev_prev_property');

        const nextSlot = findNextValidAlienSlot(entity, omnitrixData, currentPlaylist, currentAlienSlot, 1);
        const prevSlot = findNextValidAlienSlot(entity, omnitrixData, currentPlaylist, currentAlienSlot, -1);

        const nextNextSlot = findNextValidAlienSlot(entity, omnitrixData, currentPlaylist, nextSlot, 1);
        const prevPrevSlot = findNextValidAlienSlot(entity, omnitrixData, currentPlaylist, prevSlot, -1);

        const nextAlien = (nextSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${nextSlot}`] : 0;
        const nextNextAlien = (nextNextSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${nextNextSlot}`] : 0;
        const prevAlien = (prevSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${prevSlot}`] : 0;
        const prevPrevAlien = (prevPrevSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${prevPrevSlot}`] : 0;

        palladium.setProperty(entity, nextPropName, nextAlien);
        palladium.setProperty(entity, nextNextPropName, nextNextAlien);
        palladium.setProperty(entity, prevPropName, prevAlien);
        palladium.setProperty(entity, prevPrevPropName, prevPrevAlien);
    }

    function checkAndHandlePlaylistChange(entity, abilityEntry) {
        const omnitrixData = entity.persistentData;
        if (!omnitrixData) return;
        
        initializeOmnitrixData(omnitrixData);

        // Store the last known playlist to detect changes
        const lastPlaylistKey = 'last_known_playlist';
        const currentPlaylist = omnitrixData[CURRENT_PLAYLIST_KEY];
        const lastPlaylist = omnitrixData[lastPlaylistKey];

        // If playlist changed, update sil properties immediately
        if (lastPlaylist !== undefined && lastPlaylist !== currentPlaylist) {
            updateAdditionalAlienProperties(entity, abilityEntry);
        }

        // Update the last known playlist
        omnitrixData[lastPlaylistKey] = currentPlaylist;
    }
    
    function findNextValidAlienSlot(entity, omnitrixData, playlist, startSlot, direction) {
        const validSlots = [];
        for (let slot = MIN_ALIEN_SLOT; slot <= MAX_ALIEN_SLOTS; slot++) {
            if (isValidAlien(omnitrixData[`alienevo.alien_${playlist}_${slot}`])) {
                validSlots.push(slot);
            }
        }
                
        if (validSlots.length === 0) {
            return -1;
        }
                
        validSlots.sort((a, b) => a - b);
                
        const currentIndex = validSlots.indexOf(startSlot);
                
        if (currentIndex === -1) {
            return validSlots[0];
        }
                
        let nextIndex = currentIndex + direction;
                
        if (nextIndex >= validSlots.length) {
            nextIndex = 0;
        } else if (nextIndex < 0) {
            nextIndex = validSlots.length - 1;
        }
                
        const nextSlot = validSlots[nextIndex];
                
        return nextSlot;
    }
    
    function initializeOmnitrixData(omnitrixData) {
        if (!omnitrixData[CURRENT_ALIEN_SLOT_KEY]) {
            omnitrixData[CURRENT_ALIEN_SLOT_KEY] = MIN_ALIEN_SLOT;
        }
        if (!omnitrixData[CURRENT_PLAYLIST_KEY]) {
            omnitrixData[CURRENT_PLAYLIST_KEY] = MIN_ALIEN_SLOT;
        }
    }
    
    function isValidAlien(alienType) {
        return alienType != null && alienType !== 0;
    }
    
    function countAvailableAliens(omnitrixData, playlist) {
        let alienCount = 0;
        for (let slot = MIN_ALIEN_SLOT; slot <= MAX_ALIEN_SLOTS; slot++) {
            if (isValidAlien(omnitrixData[`alienevo.alien_${playlist}_${slot}`])) {
                alienCount++;
            }
        }
        return alienCount;
    }
});

StartupEvents.registry('palladium:abilities', (event) => {
    let OMNITRIX_PROPERTY_KEY = 'omnitrix_cycle';
    let NEXT_ALIEN_PROPERTY_KEY = 'omnitrix_next_alien';
    let NEXT_NEXT_ALIEN_PROPERTY_KEY = 'omnitrix_next_next_alien';
    let PREV_ALIEN_PROPERTY_KEY = 'omnitrix_prev_alien';
    let PREV_PREV_ALIEN_PROPERTY_KEY = 'omnitrix_prev_prev_alien';
    let CURRENT_PLAYLIST_KEY = 'current_playlist';
    let CURRENT_ALIEN_SLOT_KEY = 'current_alien_slot';
    
    let DEFAULT_PLAYLIST = 1;
    let DEFAULT_SLOT = 1;
    let MAX_PLAYLISTS = 100;
    let MAX_SLOTS = 10;
    
    event.create('aeo:omnitrix_cycle_playlists')
        .icon(palladium.createItemIcon('minecraft:blaze_rod'))
        .addProperty("cycle_direction", "string", "right", "Direction to cycle playlists")
        .addProperty("property", "string", OMNITRIX_PROPERTY_KEY, "Cycle property")
        .addProperty("next_property", "string", NEXT_ALIEN_PROPERTY_KEY, "Property for next alien in cycle")
        .addProperty("next_next_property", "string", NEXT_NEXT_ALIEN_PROPERTY_KEY, "Property for alien two ahead in cycle")
        .addProperty("prev_property", "string", PREV_ALIEN_PROPERTY_KEY, "Property for previous alien in cycle")
        .addProperty("prev_prev_property", "string", PREV_PREV_ALIEN_PROPERTY_KEY, "Property for alien two behind in cycle")
        .addProperty("update_main_property", "boolean", false, "Whether to update the main omnitrix property")
        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                let direction = entry.getPropertyByName('cycle_direction') === "right" ? 1 : -1;
                let currentPlaylist = entity.persistentData[CURRENT_PLAYLIST_KEY] || DEFAULT_PLAYLIST;
                let currentSlot = entity.persistentData[CURRENT_ALIEN_SLOT_KEY] || DEFAULT_SLOT;
                let startingPlaylist = currentPlaylist;
                let alienFound = false;
                
                do {
                    currentPlaylist += direction;
                    
                    if (currentPlaylist > MAX_PLAYLISTS) currentPlaylist = 1;
                    if (currentPlaylist < 1) currentPlaylist = MAX_PLAYLISTS;
                    
                    for (let slot = 1; slot <= MAX_SLOTS; slot++) {
                        let alienNumber = entity.persistentData[`alienevo.alien_${currentPlaylist}_${slot}`];
                        
                        if (alienNumber > 0) {
                            entity.persistentData[CURRENT_PLAYLIST_KEY] = currentPlaylist;
                            entity.persistentData[CURRENT_ALIEN_SLOT_KEY] = slot;

                            let updateMainProperty = entry.getPropertyByName('update_main_property');
                            if (updateMainProperty) {
                                let propertyKey = entry.getPropertyByName('property');
                                palladium.setProperty(entity, propertyKey, alienNumber);
                            }

                            updateAllSlotProperties(entity, currentPlaylist);
                            updatePlaylistSilProperties(entity, entry);
                            
                            alienFound = true;
                            break;
                        }
                    }
                    
                    if (alienFound) break;
                    
                } while (currentPlaylist !== startingPlaylist);
            }
        });

    function updateAllSlotProperties(entity, playlist) {
        for (let slot = 1; slot <= MAX_SLOTS; slot++) {
            let alienType = entity.persistentData.getInt(`alienevo.alien_${playlist}_${slot}`) || 0;
            palladium.setProperty(entity, `alien_evo_slot_${slot}`, alienType);
        }
    }

    function updatePlaylistSilProperties(entity, abilityEntry) {
        const omnitrixData = entity.persistentData;
        if (!omnitrixData) return;

        const currentPlaylist = omnitrixData[CURRENT_PLAYLIST_KEY];
        const currentAlienSlot = omnitrixData[CURRENT_ALIEN_SLOT_KEY];

        const nextPropName = abilityEntry.getPropertyByName('next_property');
        const nextNextPropName = abilityEntry.getPropertyByName('next_next_property');
        const prevPropName = abilityEntry.getPropertyByName('prev_property');
        const prevPrevPropName = abilityEntry.getPropertyByName('prev_prev_property');

        const nextSlot = findNextValidAlienSlotForPlaylist(entity, omnitrixData, currentPlaylist, currentAlienSlot, 1);
        const prevSlot = findNextValidAlienSlotForPlaylist(entity, omnitrixData, currentPlaylist, currentAlienSlot, -1);

        const nextNextSlot = findNextValidAlienSlotForPlaylist(entity, omnitrixData, currentPlaylist, nextSlot, 1);
        const prevPrevSlot = findNextValidAlienSlotForPlaylist(entity, omnitrixData, currentPlaylist, prevSlot, -1);

        const nextAlien = (nextSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${nextSlot}`] : 0;
        const nextNextAlien = (nextNextSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${nextNextSlot}`] : 0;
        const prevAlien = (prevSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${prevSlot}`] : 0;
        const prevPrevAlien = (prevPrevSlot !== -1) ? omnitrixData[`alienevo.alien_${currentPlaylist}_${prevPrevSlot}`] : 0;

        palladium.setProperty(entity, nextPropName, nextAlien);
        palladium.setProperty(entity, nextNextPropName, nextNextAlien);
        palladium.setProperty(entity, prevPropName, prevAlien);
        palladium.setProperty(entity, prevPrevPropName, prevPrevAlien);
    }

    function findNextValidAlienSlotForPlaylist(entity, omnitrixData, playlist, startSlot, direction) {
        const validSlots = [];
        for (let slot = 1; slot <= MAX_SLOTS; slot++) {
            if (omnitrixData[`alienevo.alien_${playlist}_${slot}`] > 0) {
                validSlots.push(slot);
            }
        }
                
        if (validSlots.length === 0) {
            return -1;
        }
                
        validSlots.sort((a, b) => a - b);
                
        const currentIndex = validSlots.indexOf(startSlot);
                
        if (currentIndex === -1) {
            return validSlots[0];
        }
                
        let nextIndex = currentIndex + direction;
                
        if (nextIndex >= validSlots.length) {
            nextIndex = 0;
        } else if (nextIndex < 0) {
            nextIndex = validSlots.length - 1;
        }
                
        const nextSlot = validSlots[nextIndex];
                
        return nextSlot;
    }
});