StartupEvents.registry('item', event => {

    event.create('alienevo:omniverse_omnitrix')
        .displayName('Completed Omnitrix')
        .maxStackSize(1)
        .rarity('epic')
        .fireResistant()
        .texture('layer0', 'alienevo:item/omniverse_omnitrix')
        .texture('layer1', 'alienevo:item/omniverse_omnitrix_tert_1')
        .texture('layer2', 'alienevo:item/omniverse_omnitrix_tert_2')
        .texture('layer3', 'alienevo:item/omniverse_omnitrix_tert_3')
        .texture('layer4', 'alienevo:item/omniverse_omnitrix_tert_4')
        
        .color((stack, i) => {
            if (i < 1 || i > 4) return -1;

            let fallbackByIndex = {
                1: 0xb3ff40,
                2: 0x8ed721,
                3: 0x8ed721,
                4: 0x8ed721
            };
            let fallback = fallbackByIndex[i] || 0xb3ff40;

            try {
                if (!stack || !stack.hasNBT()) return fallback;
                let key = `storedUniformTertiaryColor${i}`;
                let string = (stack.nbt.getString(key) + '').trim();
                if (string.startsWith('#')) string = string.slice(1);
                let v = parseInt(string, 16);
                return (string.length === 6 && !Number.isNaN(v)) ? v : fallback;
            } catch (e) {
                return fallback;
            }
        });

    event.create('alienevo:omniverse_core')
        .displayName('Completed Omnitrix Core')
        .maxStackSize(1)
        .rarity('epic')
        .fireResistant()
        .texture('layer0', 'alienevo:item/completed_core')
        .texture('layer1', 'alienevo:item/completed_core_glow_1')
        .texture('layer2', 'alienevo:item/completed_core_glow_2')
        .texture('layer3', 'alienevo:item/completed_core_glow_3')
        
        .color((stack, i) => {
            if (i < 1 || i > 3) return -1;

            let fallbackByIndex = {
                1: 0xb3ff40,
                2: 0x8ed721,
                3: 0x8ed721
            };
            let fallback = fallbackByIndex[i] || 0xb3ff40;

            try {
                if (!stack || !stack.hasNBT()) return fallback;
                let key = `storedGlowColor${i + 1}`;
                let string = (stack.nbt.getString(key) + '').trim();
                if (string.startsWith('#')) string = string.slice(1);
                let v = parseInt(string, 16);
                return (string.length === 6 && !Number.isNaN(v)) ? v : fallback;
            } catch (e) {
                return fallback;
            }
        });

});

StartupEvents.modifyCreativeTab('kubejs:tab', event => {
    event.remove('alienevo:omniverse_omnitrix');
    event.remove('alienevo:omniverse_core');
});







