import sys
import os
from PIL import Image

# Define the input colors once
input_colors = [
    (58, 51, 51),  # example input color 1
    (44, 40, 40),  # example input color 2
    (35, 32, 32),  # example input color 3
    (23, 21, 21),  # example input color 4
    (0, 0, 0)      # example input color 5
]

def load_image(image_path):
    return Image.open(image_path)

def save_image(image, save_path):
    image.save(save_path)

def replace_colors(image, input_colors, output_colors):
    image = image.convert('RGBA')
    pixels = image.load()

    # Create a color map by pairing input colors with the output colors
    color_map = {input_color: output_color for input_color, output_color in zip(input_colors, output_colors)}

    for i in range(image.size[0]):
        for j in range(image.size[1]):
            current_color = pixels[i, j]
            if current_color[3] > 0:  # If the pixel is not fully transparent
                rgb_color = current_color[:3]
                if rgb_color in color_map:
                    new_rgb = color_map[rgb_color]
                    pixels[i, j] = (*new_rgb, current_color[3])

    return image

if __name__ == "__main__":
    if len(sys.argv) != 2:
        print("Usage: python script.py <image_path>")
        sys.exit(1)

    image_path = sys.argv[1]
    base_name, ext = os.path.splitext(os.path.basename(image_path))

    # Define output colors for each palette
    colormaps = {
        '4': [(58, 51, 51), (44, 40, 40), (35, 32, 32), (23, 21, 21), (0, 0, 0)], #black
        '1': [(255, 255, 255), (237, 244, 244), (214, 223, 225), (189, 199, 207), (151, 162, 176)], #white
        '5': [(107, 70, 35), (90, 53, 20), (74, 39, 13), (58, 26, 9), (43, 17, 6)], #brown
        '3': [(89, 84, 83), (60, 55, 54), (46, 41, 40), (37, 32, 31), (32, 26, 25)], #gray
        #'3': [(113, 110, 110), (89, 86, 85), (75, 72, 71), (56, 53, 53), (45, 42, 41)], #gray
        '2': [(150, 141, 139), (130, 124, 122), (115, 106, 104), (101, 90, 88), (87, 78, 75)], #light_gray
        #'2': [(192, 189, 191), (167, 165, 176), (140, 138, 153), (119, 118, 134), (95, 95, 112)], #light_gray
        '15': [(250, 203, 215), (247, 180, 214), (224, 147, 190), (203, 116, 171), (173, 83, 129)], #pink
        '14': [(233, 145, 227), (223, 119, 223), (199, 101, 206), (166, 77, 178), (133, 52, 156)], #magenta
        '13': [(176, 100, 216), (151, 86, 201), (127, 71, 181), (106, 59, 162), (80, 45, 139)], #purple
        '12': [(62, 127, 191), (57, 104, 176), (46, 76, 153), (39, 54, 137), (31, 39, 119)], #blue
        '11': [(143, 185, 244), (111, 152, 219), (91, 127, 203), (74, 109, 186), (59, 78, 171)], #light_blue
        '10': [(49, 168, 177), (35, 137, 149), (28, 114, 134), (20, 87, 111), (13, 67, 90)], #cyan
        '9': [(99, 134, 46), (74, 114, 31), (50, 89, 19), (35, 69, 11), (20, 49, 6)], #green
        '0': [(172, 229, 59), (131, 212, 28), (107, 191, 23), (76, 168, 15), (53, 144, 11)], #lime
        '8': [(255, 223, 124), (244, 203, 75), (226, 183, 65), (207, 154, 48), (194, 133, 42)], #yellow
        '7': [(236, 130, 42), (216, 109, 36), (198, 87, 30), (178, 69, 25), (165, 54, 20)], #orange
        '6': [(200, 15, 18), (175, 7, 28), (146, 9, 32), (124, 5, 37), (110, 7, 33)] #red
        #'16': [(240, 227, 220), (240, 190, 233), (208, 161, 241), (186, 146, 241), (160, 122, 214)], #amethyst
        #'17': [(247, 146, 119), (231, 123, 87), (202, 98, 62), (174, 89, 56), (161, 78, 52)], #copper
        #'18': [(229, 255, 250), (180, 253, 238), (107, 243, 227), (74, 237, 217), (48, 208, 190)], #diamond
        #'19': [(181, 252, 208), (52, 236, 121), (22, 220, 97), (7, 185, 59), (7, 152, 45)], #emerald
        #'20': [(255, 255, 255), (253, 255, 118), (255, 240, 90), (255, 216, 61), (224, 178, 48)], #gold
        #'21': [(255, 255, 255), (229, 229, 229), (217, 217, 217), (194, 194, 194), (183, 183, 183)], #iron
        #'22': [(92, 126, 219), (72, 110, 213), (41, 78, 183), (22, 67, 158), (22, 52, 135)], #lapis
        #'23': [(118, 106, 118), (93, 86, 93), (81, 68, 78), (73, 57, 63), (63, 48, 59)], #netherite
        #'24': [(247, 245, 242), (233, 228, 221), (211, 201, 185), (181, 163, 141), (137, 123, 115)], #quartz
        #'25': [(211, 18, 0), (169, 15, 1), (121, 2, 0), (103, 7, 0), (80, 6, 0)] #redstone
    }

    original_image = load_image(image_path)

    # Process each color map using the predefined input colors
    for name, output_colors in colormaps.items():
        if len(output_colors) != len(input_colors):
            print(f"Error: Output color map '{name}' does not have exactly {len(input_colors)} colors.")
            continue

        image_to_process = original_image.copy()
        modified_image = replace_colors(image_to_process, input_colors, output_colors)
        save_path = f'{base_name}_{name}{ext}'
        save_image(modified_image, save_path)
        print(f"Image saved to {save_path}")
