ItemEvents.rightClicked(event => {
  if (event.hand !== "MAIN_HAND") return;

  const player = event.player;
  if (!player) return;

  const main = player.getMainHandItem();
  const off = player.getOffHandItem();

  if (main.id !== "alienevo:omniverse_core" || off.id !== "alienevo:prototype_core") return;

  const omniNBT = main.nbt ?? {};
  const protoNBT = off.nbt ?? {};

  if (!omniNBT.storedAllDNA || !protoNBT.storedAllDNA) {
    player.tell(Text.of("§c[ERROR] Data missing in Completed Core! Please insert into watch first to add in Data!"));
    return;
  }

  var omniData, protoData;
  try {
    omniData = JSON.parse(String(omniNBT.storedAllDNA));
    protoData = JSON.parse(String(protoNBT.storedAllDNA));
  } catch (err) {
    player.tell(Text.of("§c[ERROR] Failed to parse: " + err));
    return;
  }

  // Gather all aliens from all playlists in protoData
  var protoAliens = [];
  for (let playlist in protoData) {
    let pl = protoData[playlist];
    if (typeof pl === 'object') {
      for (let slot in pl) {
        let protoAlien = pl[slot];
        if (protoAlien && protoAlien.alienId) {
          protoAliens.push(protoAlien);
        }
      }
    }
  }

  // Helper to get the next available playlist (2-11, max 10 playlists)
  function getNextAvailablePlaylist(omniData) {
    for (let i = 2; i <= 11; i++) {
      let key = String(i);
      if (!omniData[key]) return key;
      if (Object.keys(omniData[key]).length < 10) return key;
    }
    return null; // All 10 playlists full
  }

  // Ensure playlists 2 and 3 exist
  if (!omniData["2"]) omniData["2"] = {};
  if (!omniData["3"]) omniData["3"] = {};
  var added = 0;

  try {
    for (var i = 0; i < protoAliens.length; i++) {
      var protoAlien = protoAliens[i];
      var alreadyHas = false;
      for (var p in omniData) {
        for (var s in omniData[p]) {
          var existing = omniData[p][s];
          if (existing && existing.alienId === protoAlien.alienId) {
            alreadyHas = true;
            break;
          }
        }
        if (alreadyHas) break;
      }
      if (!alreadyHas) {
        let playlistKey = getNextAvailablePlaylist(omniData);
        if (!playlistKey) {
          player.tell(Text.of("§c[Alien Transfer] Max playlists (10) full, cannot add more aliens."));
          break;
        }
        if (!omniData[playlistKey]) omniData[playlistKey] = {};
        var targetSlot = String(Object.keys(omniData[playlistKey]).length + 1);
        omniData[playlistKey][targetSlot] = { alienId: protoAlien.alienId, alienName: protoAlien.alienName };
        added++;
      }
    }
  } catch (err2) {
    player.tell(Text.of("§c[ERROR] Loop failed: " + err2));
    return;
  }

  try {
    main.nbt.storedAllDNA = JSON.stringify(omniData);
    player.setMainHandItem(main);
    player.tell(Text.of("§a[Alien Transfer] Added " + added + " new aliens!"));
  } catch (err3) {
    player.tell(Text.of("§c[ERROR] Failed to save: " + err3));
  }
});

