ItemEvents.rightClicked(event => {
  if (event.hand !== "MAIN_HAND") return;
  const player = event.player;
  if (!player) return;

  const main = player.getMainHandItem();
  if (main.id !== "aeo:core_scrambler") return;

  let hasSuperpower = false;
  try {
    hasSuperpower = palladium.superpowers.hasSuperpower(player, "aeo:omniverse_omnitrix");
  } catch (e) {}
  if (hasSuperpower) {
    event.server.runCommandSilent(`/alienremoveall ${player.username}`);
    player.tell(Text.of("§cAll alien DNA samples removed!"));
  }
});
