NetworkEvents.dataReceived("aeo_spikes_sync", event => {
    const player = event.player;
    const value = event.data.value;
    if (typeof value === "number" && (value === 0 || value === 1)) {
        const username = player.getGameProfile().getName();
        player.server.runCommandSilent(`scoreboard players set ${username} AEO.Spikes ${value}`);
    }
});

NetworkEvents.dataReceived("aeo_faceplate_sync", event => {
    const player = event.player;
    const value = event.data.value;
    if (typeof value === "number" && value >= 0 && value <= 8) {
        const username = player.getGameProfile().getName();
        player.server.runCommandSilent(`scoreboard players set ${username} AEO.Faceplate ${value}`);
    }
});

NetworkEvents.dataReceived("aeo_suit_click", event => {
    const player = event.player;
    const username = player.getGameProfile().getName();
    player.server.runCommandSilent(`scoreboard players set ${username} AEO.Suit 0`);
    player.persistentData.putBoolean('AEO_Suit', false);
    player.tags.remove('AEO.Suited');
    player.give("aeo:suit_module");
});

NetworkEvents.dataReceived("aeo_breath_click", event => {
    const player = event.player;
    const username = player.getGameProfile().getName();
    player.server.runCommandSilent(`scoreboard players set ${username} AEO.AirBreather 0`);
    player.persistentData.putBoolean('AEO_AirBreather', false);
    player.tags.remove('AEO.AirBreather');
    player.give("aeo:breathing_apparatus_module");
});

NetworkEvents.dataReceived("aeo_bat_click", event => {
    const player = event.player;
    const username = player.getGameProfile().getName();
    player.server.runCommandSilent(`scoreboard players set ${username} AEO.Battery 0`);
    player.persistentData.putBoolean('AEO_Battery', false);
    player.tags.remove('AEO.Battery');
    player.give("aeo:battery_upgrade_module");
});

