const lastDeathTrigger = {};

EntityEvents.death(event => {
	const player = event.player;
	if (!player) return;
	if (!abilityUtil.hasPower(player, 'aeo:omniverse_omnitrix')) return;
	const now = Date.now();
	if (lastDeathTrigger[player.uuid] && now - lastDeathTrigger[player.uuid] < 300000) return;
	lastDeathTrigger[player.uuid] = now;
	player.setHealth(1.0);
	const username = player.getGameProfile().getName();
		player.server.runCommandSilent(`superpower add alienevo:transform_bubble ${username}`);
	
		if (player.isInLava() || player.isOnFire()) {
			player.server.runCommandSilent(`superpower replace aeo:omniverse_omnitrix alienevo_aliens:pyronite ${username}`);
		} else if (player.isInWater()) {
			player.server.runCommandSilent(`superpower replace aeo:omniverse_omnitrix alienevo_aliens:piscciss_volann ${username}`);
		} else if ((event.damageSource && event.damageSource.type == "fall") || player.fallDistance > 2) {
			const arr = ["necrofriggian", "ectonurite", "aerophibian", "lepidopterran"];
			const chosen = arr[Math.floor(Math.random() * arr.length)];
			player.server.runCommandSilent(`superpower replace aeo:omniverse_omnitrix alienevo_aliens:${chosen} ${username}`);
		} else {
			const arr2 = ["arburian_pelarota", "tetramand", "petrosapien"];
			const chosen2 = arr2[Math.floor(Math.random() * arr2.length)];
			player.server.runCommandSilent(`superpower replace aeo:omniverse_omnitrix alienevo_aliens:${chosen2} ${username}`);
		}
		player.server.runCommandSilent(`playsound alienevo:prototype_failsafe master ${username} ${player.x} ${player.y} ${player.z}`);
		
	event.cancel();
});
