function performRandomizerTransformForPlayer(player, server) {
  try {
    if (!player.tags || !player.tags.contains("Omniverse.Randomizer")) return false;

    var watchType = "unknown";
    try { watchType = String(palladium.getProperty(player, "watch")); } catch (e) { }
    if (watchType !== "omniverse") return false;
    var username = "";
    try { username = player.getGameProfile().getName(); } catch (e) { username = String(player.name || ""); }
    var detransformCooldown = player.persistentData.getInt("Randomizer.DetransformPause") || 0;
    if (detransformCooldown > server.getTickCount()) {
      return false;
    }

    
    var lastTransformTime = player.persistentData.getInt("Randomizer.LastTransformTime") || 0;
    if (server.getTickCount() - lastTransformTime < 40) { 
      return false;
    }

    
    var currentPlaylist = player.persistentData.getInt('current_playlist') || 1;
    var currentAlienSlot = player.persistentData.getInt('current_alien_slot') || 1;

    
    var availablePlaylists = [];
    for (var p = 1; p <= 10; p++) {
      var hasAliens = false;
      for (var s = 1; s <= 10; s++) {
        var alienKey = "alienevo.alien_" + p + "_" + s;
        var alienId = player.persistentData.getInt(alienKey);
        if (alienId && alienId > 0) {
          hasAliens = true;
          break;
        }
      }
      if (hasAliens) {
        availablePlaylists.push(p);
      }
    }

    if (availablePlaylists.length === 0) {
      return false;
    }

    
    var randomPlaylist = availablePlaylists[Math.floor(Math.random() * availablePlaylists.length)];
    
    
    var availableSlots = [];
    for (var s = 1; s <= 10; s++) {
      var alienKey = "alienevo.alien_" + randomPlaylist + "_" + s;
      var alienId = player.persistentData.getInt(alienKey);
      if (alienId && alienId > 0) {
        availableSlots.push(s);
      }
    }

    if (availableSlots.length === 0) {
      return false;
    }

    
    var randomSlot = availableSlots[Math.floor(Math.random() * availableSlots.length)];
    
    
    if (randomPlaylist === currentPlaylist && randomSlot === currentAlienSlot && availablePlaylists.length > 1) {
      
      for (var attempts = 0; attempts < 10; attempts++) {
        randomPlaylist = availablePlaylists[Math.floor(Math.random() * availablePlaylists.length)];
        availableSlots = [];
        for (var s = 1; s <= 10; s++) {
          var alienKey = "alienevo.alien_" + randomPlaylist + "_" + s;
          var alienId = player.persistentData.getInt(alienKey);
          if (alienId && alienId > 0) {
            availableSlots.push(s);
          }
        }
        if (availableSlots.length > 0) {
          randomSlot = availableSlots[Math.floor(Math.random() * availableSlots.length)];
          if (!(randomPlaylist === currentPlaylist && randomSlot === currentAlienSlot)) {
            break;
          }
        }
      }
    }

    
    var selectedAlienKey = "alienevo.alien_" + randomPlaylist + "_" + randomSlot;
    var selectedAlienId = player.persistentData.getInt(selectedAlienKey);
    
    if (!selectedAlienId || selectedAlienId <= 0) {
      return false;
    }

    
    var alienName = "alien_" + selectedAlienId;
    var alienNamespace = "alienevo_aliens";
    
    
    var nameKey = "alienevo.alien_name_" + selectedAlienId;
    var storedName = player.persistentData.getString(nameKey);
    if (storedName && storedName !== "") {
      alienName = storedName;
    }

    var nsRaw = player.persistentData.getString("storedAlienNamespaces");
    if (nsRaw && nsRaw.length > 5) {
      try {
        var nsMap = JSON.parse(nsRaw);
        if (nsMap[selectedAlienId] && nsMap[selectedAlienId].namespace) {
          alienNamespace = nsMap[selectedAlienId].namespace;
        }
      } catch (e) { }
    }

    var alienInfo = global['alienevo_alien_' + selectedAlienId];
    if (alienInfo && alienInfo[0]) {
      var fullName = String(alienInfo[0]);
      if (fullName.indexOf(':') !== -1) {
        var parts = fullName.split(':');
        alienNamespace = parts[0];
        alienName = parts[1];
      } else {
        alienName = fullName;
      }
    }

    var chosenAlien = alienNamespace + ":" + alienName;

    if (chosenAlien.toLowerCase() === "mypowers:celestialsapien" || selectedAlienId === 141) {
      return false;
    }

    var fromAlias = "aeo:omniverse_omnitrix";
    
    var knownAlienPowers = [];
    for (var p = 1; p <= 10; p++) {
      for (var s = 1; s <= 10; s++) {
        var alienKey = "alienevo.alien_" + p + "_" + s;
        var alienId = player.persistentData.getInt(alienKey);
        if (alienId && alienId > 0) {
          var alienName = "alien_" + alienId;
          var alienNamespace = "alienevo_aliens";
          
          var nameKey = "alienevo.alien_name_" + alienId;
          var storedName = player.persistentData.getString(nameKey);
          if (storedName && storedName !== "") {
            alienName = storedName;
          }
          
          var nsRaw = player.persistentData.getString("storedAlienNamespaces");
          if (nsRaw && nsRaw.length > 5) {
            try {
              var nsMap = JSON.parse(nsRaw);
              if (nsMap[alienId] && nsMap[alienId].namespace) {
                alienNamespace = nsMap[alienId].namespace;
              }
            } catch (e) { }
          }
          
          var alienInfo = global['alienevo_alien_' + alienId];
          if (alienInfo && alienInfo[0]) {
            var fullName = String(alienInfo[0]);
            if (fullName.indexOf(':') !== -1) {
              var parts = fullName.split(':');
              alienNamespace = parts[0];
              alienName = parts[1];
            } else {
              alienName = fullName;
            }
          }
          
          var alienPower = alienNamespace + ":" + alienName;
          if (knownAlienPowers.indexOf(alienPower.toLowerCase()) === -1) {
            knownAlienPowers.push(alienPower.toLowerCase());
          }
        }
      }
    }
    
    try {
      var currentPowers = palladium.powers.getPowerIds(player);
      if (currentPowers && currentPowers.length > 0) {
        for (var ci = 0; ci < currentPowers.length; ci++) {
          var pw = String(currentPowers[ci]);
          var pwLower = pw.toLowerCase();
          
          if (pwLower === "aeo:omniverse_omnitrix") {
            fromAlias = pw;
            break;
          } else if (knownAlienPowers.indexOf(pwLower) !== -1) {
            fromAlias = pw;
            break;
          }
        }
      }
    } catch (errPowers) { 
    }

    if (chosenAlien.toLowerCase() === fromAlias.toLowerCase()) {
      return false;
    }

    try {
      var allPowers = palladium.powers.getPowerIds(player);
      if (allPowers && allPowers.length > 0) {
        var lowerChosenName = String(chosenAlien).split(":")[1].toLowerCase();
        for (var pi = 0; pi < allPowers.length; pi++) {
          var pw2 = String(allPowers[pi]);
          if (pw2.toLowerCase().endsWith(":" + lowerChosenName)) {
            chosenAlien = pw2;
            break;
          }
        }
      }
    } catch (eAuto) { 
    }

    var cmd;
    var hasOmnitrix = false;
    var currentPowers = palladium.powers.getPowerIds(player);
    if (currentPowers && currentPowers.length > 0) {
      for (var ci = 0; ci < currentPowers.length; ci++) {
        var pw = String(currentPowers[ci]);
        if (pw.toLowerCase() === "aeo:omniverse_omnitrix") {
          hasOmnitrix = true;
          break;
        }
      }
    }
    
    if (hasOmnitrix) {
      try { player.removeTag("AlienEvo.BaseForm"); } catch (e) { }
      cmd = `superpower replace aeo:omniverse_omnitrix ` + chosenAlien + ` ` + username;
    } else {
      cmd = `superpower replace ` + fromAlias + ` ` + chosenAlien + ` ` + username;
    }
    
    try {
      player.server.runCommandSilent(cmd);
    } catch (e) {
      try { 
        server.runCommandSilent(cmd); 
      } catch (ee) { 
        return false;
      }
    }
    
    player.persistentData.putInt("Randomizer.LastTransformTime", server.getTickCount());
    
    
    try {
      player.server.runCommandSilent(`superpower add alienevo:transform_bubble ` + username);
    } catch (e) {
      try { server.runCommandSilent(`superpower add alienevo:transform_bubble ` + username); } catch (ee) { }
    }
    try {
      player.server.runCommandSilent("playsound alienevo:randomized master " + username + " " + player.x + " " + player.y + " " + player.z);
    } catch (e) {
      try { server.runCommandSilent("playsound alienevo:randomized master " + username + " " + player.x + " " + player.y + " " + player.z); } catch (ee) { }
    }

    player.persistentData.putInt('current_playlist', randomPlaylist);
    player.persistentData.putInt('current_alien_slot', randomSlot);
    
    palladium.setProperty(player, 'omnitrix_cycle', randomSlot);
    
    for (var slot = 1; slot <= 10; slot++) {
        var alienKey = 'alienevo.alien_' + randomPlaylist + '_' + slot;
        var storedAlienId = player.persistentData.getInt(alienKey);
        palladium.setProperty(player, 'alien_evo_slot_' + slot, storedAlienId || 0);
      }

    var pdataMem = player.persistentData;
    pdataMem.putString("Randomizer.LastAlien", chosenAlien);
    pdataMem.putString("Randomizer.LastPlaylist", String(randomPlaylist));
    pdataMem.putString("Randomizer.LastSlot", String(randomSlot));

    var randSeconds = 1 + Math.floor(Math.random() * 60);
    try {
      pdataMem.putInt("Randomizer.NextTick", server.getTickCount() + (randSeconds * 20));
    } catch (e) {
    }

    try {
      var fromDisplay = fromAlias.split(":")[1] || fromAlias;
      var toDisplay = chosenAlien.split(":")[1] || chosenAlien;
      
    } catch (e) {
    }

    return true;
  } catch (errGlobal) {
    var username = "";
    try { username = player.getGameProfile().getName(); } catch (e) { username = "Unknown"; }
    return false;
  }
}

function disableRandomizerForPlayer(player, message) {
  try {
    var username = "";
    try { username = player.getGameProfile().getName(); } catch (e) { username = String(player.name || "Unknown"); }
    
    
    try {
      
      var knownAlienPowers = [];
      
      
      for (var p = 1; p <= 10; p++) {
        for (var s = 1; s <= 10; s++) {
          var alienKey = "alienevo.alien_" + p + "_" + s;
          var alienId = player.persistentData.getInt(alienKey);
          if (alienId && alienId > 0) {
            
            var alienName = "alien_" + alienId;
            var alienNamespace = "alienevo_aliens";
            
            
            var nameKey = "alienevo.alien_name_" + alienId;
            var storedName = player.persistentData.getString(nameKey);
            if (storedName && storedName !== "") {
              alienName = storedName;
            }
            
            
            var nsRaw = player.persistentData.getString("storedAlienNamespaces");
            if (nsRaw && nsRaw.length > 5) {
              try {
                var nsMap = JSON.parse(nsRaw);
                if (nsMap[alienId] && nsMap[alienId].namespace) {
                  alienNamespace = nsMap[alienId].namespace;
                }
              } catch (e) { }
            }
            var alienInfo = global['alienevo_alien_' + alienId];
            if (alienInfo && alienInfo[0]) {
              var fullName = String(alienInfo[0]);
              if (fullName.indexOf(':') !== -1) {
                var parts = fullName.split(':');
                alienNamespace = parts[0];
                alienName = parts[1];
              } else {
                alienName = fullName;
              }
            }
            
            var alienPower = alienNamespace + ":" + alienName;
            if (knownAlienPowers.indexOf(alienPower.toLowerCase()) === -1) {
              knownAlienPowers.push(alienPower.toLowerCase());
            }
          }
        }
      }
      
      var currentPowers = palladium.powers.getPowerIds(player);
      if (currentPowers && currentPowers.length > 0) {
        for (var i = 0; i < currentPowers.length; i++) {
          var pw = String(currentPowers[i]);
          var pwLower = pw.toLowerCase();
          
          if (pwLower !== "aeo:omniverse_omnitrix" && knownAlienPowers.indexOf(pwLower) !== -1) {
            
            var detransformCmd = `superpower replace ${pw} aeo:omniverse_omnitrix ${username}`;
            
            try {
              player.server.runCommandSilent(detransformCmd);
              try { player.addTag("AlienEvo.BaseForm"); } catch (e) { }
            } catch (e) {
              try { 
                player.server.runCommandSilent(detransformCmd); 
                try { player.addTag("AlienEvo.BaseForm"); } catch (ee) { }
              } catch (ee) { 
              }
            }
            break;
          }
        }
      }
    } catch (errDetransform) {
    }

    try { player.removeTag("Omniverse.Randomizer"); } catch (e) { }

    var skipMaster = false;
    try { skipMaster = player.tags && player.tags.contains("AlienEvo.MasterControl"); } catch (e) { skipMaster = false; }
    
    var hadMasterControl = player.persistentData.getInt("Randomizer.StoredMasterControl") || 0;
    if (!hadMasterControl) {
      try {
        player.server.runCommandSilent(`scoreboard players set ${username} AlienEvo.Timer 3000`);
      } catch (e) {
        try { player.runCommandSilent("scoreboard players set @s AlienEvo.Timer 3000"); } catch (ee) { }
      }
    }

    try { player.tell(Text.of(message || "§c[Omnitrix] Randomizer Disabled.")); } catch (e) { }
    try { player.persistentData.remove("Randomizer.NextTick"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.InitialTriggered"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.CheckTick"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.LastAlien"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.DetransformPause"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.LastTransformTime"); } catch (e) { }
  } catch (err) {
  }
}

ServerEvents.tick(function (event) {
  if (event.server.getTickCount() % 100 !== 0) return;
  var server = event.server;
  var players = server.players;
  for (var i = 0; i < players.length; i++) {
    var player = players[i];
    try {
      if (!player.tags || !player.tags.contains("Omniverse.Randomizer")) continue;
      var next = player.persistentData.getInt("Randomizer.NextTick") || 0;
      if (next > server.getTickCount()) continue;

      performRandomizerTransformForPlayer(player, server);
    } catch (e) {  }
  }
});

ServerEvents.tick(function (event) {
  if (event.server.getTickCount() % 1 !== 0) return;
  var server = event.server;
  var players = server.players;
  for (var i = 0; i < players.length; i++) {
    var player = players[i];
    try {
      if (player.tags && player.tags.contains("Omniverse.Randomizer")) {
        try {
          var checkTick = player.persistentData.getInt("Randomizer.CheckTick") || 0;
          if (!checkTick) {
            player.persistentData.putInt("Randomizer.CheckTick", server.getTickCount() + 5);
          } else if (server.getTickCount() >= checkTick) {
            var hasTransform = false;
            try { hasTransform = player.tags.contains("AlienEvo.Transformation"); } catch (ee) { hasTransform = false; }
            if (!hasTransform) {
              disableRandomizerForPlayer(player, "§c[Omnitrix] Randomizer Disabled.");
              continue;
            } else {
              try { player.persistentData.remove("Randomizer.CheckTick"); } catch (e) { }
            }
          }
        } catch (e) {  }
      } else {
        try { player.persistentData.remove("Randomizer.InitialTriggered"); } catch (e) { }
        continue;
      }
      try {
        var usernameTimer = player.getGameProfile().getName();
        player.server.runCommandSilent(`scoreboard players set ${usernameTimer} AlienEvo.Timer 10`);
      } catch (e) {
        try { player.runCommandSilent("scoreboard players set @s AlienEvo.Timer 10"); } catch (ee) { }
      }
      var init = player.persistentData.getInt("Randomizer.InitialTriggered") || 0;
      if (init) continue;

      var hasMasterControl = false;
      try { hasMasterControl = player.tags && player.tags.contains("AlienEvo.MasterControl"); } catch (e) { }
      if (hasMasterControl) {
        player.persistentData.putInt("Randomizer.StoredMasterControl", 1);
        try { 
          player.removeTag("AlienEvo.MasterControl"); 
        } catch (e) { }
      } else {
        player.persistentData.putInt("Randomizer.StoredMasterControl", 0);
      }

      var did = performRandomizerTransformForPlayer(player, server);
      if (did) {
        try { player.tell(Text.of("§a[Omnitrix] Randomizer Enabled. [Press Quick Change Wheel to disable]")); } catch (e) { }
        try { player.persistentData.putInt("Randomizer.InitialTriggered", 1); } catch (e) { }
      }
    } catch (err) {  }
  }
});

NetworkEvents.dataReceived('quickchange_wheel_pressed', event => {
    var player = event.player;

    try {
        if (player.tags.contains("Omniverse.Randomizer")) {
            var hadMasterControl = player.persistentData.getInt("Randomizer.StoredMasterControl") || 0;
            
            disableRandomizerForPlayer(player, "§c[Omnitrix] Randomizer Disabled.");
            
            var username = "";
            try { username = player.getGameProfile().getName(); } catch (e) { username = "Unknown"; }
            
            try {
              player.server.runCommandSilent(`superpower add alienevo:transform_bubble ${username}`);
              player.server.runCommandSilent(`playsound alienevo:omniverse_detransform master ${username} ${player.x} ${player.y} ${player.z}`);
            } catch (e) {
              try { 
                player.server.runCommandSilent(`superpower add alienevo:transform_bubble ${username}`);
                player.server.runCommandSilent(`playsound alienevo:omniverse_detransform master ${username} ${player.x} ${player.y} ${player.z}`);
              } catch (ee) { }
            }
            
            if (hadMasterControl) {
                try { 
                    player.addTag("AlienEvo.MasterControl"); 
                } catch (e) { }
            }
            
            try { player.persistentData.remove("Randomizer.StoredMasterControl"); } catch (e) { }
            
            if (!hadMasterControl) {
                try {
                    player.server.runCommandSilent(`scoreboard players set ${username} AEO.Recharge 1`);
                    player.server.runCommandSilent(`scoreboard players set ${username} AlienEvo.Timer 3000`);
                } catch (e) {
                    try { 
                        player.runCommandSilent("scoreboard players set @s AEO.Recharge 1");
                        player.runCommandSilent("scoreboard players set @s AlienEvo.Timer 3000");
                    } catch (ee) { }
                }
            }
            
            return;
        }

    } catch (err) {
    }
});

EntityEvents.death(event => {
  try {
    var player = event.player;
    if (!player) return;
    if (!player.tags || !player.tags.contains("Omniverse.Randomizer")) return;

    try {
      var username = player.getGameProfile().getName();
      
      var knownAlienPowers = [];
      for (var p = 1; p <= 10; p++) {
        for (var s = 1; s <= 10; s++) {
          var alienKey = "alienevo.alien_" + p + "_" + s;
          var alienId = player.persistentData.getInt(alienKey);
          if (alienId && alienId > 0) {
            var alienName = "alien_" + alienId;
            var alienNamespace = "alienevo_aliens";
            
            var nameKey = "alienevo.alien_name_" + alienId;
            var storedName = player.persistentData.getString(nameKey);
            if (storedName && storedName !== "") {
              alienName = storedName;
            }
            
            var nsRaw = player.persistentData.getString("storedAlienNamespaces");
            if (nsRaw && nsRaw.length > 5) {
              try {
                var nsMap = JSON.parse(nsRaw);
                if (nsMap[alienId] && nsMap[alienId].namespace) {
                  alienNamespace = nsMap[alienId].namespace;
                }
              } catch (e) { }
            }
            
            var alienInfo = global['alienevo_alien_' + alienId];
            if (alienInfo && alienInfo[0]) {
              var fullName = String(alienInfo[0]);
              if (fullName.indexOf(':') !== -1) {
                var parts = fullName.split(':');
                alienNamespace = parts[0];
                alienName = parts[1];
              } else {
                alienName = fullName;
              }
            }
            
            var alienPower = alienNamespace + ":" + alienName;
            if (knownAlienPowers.indexOf(alienPower.toLowerCase()) === -1) {
              knownAlienPowers.push(alienPower.toLowerCase());
            }
          }
        }
      }
      
      var currentPowers = palladium.powers.getPowerIds(player);
      if (currentPowers && currentPowers.length > 0) {
        for (var i = 0; i < currentPowers.length; i++) {
          var pw = String(currentPowers[i]);
          var pwLower = pw.toLowerCase();
          
          if (pwLower !== "aeo:omniverse_omnitrix" && knownAlienPowers.indexOf(pwLower) !== -1) {
            player.server.runCommandSilent(`superpower replace ${pw} aeo:omniverse_omnitrix ${username}`);
            player.addTag("AlienEvo.BaseForm");
            break;
          }
        }
      }
    } catch (e) {
      try {
        player.server.runCommandSilent(`superpower replace * aeo:omniverse_omnitrix ${username}`);
        player.addTag("AlienEvo.BaseForm");
      } catch (ee) { }
    }

    try { player.removeTag("Omniverse.Randomizer"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.NextTick"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.InitialTriggered"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.LastAlien"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.CheckTick"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.DetransformPause"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.LastTransformTime"); } catch (e) { }
    try { player.persistentData.remove("Randomizer.StoredMasterControl"); } catch (e) { }

    try {
      var username = player.getGameProfile().getName();
      
      var hasMasterControl = false;
      try { hasMasterControl = player.tags && player.tags.contains("AlienEvo.MasterControl"); } catch (e) { }
      
      if (!hasMasterControl) {
        player.server.runCommandSilent(`scoreboard players set ${username} AlienEvo.Timer 3000`);
        player.server.runCommandSilent(`scoreboard players set ${username} AEO.Recharge 1`);
      } else {
        player.server.runCommandSilent(`scoreboard players set ${username} AEO.Recharge 1`);
        player.server.runCommandSilent(`scoreboard players set ${username} AlienEvo.Timer 6000`);
      }
    } catch (e) {
      try { 
        player.runCommandSilent("scoreboard players set @s AEO.Recharge 1");
        player.runCommandSilent("scoreboard players set @s AlienEvo.Timer 3000");
      } catch (ee) { }
    }

  } catch (err) {
  }
});

