ItemEvents.rightClicked('aeo:randomizer_code_tablet', event => {
    const player = event.player;
    const item = event.item;
    
    if (!item.hasNBT() && player.persistentData.randomizerTargetCode) {
        let randomizerCode = player.persistentData.randomizerTargetCode;
        
        if (!global.usedPositions) {
            global.usedPositions = new Set();
        }
        
        let availablePositions = [];
        for (let i = 0; i < 6; i++) {
            if (!global.usedPositions.has(i)) {
                availablePositions.push(i);
            }
        }
        
        if (availablePositions.length === 0) {
            global.usedPositions.clear();
            availablePositions = [0, 1, 2, 3, 4, 5];
        }
        
        let selectedPosition = availablePositions[Math.floor(Math.random() * availablePositions.length)];
        global.usedPositions.add(selectedPosition);
        
        let display = [];
        for(let i = 0; i < 6; i++) {
            if(i === selectedPosition) {
                display.push(`{"text":"${randomizerCode[i]}","color":"green"}`);
            } else {
                display.push(`{"text":"§k0","color":"green"}`);
            }
        }
        
        item.nbt = {
            used: true,
            position: selectedPosition,
            display: {
                Lore: [
                    '{"translate":"codehints.alienevo.randomizer","color":"material_emerald","italic":false}',
                    `{"translate":"codehints.alienevo.code","color":"yellow","italic":false,"extra":[${display.join(',')}]}`
                ]
            }
        }; 
    }
});

