/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lifecrystals.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="life_crystals", bus=EventBusSubscriber.Bus.MOD)
public class LifeCrystalsModLootModifier {
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"life_crystals");

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        event.enqueueWork(() -> {
            LOOT_MODIFIER.register("life_crystals_loot_modifier", LifeCrystalsModLootTableModifier.CODEC);
            LOOT_MODIFIER.register(bus);
        });
    }

    public static class LifeCrystalsModLootTableModifier
    extends LootModifier {
        public static final Supplier<MapCodec<LifeCrystalsModLootTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.CODEC.fieldOf("lootTable").forGetter(m -> m.lootTable)).apply((Applicative)instance, LifeCrystalsModLootTableModifier::new)));
        private final ResourceLocation lootTable;

        public LifeCrystalsModLootTableModifier(LootItemCondition[] conditions, ResourceLocation lootTable) {
            super(conditions);
            this.lootTable = lootTable;
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ((LootTable)((Holder.Reference)context.getResolver().get(Registries.LOOT_TABLE, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable)).get()).value()).getRandomItemsRaw(context, arg_0 -> generatedLoot.add(arg_0));
            return generatedLoot;
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

