/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lifecrystals.network;

import java.util.function.Supplier;
import net.mcreator.lifecrystals.LifeCrystalsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class LifeCrystalsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"life_crystals");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LifeCrystalsMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        LifeCrystalsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("life_crystals", "saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("life_crystals", "player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double player_current_max_hp = 20.0;
        public double player_added_hp = 0.0;
        public boolean life_crystal_used = false;
        public boolean golden_life_crystal_used = false;
        public boolean Diamond_life_crystal_used = false;
        public boolean Netherite_life_crystal_used = false;
        public boolean dragon_heart_used = false;
        public boolean withered_heart_used = false;
        public boolean sculk_heart_used = false;
        public boolean infinity_heart_first_use = true;
        public boolean royal_heart_used = false;
        public boolean heart_of_the_elder_guardian_used = false;
        public boolean heart_of_many_hearts_used = false;
        public boolean Heart_of_fire_used = false;
        public double health_crystals_used = 0.0;
        public boolean heart_of_the_ocean_used = false;
        public boolean amethyst_life_crystal_used = false;
        public double infinity_hearts_used = 0.0;
        public boolean emerald_life_crystal_used = false;
        public boolean lapiz_life_crystal_used = false;
        public boolean Magic_life_crystal_used = false;
        public boolean heart_of_knowledge_used = false;
        public boolean heart_of_the_end_used = false;
        public boolean heart_of_souls_used = false;
        public boolean nether_heart_used = false;
        public boolean addon_magnetic_heart_used = false;
        public boolean addon_radioactive_heart_used = false;
        public boolean heart_of_the_overworld_used = false;
        public boolean heart_of_thunder_used = false;
        public boolean heart_of_rain_used = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("player_current_max_hp", this.player_current_max_hp);
            nbt.putDouble("player_added_hp", this.player_added_hp);
            nbt.putBoolean("life_crystal_used", this.life_crystal_used);
            nbt.putBoolean("golden_life_crystal_used", this.golden_life_crystal_used);
            nbt.putBoolean("Diamond_life_crystal_used", this.Diamond_life_crystal_used);
            nbt.putBoolean("Netherite_life_crystal_used", this.Netherite_life_crystal_used);
            nbt.putBoolean("dragon_heart_used", this.dragon_heart_used);
            nbt.putBoolean("withered_heart_used", this.withered_heart_used);
            nbt.putBoolean("sculk_heart_used", this.sculk_heart_used);
            nbt.putBoolean("infinity_heart_first_use", this.infinity_heart_first_use);
            nbt.putBoolean("royal_heart_used", this.royal_heart_used);
            nbt.putBoolean("heart_of_the_elder_guardian_used", this.heart_of_the_elder_guardian_used);
            nbt.putBoolean("heart_of_many_hearts_used", this.heart_of_many_hearts_used);
            nbt.putBoolean("Heart_of_fire_used", this.Heart_of_fire_used);
            nbt.putDouble("health_crystals_used", this.health_crystals_used);
            nbt.putBoolean("heart_of_the_ocean_used", this.heart_of_the_ocean_used);
            nbt.putBoolean("amethyst_life_crystal_used", this.amethyst_life_crystal_used);
            nbt.putDouble("infinity_hearts_used", this.infinity_hearts_used);
            nbt.putBoolean("emerald_life_crystal_used", this.emerald_life_crystal_used);
            nbt.putBoolean("lapiz_life_crystal_used", this.lapiz_life_crystal_used);
            nbt.putBoolean("Magic_life_crystal_used", this.Magic_life_crystal_used);
            nbt.putBoolean("heart_of_knowledge_used", this.heart_of_knowledge_used);
            nbt.putBoolean("heart_of_the_end_used", this.heart_of_the_end_used);
            nbt.putBoolean("heart_of_souls_used", this.heart_of_souls_used);
            nbt.putBoolean("nether_heart_used", this.nether_heart_used);
            nbt.putBoolean("addon_magnetic_heart_used", this.addon_magnetic_heart_used);
            nbt.putBoolean("addon_radioactive_heart_used", this.addon_radioactive_heart_used);
            nbt.putBoolean("heart_of_the_overworld_used", this.heart_of_the_overworld_used);
            nbt.putBoolean("heart_of_thunder_used", this.heart_of_thunder_used);
            nbt.putBoolean("heart_of_rain_used", this.heart_of_rain_used);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.player_current_max_hp = nbt.getDouble("player_current_max_hp");
            this.player_added_hp = nbt.getDouble("player_added_hp");
            this.life_crystal_used = nbt.getBoolean("life_crystal_used");
            this.golden_life_crystal_used = nbt.getBoolean("golden_life_crystal_used");
            this.Diamond_life_crystal_used = nbt.getBoolean("Diamond_life_crystal_used");
            this.Netherite_life_crystal_used = nbt.getBoolean("Netherite_life_crystal_used");
            this.dragon_heart_used = nbt.getBoolean("dragon_heart_used");
            this.withered_heart_used = nbt.getBoolean("withered_heart_used");
            this.sculk_heart_used = nbt.getBoolean("sculk_heart_used");
            this.infinity_heart_first_use = nbt.getBoolean("infinity_heart_first_use");
            this.royal_heart_used = nbt.getBoolean("royal_heart_used");
            this.heart_of_the_elder_guardian_used = nbt.getBoolean("heart_of_the_elder_guardian_used");
            this.heart_of_many_hearts_used = nbt.getBoolean("heart_of_many_hearts_used");
            this.Heart_of_fire_used = nbt.getBoolean("Heart_of_fire_used");
            this.health_crystals_used = nbt.getDouble("health_crystals_used");
            this.heart_of_the_ocean_used = nbt.getBoolean("heart_of_the_ocean_used");
            this.amethyst_life_crystal_used = nbt.getBoolean("amethyst_life_crystal_used");
            this.infinity_hearts_used = nbt.getDouble("infinity_hearts_used");
            this.emerald_life_crystal_used = nbt.getBoolean("emerald_life_crystal_used");
            this.lapiz_life_crystal_used = nbt.getBoolean("lapiz_life_crystal_used");
            this.Magic_life_crystal_used = nbt.getBoolean("Magic_life_crystal_used");
            this.heart_of_knowledge_used = nbt.getBoolean("heart_of_knowledge_used");
            this.heart_of_the_end_used = nbt.getBoolean("heart_of_the_end_used");
            this.heart_of_souls_used = nbt.getBoolean("heart_of_souls_used");
            this.nether_heart_used = nbt.getBoolean("nether_heart_used");
            this.addon_magnetic_heart_used = nbt.getBoolean("addon_magnetic_heart_used");
            this.addon_radioactive_heart_used = nbt.getBoolean("addon_radioactive_heart_used");
            this.heart_of_the_overworld_used = nbt.getBoolean("heart_of_the_overworld_used");
            this.heart_of_thunder_used = nbt.getBoolean("heart_of_thunder_used");
            this.heart_of_rain_used = nbt.getBoolean("heart_of_rain_used");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "life_crystals_mapvars";
        public double maximum_life_crystals_allowed = 50.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.maximum_life_crystals_allowed = nbt.getDouble("maximum_life_crystals_allowed");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("maximum_life_crystals_allowed", this.maximum_life_crystals_allowed);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "life_crystals_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.player_current_max_hp = original.player_current_max_hp;
            clone.player_added_hp = original.player_added_hp;
            clone.life_crystal_used = original.life_crystal_used;
            clone.golden_life_crystal_used = original.golden_life_crystal_used;
            clone.Diamond_life_crystal_used = original.Diamond_life_crystal_used;
            clone.Netherite_life_crystal_used = original.Netherite_life_crystal_used;
            clone.dragon_heart_used = original.dragon_heart_used;
            clone.withered_heart_used = original.withered_heart_used;
            clone.sculk_heart_used = original.sculk_heart_used;
            clone.infinity_heart_first_use = original.infinity_heart_first_use;
            clone.royal_heart_used = original.royal_heart_used;
            clone.heart_of_the_elder_guardian_used = original.heart_of_the_elder_guardian_used;
            clone.heart_of_many_hearts_used = original.heart_of_many_hearts_used;
            clone.Heart_of_fire_used = original.Heart_of_fire_used;
            clone.health_crystals_used = original.health_crystals_used;
            clone.heart_of_the_ocean_used = original.heart_of_the_ocean_used;
            clone.amethyst_life_crystal_used = original.amethyst_life_crystal_used;
            clone.infinity_hearts_used = original.infinity_hearts_used;
            clone.emerald_life_crystal_used = original.emerald_life_crystal_used;
            clone.lapiz_life_crystal_used = original.lapiz_life_crystal_used;
            clone.Magic_life_crystal_used = original.Magic_life_crystal_used;
            clone.heart_of_knowledge_used = original.heart_of_knowledge_used;
            clone.heart_of_the_end_used = original.heart_of_the_end_used;
            clone.heart_of_souls_used = original.heart_of_souls_used;
            clone.nether_heart_used = original.nether_heart_used;
            clone.addon_magnetic_heart_used = original.addon_magnetic_heart_used;
            clone.addon_radioactive_heart_used = original.addon_radioactive_heart_used;
            clone.heart_of_the_overworld_used = original.heart_of_the_overworld_used;
            clone.heart_of_thunder_used = original.heart_of_thunder_used;
            clone.heart_of_rain_used = original.heart_of_rain_used;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

