/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.core.ItemStackKJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.ingredient.CreativeTabIngredient;
import dev.latvian.mods.kubejs.ingredient.NamespaceIngredient;
import dev.latvian.mods.kubejs.ingredient.RegExIngredient;
import dev.latvian.mods.kubejs.ingredient.WildcardIngredient;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ItemWrapper;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

@Info(value="Various Ingredient related helper methods")
public interface IngredientWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(Ingredient.class);
    @Info(value="A completely empty ingredient that will only match air")
    public static final Ingredient none = Ingredient.EMPTY;
    @Info(value="An ingredient that matches everything")
    public static final Ingredient all = WildcardIngredient.INSTANCE.toVanilla();

    @Info(value="Returns an ingredient of the input")
    public static Ingredient of(Ingredient ingredient) {
        return ingredient;
    }

    @Info(value="Returns an ingredient of the input, with the specified count")
    public static SizedIngredient of(Ingredient ingredient, int count) {
        return ingredient.kjs$withCount(count);
    }

    @Info(value="Returns an ingredient that accepts the given set of items under the given component filter.")
    public static Ingredient withData(HolderSet<Item> base, DataComponentMap data) {
        return IngredientWrapper.withData(base, data, false);
    }

    @Info(value="Returns an ingredient that accepts the given set of items under the given (optionally strict) component filter.")
    public static Ingredient withData(HolderSet<Item> base, DataComponentMap data, boolean strict) {
        return DataComponentIngredient.of((boolean)strict, (DataComponentMap)data, base);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @HideFromJS
    private static Ingredient wrapTrivial(@Nullable Object from) {
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        Object object = from;
        int n = 0;
        block12: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ingredient.class, ItemStack.class, ItemLike.class, IngredientSupplierKJS.class, ItemLike.class, TagKey.class}, (Object)object, n)) {
                case -1: {
                    Ingredient ingredient = Ingredient.EMPTY;
                    return ingredient;
                }
                case 0: {
                    Ingredient id;
                    Ingredient ingredient = id = (Ingredient)object;
                    return ingredient;
                }
                case 1: {
                    Ingredient ingredient;
                    ItemStack s = (ItemStack)object;
                    if (s.isEmpty()) {
                        ingredient = Ingredient.EMPTY;
                        return ingredient;
                    }
                    n = 2;
                    continue block12;
                }
                case 2: {
                    Ingredient ingredient;
                    ItemLike i = (ItemLike)object;
                    if (i.asItem() == Items.AIR) {
                        ingredient = Ingredient.EMPTY;
                        return ingredient;
                    }
                    n = 3;
                    continue block12;
                }
                case 3: {
                    IngredientSupplierKJS ingr = (IngredientSupplierKJS)object;
                    Ingredient ingredient = ingr.kjs$asIngredient();
                    return ingredient;
                }
                case 4: {
                    ItemLike i = (ItemLike)object;
                    Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{i});
                    return ingredient;
                }
                case 5: {
                    ResourceKey location;
                    TagKey tagKey = (TagKey)object;
                    try {
                        ResourceKey resourceKey;
                        ResourceKey reg = resourceKey = tagKey.registry();
                        location = resourceKey = tagKey.location();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    Ingredient ingredient = Ingredient.of((TagKey)ItemTags.create((ResourceLocation)location));
                    return ingredient;
                }
            }
            break;
        }
        return null;
    }

    @HideFromJS
    public static DataResult<Ingredient> wrapResult(Context cx, @Nullable Object from) {
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        Ingredient trivial = IngredientWrapper.wrapTrivial(from);
        if (trivial != null) {
            return DataResult.success((Object)trivial);
        }
        if (from instanceof Pattern || from instanceof NativeRegExp) {
            String str = String.valueOf(from);
            return Optional.ofNullable(RegExpKJS.wrap(from)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Invalid regex " + str)).map(RegExIngredient::new).map(ICustomIngredient::toVanilla);
        }
        if (from instanceof JsonElement) {
            JsonElement json = (JsonElement)from;
            return IngredientWrapper.parseJson(cx, json);
        }
        if (from instanceof CharSequence) {
            return IngredientWrapper.parseString(cx, from.toString());
        }
        List<?> list = ListJS.of(from);
        if (list != null) {
            ArrayList results = new ArrayList(list.size());
            boolean failed = false;
            Stream.Builder<CallSite> errors = Stream.builder();
            for (Object o1 : list) {
                DataResult<Ingredient> ingredient = IngredientWrapper.wrapResult(cx, o1);
                ingredient.resultOrPartial().filter(ingr -> ingr != Ingredient.EMPTY).ifPresent(results::add);
                if (!ingredient.isError()) continue;
                failed = true;
                errors.add((CallSite)((Object)(String.valueOf(o1) + ": " + ((DataResult.Error)ingredient.error().orElseThrow()).message())));
            }
            if (failed) {
                String msg = errors.build().collect(Collectors.joining("; "));
                return DataResult.error(() -> "Failed to parse ingredient list: " + msg);
            }
            return DataResult.success((Object)(switch (results.size()) {
                case 0 -> Ingredient.EMPTY;
                case 1 -> (Ingredient)results.getFirst();
                default -> new CompoundIngredient(results).toVanilla();
            }));
        }
        Map map = cx.optionalMapOf(from);
        if (map != null) {
            return Ingredient.CODEC.parse((DynamicOps)JavaOps.INSTANCE, (Object)map);
        }
        return ItemWrapper.wrapResult(cx, from).map(ItemStackKJS::kjs$asIngredient);
    }

    @HideFromJS
    public static Ingredient wrap(Context cx, @Nullable Object from) {
        Ingredient trivial = IngredientWrapper.wrapTrivial(from);
        if (trivial != null) {
            return trivial;
        }
        return (Ingredient)IngredientWrapper.wrapResult(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read ingredient from %s: %s".formatted(from, error)).source(SourceLine.of(cx)));
    }

    public static boolean isIngredientLike(Object from) {
        return from instanceof Ingredient || from instanceof SizedIngredient || from instanceof ItemStack;
    }

    public static DataResult<Ingredient> parseJson(Context cx, JsonElement json) {
        DataResult dataResult;
        JsonElement jsonElement = json;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonNull.class, JsonArray.class, JsonPrimitive.class}, (Object)jsonElement, n)) {
                case -1: {
                    dataResult = DataResult.success((Object)Ingredient.EMPTY);
                    break block6;
                }
                case 0: {
                    JsonNull jsonNull = (JsonNull)jsonElement;
                    dataResult = DataResult.success((Object)Ingredient.EMPTY);
                    break block6;
                }
                case 1: {
                    JsonArray arr = (JsonArray)jsonElement;
                    if (!arr.isEmpty()) {
                        n = 2;
                        continue block6;
                    }
                    dataResult = DataResult.success((Object)Ingredient.EMPTY);
                    break block6;
                }
                case 2: {
                    JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                    dataResult = IngredientWrapper.wrapResult(cx, json.getAsString());
                    break block6;
                }
                default: {
                    dataResult = Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).map(Pair::getFirst);
                    break block6;
                }
            }
            break;
        }
        return dataResult;
    }

    public static DataResult<Ingredient> parseString(Context cx, String s) {
        return switch (s) {
            case "", "-", "air", "minecraft:air" -> DataResult.success((Object)Ingredient.EMPTY);
            case "*" -> DataResult.success((Object)all);
            default -> IngredientWrapper.read(cx, new StringReader(s));
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataResult<Ingredient> read(Context cx, StringReader reader) {
        DataResult dataResult;
        char next;
        DataResult dataResult2;
        RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
        reader.skipWhitespace();
        if (!reader.canRead()) {
            return DataResult.success((Object)Ingredient.EMPTY);
        }
        switch (reader.peek()) {
            case '-': {
                DataResult dataResult3;
                reader.skip();
                dataResult2 = dataResult3 = DataResult.success((Object)Ingredient.EMPTY);
                return dataResult2;
            }
            case '*': {
                DataResult dataResult4;
                reader.skip();
                dataResult2 = dataResult4 = DataResult.success((Object)all);
                return dataResult2;
            }
            case '#': {
                DataResult dataResult5;
                reader.skip();
                dataResult2 = dataResult5 = ID.read(reader).map(ItemTags::create).map(Ingredient::of);
                return dataResult2;
            }
            case '@': {
                DataResult dataResult6;
                reader.skip();
                dataResult2 = dataResult6 = DataResult.success((Object)new NamespaceIngredient(reader.readUnquotedString()).toVanilla());
                return dataResult2;
            }
            case '%': {
                DataResult dataResult7;
                reader.skip();
                dataResult2 = dataResult7 = ID.read(reader).flatMap(input -> {
                    CreativeModeTab tab = UtilsJS.findCreativeTab(input);
                    return tab != null ? DataResult.success((Object)tab) : DataResult.error(() -> "Creative tab " + String.valueOf(input) + " does not exist!");
                }).map(group -> new CreativeTabIngredient((CreativeModeTab)group).toVanilla());
                return dataResult2;
            }
            case '/': {
                DataResult dataResult8;
                dataResult2 = dataResult8 = RegExpKJS.tryRead(reader).map(RegExIngredient::new).map(ICustomIngredient::toVanilla);
                return dataResult2;
            }
            case '[': {
                DataResult dataResult9;
                reader.skip();
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() == ']') {
                    DataResult dataResult10;
                    dataResult2 = dataResult10 = DataResult.success((Object)Ingredient.EMPTY);
                    return dataResult2;
                }
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(2);
                while (true) {
                    DataResult<Ingredient> ingredient;
                    if (!(ingredient = IngredientWrapper.read(cx, reader)).isSuccess()) {
                        DataResult dataResult11;
                        dataResult2 = dataResult11 = DataResult.error(() -> "Invalid ingredient in list: " + ((DataResult.Error)ingredient.error().orElseThrow()).message());
                        return dataResult2;
                    }
                    ingredients.add((Ingredient)ingredient.getOrThrow());
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() == ',') {
                        reader.skip();
                        reader.skipWhitespace();
                        continue;
                    }
                    if (!reader.canRead() || reader.peek() == ']') break;
                }
                if (reader.canRead() && reader.peek() == ']') {
                    DataResult dataResult12;
                    reader.skip();
                    reader.skipWhitespace();
                    dataResult2 = dataResult12 = DataResult.success((Object)new CompoundIngredient(ingredients).toVanilla());
                    return dataResult2;
                }
                dataResult2 = dataResult9 = DataResult.error(() -> "Unterminated compound ingredient");
                return dataResult2;
            }
        }
        DataResult item = ID.read(reader).flatMap(ItemWrapper::findItem);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            try {
                DataComponentPredicate components = DataComponentWrapper.readPredicate(registries.nbt(), reader);
                if (components != DataComponentPredicate.EMPTY) {
                    DataResult dataResult13;
                    dataResult2 = dataResult13 = item.map(holder -> DataComponentIngredient.of((boolean)false, (DataComponentPredicate)components, (Holder[])new Holder[]{holder}));
                    return dataResult2;
                }
            }
            catch (CommandSyntaxException e) {
                DataResult dataResult14;
                dataResult2 = dataResult14 = DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
                return dataResult2;
            }
        }
        dataResult2 = dataResult = item.map(Holder::value).map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0}));
        return dataResult2;
    }

    @Info(value="Checks if the passed in object is an Ingredient.\nNote that this does not mean it will not function as an Ingredient if passed to something that requests one.\n")
    public static boolean isIngredient(@Nullable Object o) {
        return o instanceof Ingredient;
    }

    public static ItemStack first(Ingredient ingredient) {
        return ingredient.kjs$getFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static TagKey<Item> tagKeyOf(Ingredient in) {
        if (in.isCustom()) return null;
        if (in.getValues().length != 1) return null;
        Ingredient.Value value = in.getValues()[0];
        if (!(value instanceof Ingredient.TagValue)) return null;
        Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
        try {
            TagKey tagKey = tagValue.tag();
            return tagKey;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static boolean containsAnyTag(Ingredient in) {
        if (in.isCustom()) {
            return false;
        }
        for (Ingredient.Value value : in.getValues()) {
            if (!(value instanceof Ingredient.TagValue)) continue;
            return true;
        }
        return false;
    }
}

