/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.CountingMap;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

@Info(value="A collection of utilities")
public interface UtilsWrapper {
    @Info(value="Get a Random, for generating random numbers. Note this will always return the same Random instance")
    public static RandomSource getRandom() {
        return UtilsJS.RANDOM;
    }

    @Info(value="Get a new random with the specified seed")
    public static RandomSource newRandom(long seed) {
        return RandomSource.create((long)seed);
    }

    @Info(value="Get an immutable empty list")
    public static <T> List<T> emptyList() {
        return List.of();
    }

    @Info(value="Get an immutable empty map")
    public static <K, V> Map<K, V> emptyMap() {
        return Map.of();
    }

    @Info(value="Returns a new mutable list")
    public static List<?> newList() {
        return new ArrayList();
    }

    @Info(value="Returns a new mutable map")
    public static Map<?, ?> newMap() {
        return new LinkedHashMap();
    }

    @Info(value="Returns a new counting map")
    public static CountingMap newCountingMap() {
        return new CountingMap();
    }

    @Info(value="Returns a regex pattern of the input")
    public static Pattern regex(Object s) {
        Pattern pattern = RegExpKJS.wrap(s);
        return pattern == null ? Pattern.compile(s.toString()) : pattern;
    }

    @Info(value="Returns a regex pattern of the input with the specified flags")
    public static Pattern regex(String pattern, int flags) {
        return Pattern.compile(pattern, flags);
    }

    @Info(value="Returns a Stat of the passed in ResourceLocation.\nNote that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.\n")
    public static Stat<ResourceLocation> getStat(ResourceLocation id) {
        return Stats.CUSTOM.get((Object)id);
    }

    @Info(value="Gets a SoundEvent from the id")
    @Nullable
    public static SoundEvent getSound(ResourceLocation id) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(id);
    }

    @Info(value="Gets a random object from the list using the passed in random")
    public static Object randomOf(Random random, Collection<Object> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (objects instanceof List) {
            List list = (List)objects;
            return list.get(random.nextInt(objects.size()));
        }
        return new ArrayList<Object>(objects).get(random.nextInt(objects.size()));
    }

    @Info(value="Gets the current system time, in milliseconds")
    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    @Info(value="Checks if the passed in object is an instance of WrappedJS")
    public static boolean isWrapped(@Nullable Object o) {
        return o instanceof WrappedJS;
    }

    @Info(value="Returns a lazy value with the supplier function as its value factory")
    public static <T> Lazy<T> lazy(Supplier<T> supplier) {
        return Lazy.of(supplier);
    }

    @Info(value="Returns a lazy value with the supplier function as its value factory, that will expire after the specified time")
    public static <T> Lazy<T> expiringLazy(Supplier<T> supplier, Duration expires) {
        return Lazy.of(supplier, expires);
    }

    @Info(value="Returns the creative tab associated with the id")
    @Nullable
    public static CreativeModeTab findCreativeTab(ResourceLocation id) {
        return UtilsJS.findCreativeTab(id);
    }

    @Info(value="Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture")
    public static CompletableFuture<Void> runAsync(Runnable task) {
        return CompletableFuture.runAsync(task, Util.backgroundExecutor());
    }

    @Info(value="Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture")
    public static CompletableFuture<Object> supplyAsync(Supplier<Object> task) {
        return CompletableFuture.supplyAsync(task, Util.backgroundExecutor());
    }
}

