/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.IngredientWrapper;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

@Info(value="Various item related helper methods")
public interface ItemWrapper {
    public static final ItemStack[] EMPTY_ARRAY;
    public static final TypeInfo ITEM_TYPE_INFO;
    public static final TypeInfo TYPE_INFO;
    @HideFromJS
    public static final Lazy<List<String>> CACHED_ITEM_TYPE_LIST;
    @HideFromJS
    public static final Lazy<Map<ResourceLocation, Collection<ItemStack>>> CACHED_ITEM_MAP;
    @HideFromJS
    public static final Lazy<List<ItemStack>> CACHED_ITEM_LIST;

    @Info(value="Returns an ItemStack of the input")
    public static ItemStack of(ItemStack in) {
        return in;
    }

    @Info(value="Returns an ItemStack of the input, with the specified count")
    public static ItemStack of(ItemStack in, int count) {
        return in.kjs$withCount(count);
    }

    @HideFromJS
    private static ItemStack wrapTrivial(Context cx, @Nullable Object from) {
        ItemStack itemStack;
        while (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        Object object = from;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemStack.class, ItemLike.class, Ingredient.class, SizedIngredient.class, ItemLike.class}, (Object)object, n)) {
                case -1: {
                    itemStack = ItemStack.EMPTY;
                    break block9;
                }
                case 0: {
                    ItemStack s = (ItemStack)object;
                    if (s.isEmpty()) {
                        itemStack = ItemStack.EMPTY;
                        break block9;
                    }
                    itemStack = s;
                    break block9;
                }
                case 1: {
                    ItemLike i = (ItemLike)object;
                    if (i.asItem() != Items.AIR) {
                        n = 2;
                        continue block9;
                    }
                    itemStack = ItemStack.EMPTY;
                    break block9;
                }
                case 2: {
                    Ingredient i = (Ingredient)object;
                    throw new KubeRuntimeException("Use .first of an ingredient to get its ItemStack!").source(SourceLine.of(cx));
                }
                case 3: {
                    SizedIngredient sized = (SizedIngredient)object;
                    throw new KubeRuntimeException("Use .ingredient.first on a sized ingredient to get its ItemStack!").source(SourceLine.of(cx));
                }
                case 4: {
                    ItemLike i = (ItemLike)object;
                    itemStack = i.asItem().getDefaultInstance();
                    break block9;
                }
                default: {
                    itemStack = null;
                    break block9;
                }
            }
            break;
        }
        return itemStack;
    }

    @HideFromJS
    public static DataResult<ItemStack> wrapResult(Context cx, @Nullable Object from) {
        ItemStack trivial;
        if (from instanceof Wrapper) {
            Wrapper w = (Wrapper)from;
            from = w.unwrap();
        }
        if ((trivial = ItemWrapper.wrapTrivial(cx, from)) != null) {
            return DataResult.success((Object)trivial);
        }
        RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
        if (!1.$assertionsDisabled && from == null) {
            throw new AssertionError();
        }
        Object object = from;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ResourceLocation.class, JsonElement.class, StringTag.class, Pattern.class, NativeRegExp.class, CharSequence.class}, (Object)object2, n)) {
            case 0 -> {
                ResourceLocation id = (ResourceLocation)object2;
                yield ItemWrapper.findItem(id).map(Holder::value).map(Item::getDefaultInstance);
            }
            case 1 -> {
                JsonElement json = (JsonElement)object2;
                yield ItemWrapper.parseJson(cx, registries.nbt(), json);
            }
            case 2 -> {
                StringTag tag = (StringTag)object2;
                yield ItemWrapper.wrapResult(cx, tag.getAsString());
            }
            case 3 -> {
                Pattern pattern = (Pattern)object2;
                yield IngredientWrapper.wrapResult(cx, from).map(ItemPredicate::kjs$getFirst);
            }
            case 4 -> {
                NativeRegExp nativeRegExp = (NativeRegExp)object2;
                yield IngredientWrapper.wrapResult(cx, from).map(ItemPredicate::kjs$getFirst);
            }
            case 5 -> {
                int count;
                String os;
                CharSequence charSequence = (CharSequence)object2;
                String s = os = from.toString().trim();
                ItemStack cached = registries.itemStackParseCache().get(os);
                if (cached != null) {
                    yield DataResult.success((Object)cached.copy());
                }
                int spaceIndex = s.indexOf(32);
                if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                    count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                    s = s.substring(spaceIndex + 1);
                } else {
                    count = 1;
                }
                yield ItemWrapper.parseString(cx, registries.nbt(), s).map(stack -> stack.kjs$withCount(count)).ifSuccess(stack -> registries.itemStackParseCache().put(os, stack.copy()));
            }
            default -> {
                Map map = cx.optionalMapOf(from);
                if (map != null) {
                    yield ItemStack.CODEC.parse(registries.java(), (Object)map);
                }
                Object invalid = from;
                yield DataResult.error(() -> "Could not parse input %s for item stack".formatted(invalid));
            }
        };
    }

    @HideFromJS
    public static ItemStack wrap(Context cx, @Nullable Object from) {
        ItemStack trivial = ItemWrapper.wrapTrivial(cx, from);
        if (trivial != null) {
            return trivial;
        }
        return (ItemStack)ItemWrapper.wrapResult(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read item stack from %s: %s".formatted(from, error)).source(SourceLine.of(cx)));
    }

    @HideFromJS
    public static Item wrapItem(Context cx, @Nullable Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemLike.class, CharSequence.class}, (Object)object, n)) {
            case -1 -> Items.AIR;
            case 0 -> {
                ItemLike item = (ItemLike)object;
                yield item.asItem();
            }
            case 1 -> {
                CharSequence cs = (CharSequence)object;
                yield (Item)ItemWrapper.findItem(cs.toString()).getOrThrow(error -> new KubeRuntimeException("Failed to read item from %s: %s".formatted(cs, error)).source(SourceLine.of(cx)));
            }
            default -> ItemWrapper.wrap(cx, o).getItem();
        };
    }

    public static DataResult<Item> findItem(String s) {
        return switch (s = s.trim()) {
            case "", "-", "air", "minecraft:air" -> DataResult.success((Object)Items.AIR);
            default -> ResourceLocation.read((String)s).flatMap(ItemWrapper::findItem).map(Holder::value);
        };
    }

    @HideFromJS
    public static DataResult<Holder<Item>> findItem(ResourceLocation id) {
        return BuiltInRegistries.ITEM.getHolder(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Item with ID " + String.valueOf(id) + " does not exist!")).map(Function.identity());
    }

    @Info(value="Get a list of most items in the game. Items not in a creative tab are ignored")
    public static List<ItemStack> getList() {
        return CACHED_ITEM_LIST.get();
    }

    @Info(value="Get a list of all the item ids in the game")
    public static List<String> getTypeList() {
        return CACHED_ITEM_TYPE_LIST.get();
    }

    public static Map<ResourceLocation, Collection<ItemStack>> getTypeToStackMap() {
        return CACHED_ITEM_MAP.get();
    }

    public static Collection<ItemStack> getVariants(ItemStack item) {
        return ItemWrapper.getTypeToStackMap().get(item.kjs$getIdLocation());
    }

    @Info(value="Get the item that represents air/an empty slot")
    public static ItemStack getEmpty() {
        return ItemStack.EMPTY;
    }

    @Info(value="Returns a Firework with the input properties")
    public static Fireworks fireworks(Fireworks fireworks) {
        return fireworks;
    }

    @Info(value="Gets an Item from an item id")
    public static Item getItem(ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.get(id);
    }

    @Info(value="Gets an items id from the Item")
    public static ResourceLocation getId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @Info(value="Checks if the provided item id exists in the registry")
    public static boolean exists(ResourceLocation id) {
        return BuiltInRegistries.ITEM.containsKey(id);
    }

    @Info(value="Checks if the passed in object is an ItemStack.\nNote that this does not mean it will not function as an ItemStack if passed to something that requests one.\n")
    public static boolean isItem(@Nullable Object o) {
        return o instanceof ItemStack;
    }

    public static ItemStack playerHead(String name) {
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of(name), Optional.empty(), new PropertyMap()));
        return stack;
    }

    public static ItemStack playerHeadFromBase64(UUID uuid, String textureBase64) {
        if (uuid == null || uuid.equals(Util.NIL_UUID)) {
            throw new IllegalArgumentException("UUID can't be null!");
        }
        if (textureBase64 == null || textureBase64.isBlank()) {
            throw new IllegalArgumentException("Texture Base 64 can't be empty!");
        }
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        PropertyMap properties = new PropertyMap();
        properties.put((Object)"textures", (Object)new Property("textures", textureBase64));
        stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.empty(), Optional.of(uuid), properties));
        return stack;
    }

    public static ItemStack playerHeadFromUrl(String url) {
        JsonObject root = new JsonObject();
        JsonObject textures = new JsonObject();
        JsonObject skin = new JsonObject();
        skin.addProperty("url", url);
        textures.add("SKIN", (JsonElement)skin);
        root.add("textures", (JsonElement)textures);
        byte[] bytes = JsonUtils.toString((JsonElement)root).getBytes(StandardCharsets.UTF_8);
        return ItemWrapper.playerHeadFromBase64(UUID.nameUUIDFromBytes(bytes), Base64.getEncoder().encodeToString(bytes));
    }

    public static ItemStack playerHeadFromSkinHash(String hash) {
        return ItemWrapper.playerHeadFromUrl("https://textures.minecraft.net/texture/" + hash);
    }

    public static ItemAbility wrapItemAbility(Object object) {
        if (object instanceof ItemAbility) {
            ItemAbility ta = (ItemAbility)object;
            return ta;
        }
        if (object != null) {
            return ItemAbility.get((String)object.toString());
        }
        return null;
    }

    public static boolean isItemStackLike(Object from) {
        return from instanceof ItemStack || from instanceof ItemLike;
    }

    public static DataResult<ItemStack> parseJson(Context cx, DynamicOps<Tag> registryOps, @Nullable JsonElement json) {
        JsonElement jsonElement = json;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonNull.class, JsonPrimitive.class, JsonObject.class}, (Object)jsonElement, n)) {
            case -1 -> DataResult.success((Object)ItemStack.EMPTY);
            case 0 -> {
                JsonNull jsonNull = (JsonNull)jsonElement;
                yield DataResult.success((Object)ItemStack.EMPTY);
            }
            case 1 -> {
                JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                yield ItemWrapper.parseString(cx, registryOps, primitive.getAsString());
            }
            case 2 -> {
                JsonObject obj = (JsonObject)jsonElement;
                yield ItemStack.OPTIONAL_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).map(Pair::getFirst);
            }
            default -> DataResult.error(() -> "Could not parse item stack from JSON " + String.valueOf(json));
        };
    }

    public static DataResult<ItemStack> parseString(Context cx, DynamicOps<Tag> registryOps, String s) {
        return switch (s) {
            case "", "-", "air", "minecraft:air" -> {
                DataResult<ItemStack> var5_5;
                yield var5_5 = DataResult.success((Object)ItemStack.EMPTY);
            }
            default -> {
                try {
                    DataResult<ItemStack> var5_6;
                    yield var5_6 = ItemWrapper.read(cx, registryOps, new StringReader(s));
                }
                catch (CommandSyntaxException ex) {
                    DataResult var5_7 = DataResult.error(() -> "Error parsing item from string: " + String.valueOf((Object)ex));
                    yield var5_7;
                }
            }
        };
    }

    public static DataResult<ItemStack> read(Context cx, DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        char next;
        int count;
        reader.skipWhitespace();
        if (!reader.canRead() || reader.peek() == '-') {
            return DataResult.success((Object)ItemStack.EMPTY);
        }
        if (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            count = Mth.ceil((double)reader.readDouble());
            reader.skipWhitespace();
            reader.expect('x');
            reader.skipWhitespace();
            if (count < 1) {
                return DataResult.error(() -> "Item count smaller than 1 is not allowed!");
            }
        } else {
            count = 1;
        }
        DataResult itemStack = ID.read(reader).flatMap(ItemWrapper::findItem).map(item -> new ItemStack(item, count));
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            return itemStack.flatMap(stack -> {
                try {
                    DataComponentPatch components = DataComponentWrapper.readPatch(registryOps, reader);
                    stack.applyComponents(components);
                    return DataResult.success((Object)stack);
                }
                catch (CommandSyntaxException e) {
                    return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
                }
            });
        }
        return itemStack;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY_ARRAY = new ItemStack[0];
        ITEM_TYPE_INFO = TypeInfo.of(Item.class);
        TYPE_INFO = TypeInfo.of(ItemStack.class);
        CACHED_ITEM_TYPE_LIST = Lazy.of(() -> {
            ArrayList<String> cachedItemTypeList = new ArrayList<String>();
            for (Item item : BuiltInRegistries.ITEM) {
                cachedItemTypeList.add(item.kjs$getId());
            }
            return cachedItemTypeList;
        });
        CACHED_ITEM_MAP = Lazy.map(map -> {
            Set stackList = ItemStackLinkedSet.createTypeAndComponentsSet();
            stackList.addAll(CreativeModeTabs.searchTab().getDisplayItems());
            for (ItemStack stack : stackList) {
                if (stack.isEmpty()) continue;
                map.computeIfAbsent(stack.getItem().kjs$getIdLocation(), _rl -> ItemStackLinkedSet.createTypeAndComponentsSet()).add(stack.kjs$withCount(1));
            }
            for (String itemId : CACHED_ITEM_TYPE_LIST.get()) {
                ResourceLocation itemRl = ResourceLocation.parse((String)itemId);
                map.computeIfAbsent(itemRl, id -> Set.of(((Item)BuiltInRegistries.ITEM.get(id)).getDefaultInstance()));
            }
        });
        CACHED_ITEM_LIST = Lazy.of(() -> CACHED_ITEM_MAP.get().values().stream().flatMap(Collection::stream).toList());
    }
}

