/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core.mixin;

import dev.latvian.mods.kubejs.block.BlockStartedFallingKubeEvent;
import dev.latvian.mods.kubejs.block.BlockStoppedFallingKubeEvent;
import dev.latvian.mods.kubejs.plugin.builtin.event.BlockEvents;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.util.RemapForJS;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FallingBlockEntity.class})
public class FallingBlockEntityMixin {
    @Shadow
    private BlockState blockState;

    @Inject(method={"fall"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void kjs$fallStart(Level level, BlockPos pos, BlockState state, CallbackInfoReturnable<FallingBlockEntity> cir, FallingBlockEntity entity) {
        if (!level.isClientSide() && BlockEvents.STARTED_FALLING.hasListeners((ResourceKey<Block>)state.kjs$getKey()) && BlockEvents.STARTED_FALLING.post(ScriptType.SERVER, (ResourceKey<Block>)state.kjs$getKey(), new BlockStartedFallingKubeEvent(level, pos, state, entity)).interruptFalse()) {
            cir.setReturnValue((Object)entity);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;broadcast(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/protocol/Packet;)V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void kjs$fallEnd(CallbackInfo ci, Block block, BlockPos pos, boolean concrete, boolean canBeHydrated, double fallSpeed, BlockState replacedState) {
        FallingBlockEntity entity = (FallingBlockEntity)this;
        if (!entity.level().isClientSide() && BlockEvents.STOPPED_FALLING.hasListeners((ResourceKey<Block>)this.blockState.kjs$getKey())) {
            BlockEvents.STOPPED_FALLING.post(ScriptType.SERVER, (ResourceKey<Block>)this.blockState.kjs$getKey(), new BlockStoppedFallingKubeEvent(entity.level(), pos, this.blockState, entity, fallSpeed, replacedState));
        }
    }

    @Unique
    @RemapForJS(value="setBlockState")
    public void kjs$setBlockState(BlockState state) {
        this.blockState = state;
    }
}

