/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.event.KubeStartupEvent;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.KubeResourceLocation;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ItemModelPropertiesKubeEvent
implements KubeStartupEvent {
    @Info(value="Register a model property for an item. Model properties are used to change the appearance of an item in the world.\n\nMore about model properties: https://minecraft.wiki/w/Tutorials/Models#Item_predicates\n")
    public void register(Ingredient ingredient, KubeResourceLocation overwriteId, ClampedItemPropertyFunction callback) {
        ResourceLocation id = overwriteId.wrapped();
        if (ingredient.kjs$isWildcard()) {
            ItemProperties.registerGeneric((ResourceLocation)id, (ItemPropertyFunction)callback);
        } else {
            for (ItemStack stack : ingredient.kjs$getStacks()) {
                ItemProperties.register((Item)stack.getItem(), (ResourceLocation)id, (ItemPropertyFunction)callback);
            }
        }
    }

    @Info(value="Register a model property for all items.")
    public void registerAll(KubeResourceLocation overwriteId, ClampedItemPropertyFunction callback) {
        ItemProperties.registerGeneric((ResourceLocation)overwriteId.wrapped(), (ItemPropertyFunction)callback);
    }
}

