/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.ingredient.CreativeTabIngredient;
import dev.latvian.mods.kubejs.ingredient.NamespaceIngredient;
import dev.latvian.mods.kubejs.ingredient.RegExIngredient;
import dev.latvian.mods.kubejs.ingredient.WildcardIngredient;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ItemWrapper;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

@Info(value="Various Ingredient related helper methods")
public interface IngredientWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(Ingredient.class);
    @Info(value="A completely empty ingredient that will only match air")
    public static final Ingredient none = Ingredient.EMPTY;
    @Info(value="An ingredient that matches everything")
    public static final Ingredient all = WildcardIngredient.INSTANCE.toVanilla();

    @Info(value="Returns an ingredient of the input")
    public static Ingredient of(Ingredient ingredient) {
        return ingredient;
    }

    @Info(value="Returns an ingredient of the input, with the specified count")
    public static SizedIngredient of(Ingredient ingredient, int count) {
        return ingredient.kjs$withCount(count);
    }

    @HideFromJS
    public static Ingredient wrap(Context cx, @Nullable Object o) {
        while (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.EMPTY || o == Items.AIR || o == Ingredient.EMPTY) {
            return Ingredient.EMPTY;
        }
        if (o instanceof IngredientSupplierKJS) {
            IngredientSupplierKJS ingr = (IngredientSupplierKJS)o;
            return ingr.kjs$asIngredient();
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)tag.location()));
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = RegExpKJS.wrap(o);
            if (reg != null) {
                return new RegExIngredient(reg).toVanilla();
            }
            return Ingredient.EMPTY;
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return IngredientWrapper.parseJson(cx, json);
        }
        if (o instanceof CharSequence) {
            return IngredientWrapper.parseString(RegistryAccessContainer.of(cx), o.toString());
        }
        List<?> list = ListJS.of(o);
        if (list != null) {
            ArrayList<Ingredient> inList = new ArrayList<Ingredient>(list.size());
            for (Object o1 : list) {
                Ingredient ingredient = IngredientWrapper.wrap(cx, o1);
                if (ingredient == Ingredient.EMPTY) continue;
                inList.add(ingredient);
            }
            if (inList.isEmpty()) {
                return Ingredient.EMPTY;
            }
            if (inList.size() == 1) {
                return (Ingredient)inList.getFirst();
            }
            return CompoundIngredient.of((Ingredient[])inList.toArray(new Ingredient[0]));
        }
        Map map = cx.optionalMapOf(o);
        if (map != null) {
            return Ingredient.CODEC.decode((DynamicOps)JavaOps.INSTANCE, (Object)map).result().map(Pair::getFirst).orElse(Ingredient.EMPTY);
        }
        return ItemWrapper.wrap(cx, o).kjs$asIngredient();
    }

    public static boolean isIngredientLike(Object from) {
        return from instanceof Ingredient || from instanceof SizedIngredient || from instanceof ItemStack;
    }

    public static Ingredient parseJson(Context cx, JsonElement json) {
        if (json == null || json.isJsonNull() || json.isJsonArray() && json.getAsJsonArray().isEmpty()) {
            return Ingredient.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return IngredientWrapper.wrap(cx, json.getAsString());
        }
        return Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().map(Pair::getFirst).orElseThrow();
    }

    public static Ingredient parseString(RegistryAccessContainer registries, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return Ingredient.EMPTY;
        }
        if (s.equals("*")) {
            return all;
        }
        try {
            return IngredientWrapper.read(registries, new StringReader(s));
        }
        catch (CommandSyntaxException e) {
            KubeJS.LOGGER.error("Failed to read ingredient from '" + s + "': " + String.valueOf((Object)e));
            return Ingredient.EMPTY;
        }
    }

    public static Ingredient read(RegistryAccessContainer registries, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return Ingredient.EMPTY;
        }
        return switch (reader.peek()) {
            case '-' -> {
                reader.skip();
                yield Ingredient.EMPTY;
            }
            case '*' -> {
                reader.skip();
                yield all;
            }
            case '#' -> {
                reader.skip();
                yield Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.read((StringReader)reader)));
            }
            case '@' -> {
                reader.skip();
                yield new NamespaceIngredient(reader.readUnquotedString()).toVanilla();
            }
            case '%' -> {
                reader.skip();
                ResourceLocation id = ResourceLocation.read((StringReader)reader);
                CreativeModeTab group = UtilsJS.findCreativeTab(id);
                if (group == null) {
                    yield Ingredient.EMPTY;
                }
                yield new CreativeTabIngredient(group).toVanilla();
            }
            case '/' -> {
                Pattern regex = RegExpKJS.read(reader);
                yield new RegExIngredient(regex).toVanilla();
            }
            case '[' -> {
                reader.skip();
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() == ']') {
                    yield Ingredient.EMPTY;
                }
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(2);
                while (true) {
                    ingredients.add(IngredientWrapper.read(registries, reader));
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() == ',') {
                        reader.skip();
                        reader.skipWhitespace();
                        continue;
                    }
                    if (!reader.canRead() || reader.peek() == ']') break;
                }
                reader.expect(']');
                reader.skipWhitespace();
                yield CompoundIngredient.of((Ingredient[])ingredients.toArray(new Ingredient[0]));
            }
            default -> {
                DataComponentPredicate components;
                char next;
                ResourceLocation itemId = ResourceLocation.read((StringReader)reader);
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                char v1 = next = reader.canRead() ? reader.peek() : (char)'\u0000';
                if ((next == '[' || next == '{') && (components = DataComponentWrapper.readPredicate(registries.nbt(), reader)) != DataComponentPredicate.EMPTY) {
                    yield new DataComponentIngredient((HolderSet)HolderSet.direct((Holder[])new Holder[]{item.builtInRegistryHolder()}), components, false).toVanilla();
                }
                yield Ingredient.of((ItemLike[])new ItemLike[]{item});
            }
        };
    }

    @Info(value="Checks if the passed in object is an Ingredient.\nNote that this does not mean it will not function as an Ingredient if passed to something that requests one.\n")
    public static boolean isIngredient(@Nullable Object o) {
        return o instanceof Ingredient;
    }

    public static ItemStack first(Ingredient ingredient) {
        return ingredient.kjs$getFirst();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static TagKey<Item> tagKeyOf(Ingredient in) {
        if (in.isCustom()) return null;
        if (in.getValues().length != 1) return null;
        Ingredient.Value value = in.getValues()[0];
        if (!(value instanceof Ingredient.TagValue)) return null;
        Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
        try {
            TagKey tagKey = tagValue.tag();
            return tagKey;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static boolean containsAnyTag(Ingredient in) {
        if (in.isCustom()) {
            return false;
        }
        for (Ingredient.Value value : in.getValues()) {
            if (!(value instanceof Ingredient.TagValue)) continue;
            return true;
        }
        return false;
    }
}

