/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.ingredient.RegExIngredient;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.StringUtilsWrapper;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

@Info(value="Various item related helper methods")
public interface ItemWrapper {
    public static final ItemStack[] EMPTY_ARRAY = new ItemStack[0];
    public static final TypeInfo ITEM_TYPE_INFO = TypeInfo.of(Item.class);
    public static final TypeInfo TYPE_INFO = TypeInfo.of(ItemStack.class);
    @HideFromJS
    public static final Lazy<List<String>> CACHED_ITEM_TYPE_LIST = Lazy.of(() -> {
        ArrayList<String> cachedItemTypeList = new ArrayList<String>();
        for (Item item : BuiltInRegistries.ITEM) {
            cachedItemTypeList.add(item.kjs$getId());
        }
        return cachedItemTypeList;
    });
    @HideFromJS
    public static final Lazy<Map<ResourceLocation, Collection<ItemStack>>> CACHED_ITEM_MAP = Lazy.map(map -> {
        Set stackList = ItemStackLinkedSet.createTypeAndComponentsSet();
        stackList.addAll(CreativeModeTabs.searchTab().getDisplayItems());
        for (ItemStack stack : stackList) {
            if (stack.isEmpty()) continue;
            map.computeIfAbsent(stack.getItem().kjs$getIdLocation(), _rl -> ItemStackLinkedSet.createTypeAndComponentsSet()).add(stack.kjs$withCount(1));
        }
        for (String itemId : CACHED_ITEM_TYPE_LIST.get()) {
            ResourceLocation itemRl = ResourceLocation.parse((String)itemId);
            map.computeIfAbsent(itemRl, id -> Set.of(((Item)BuiltInRegistries.ITEM.get(id)).getDefaultInstance()));
        }
    });
    @HideFromJS
    public static final Lazy<List<ItemStack>> CACHED_ITEM_LIST = Lazy.of(() -> CACHED_ITEM_MAP.get().values().stream().flatMap(Collection::stream).toList());

    @Info(value="Returns an ItemStack of the input")
    public static ItemStack of(ItemStack in) {
        return in;
    }

    @Info(value="Returns an ItemStack of the input, with the specified count")
    public static ItemStack of(ItemStack in, int count) {
        return in.kjs$withCount(count);
    }

    @HideFromJS
    public static ItemStack wrap(Context cx, @Nullable Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.EMPTY || o == Items.AIR) {
            return ItemStack.EMPTY;
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return stack.isEmpty() ? ItemStack.EMPTY : stack;
        }
        if (o == Ingredient.EMPTY) {
            throw new KubeRuntimeException("Tried to convert empy ingredient to ItemStack!").source(SourceLine.of(cx));
        }
        if (o instanceof Ingredient) {
            throw new KubeRuntimeException("Use .first of an ingredient to get its ItemStack!").source(SourceLine.of(cx));
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation id = (ResourceLocation)o;
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null || item == Items.AIR) {
                return ItemStack.EMPTY;
            }
            return item.getDefaultInstance();
        }
        if (o instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)o;
            return itemLike.asItem().getDefaultInstance();
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
            return ItemWrapper.parseJson(registries.nbt(), json);
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            return ItemWrapper.wrap(cx, tag.getAsString());
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = RegExpKJS.wrap(o);
            if (reg != null) {
                return new RegExIngredient(reg).toVanilla().kjs$getFirst();
            }
            return ItemStack.EMPTY;
        }
        if (o instanceof CharSequence) {
            String os;
            String s = os = o.toString().trim();
            RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
            ItemStack cached = registries.itemStackParseCache().get(os);
            if (cached != null) {
                return cached.copy();
            }
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            cached = ItemWrapper.parseString(registries.nbt(), s);
            cached.setCount(count);
            registries.itemStackParseCache().put(os, cached);
            return cached.copy();
        }
        Map map = cx.optionalMapOf(o);
        if (map != null) {
            if (map.containsKey("item")) {
                ResourceLocation id = ID.mc(map.get("item").toString());
                Item item = (Item)BuiltInRegistries.ITEM.get(id);
                if (item == null || item == Items.AIR) {
                    return ItemStack.EMPTY;
                }
                ItemStack stack = new ItemStack((ItemLike)item);
                Object v = map.get("count");
                if (v instanceof Number) {
                    Number number = (Number)v;
                    stack.setCount(number.intValue());
                }
                return stack;
            }
            if (map.containsKey("tag")) {
                ItemStack stack = Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ID.mc(map.get("tag")))).kjs$getFirst();
                if (map.containsKey("count")) {
                    stack.setCount(StringUtilsWrapper.parseInt(map.get("count"), 1));
                }
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    @HideFromJS
    public static Item wrapItem(Context cx, @Nullable Object o) {
        if (o == null) {
            return Items.AIR;
        }
        if (o instanceof ItemLike) {
            ItemLike item = (ItemLike)o;
            return item.asItem();
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s.isEmpty()) {
                return Items.AIR;
            }
            if (s.charAt(0) != '#') {
                return (Item)BuiltInRegistries.ITEM.get(ID.mc(s));
            }
        }
        return ItemWrapper.wrap(cx, o).getItem();
    }

    @Info(value="Get a list of most items in the game. Items not in a creative tab are ignored")
    public static List<ItemStack> getList() {
        return CACHED_ITEM_LIST.get();
    }

    @Info(value="Get a list of all the item ids in the game")
    public static List<String> getTypeList() {
        return CACHED_ITEM_TYPE_LIST.get();
    }

    public static Map<ResourceLocation, Collection<ItemStack>> getTypeToStackMap() {
        return CACHED_ITEM_MAP.get();
    }

    public static Collection<ItemStack> getVariants(ItemStack item) {
        return ItemWrapper.getTypeToStackMap().get(item.kjs$getIdLocation());
    }

    @Info(value="Get the item that represents air/an empty slot")
    public static ItemStack getEmpty() {
        return ItemStack.EMPTY;
    }

    @Info(value="Returns a Firework with the input properties")
    public static Fireworks fireworks(Fireworks fireworks) {
        return fireworks;
    }

    @Info(value="Gets an Item from an item id")
    public static Item getItem(ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.get(id);
    }

    @Info(value="Gets an items id from the Item")
    public static ResourceLocation getId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @Info(value="Checks if the provided item id exists in the registry")
    public static boolean exists(ResourceLocation id) {
        return BuiltInRegistries.ITEM.containsKey(id);
    }

    @Info(value="Checks if the passed in object is an ItemStack.\nNote that this does not mean it will not function as an ItemStack if passed to something that requests one.\n")
    public static boolean isItem(@Nullable Object o) {
        return o instanceof ItemStack;
    }

    public static ItemStack playerHead(String name) {
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of(name), Optional.empty(), new PropertyMap()));
        return stack;
    }

    public static ItemStack playerHeadFromBase64(UUID uuid, String textureBase64) {
        if (uuid == null || uuid.equals(Util.NIL_UUID)) {
            throw new IllegalArgumentException("UUID can't be null!");
        }
        if (textureBase64 == null || textureBase64.isBlank()) {
            throw new IllegalArgumentException("Texture Base 64 can't be empty!");
        }
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        PropertyMap properties = new PropertyMap();
        properties.put((Object)"textures", (Object)new Property("textures", textureBase64));
        stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.empty(), Optional.of(uuid), properties));
        return stack;
    }

    public static ItemStack playerHeadFromUrl(String url) {
        JsonObject root = new JsonObject();
        JsonObject textures = new JsonObject();
        JsonObject skin = new JsonObject();
        skin.addProperty("url", url);
        textures.add("SKIN", (JsonElement)skin);
        root.add("textures", (JsonElement)textures);
        byte[] bytes = JsonUtils.toString((JsonElement)root).getBytes(StandardCharsets.UTF_8);
        return ItemWrapper.playerHeadFromBase64(UUID.nameUUIDFromBytes(bytes), Base64.getEncoder().encodeToString(bytes));
    }

    public static ItemStack playerHeadFromSkinHash(String hash) {
        return ItemWrapper.playerHeadFromUrl("https://textures.minecraft.net/texture/" + hash);
    }

    public static ItemAbility wrapItemAbility(Object object) {
        if (object instanceof ItemAbility) {
            ItemAbility ta = (ItemAbility)object;
            return ta;
        }
        if (object != null) {
            return ItemAbility.get((String)object.toString());
        }
        return null;
    }

    public static boolean isItemStackLike(Object from) {
        return from instanceof ItemStack || from instanceof ItemLike;
    }

    public static ItemStack parseJson(DynamicOps<Tag> registryOps, @Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ItemStack.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return ItemWrapper.parseString(registryOps, json.getAsString());
        }
        if (json instanceof JsonObject) {
            return (ItemStack)((Pair)ItemStack.OPTIONAL_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack parseString(DynamicOps<Tag> registryOps, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return ItemStack.EMPTY;
        }
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            if (!reader.canRead()) {
                return ItemStack.EMPTY;
            }
            return ItemWrapper.read(registryOps, new StringReader(s));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ItemStack read(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        char next;
        if (!reader.canRead()) {
            return ItemStack.EMPTY;
        }
        if (reader.peek() == '-') {
            return ItemStack.EMPTY;
        }
        int count = 1;
        if (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            count = Mth.ceil((double)reader.readDouble());
            reader.skipWhitespace();
            reader.expect('x');
            reader.skipWhitespace();
            if (count < 1) {
                throw new IllegalArgumentException("Item count smaller than 1 is not allowed!");
            }
        }
        ResourceLocation itemId = ResourceLocation.read((StringReader)reader);
        ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemId), count);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            itemStack.applyComponents(DataComponentWrapper.readPatch(registryOps, reader));
        }
        return itemStack;
    }
}

