/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.error.InvalidRecipeComponentValueException;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ItemWrapper;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.OpsContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record ItemStackComponent(RecipeComponentType<?> type, Codec<ItemStack> codec, boolean allowEmpty, Ingredient filter) implements RecipeComponent<ItemStack>
{
    public static final RecipeComponentType<ItemStack> ITEM_STACK = RecipeComponentType.unit(KubeJS.id("item_stack"), type -> new ItemStackComponent((RecipeComponentType<?>)type, false, Ingredient.EMPTY));
    public static final RecipeComponentType<ItemStack> OPTIONAL_ITEM_STACK = RecipeComponentType.unit(KubeJS.id("optional_item_stack"), type -> new ItemStackComponent((RecipeComponentType<?>)type, true, Ingredient.EMPTY));
    public static final RecipeComponentType<?> FILTERED_ITEM_STACK = RecipeComponentType.dynamic(KubeJS.id("filtered_item_stack"), (type, ctx) -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("allow_empty", (Object)false).forGetter(ItemStackComponent::allowEmpty), (App)Ingredient.CODEC.optionalFieldOf("filter", (Object)Ingredient.EMPTY).forGetter(ItemStackComponent::filter)).apply((Applicative)instance, (allowEmpty, filter) -> new ItemStackComponent(type, (boolean)allowEmpty, (Ingredient)filter))));

    public ItemStackComponent(RecipeComponentType<?> type, boolean allowEmpty, Ingredient filter) {
        this(type, (Codec<ItemStack>)(allowEmpty ? ItemStack.OPTIONAL_CODEC : ItemStack.STRICT_CODEC), allowEmpty, filter);
    }

    @Override
    public TypeInfo typeInfo() {
        return ItemWrapper.TYPE_INFO;
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        return ItemWrapper.isItemStackLike(from);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(RecipeMatchContext cx, ItemStack value, ReplacementMatchInfo match) {
        ReplacementMatch replacementMatch = match.match();
        if (!(replacementMatch instanceof ItemMatch)) return false;
        ItemMatch m = (ItemMatch)replacementMatch;
        if (value.isEmpty()) return false;
        if (!m.matches(cx, value, match.exact())) return false;
        return true;
    }

    @Override
    public boolean isEmpty(ItemStack value) {
        return value.isEmpty();
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, ItemStack value) {
        if (!value.isEmpty()) {
            builder.append(value.kjs$getIdLocation());
        }
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public String toString(OpsContainer ops, ItemStack value) {
        return value.kjs$toItemString0(ops.nbt());
    }

    @Override
    public void validate(RecipeValidationContext ctx, ItemStack value) {
        RecipeComponent.super.validate(ctx, value);
        if (!this.filter.isEmpty() && !this.filter.test(value)) {
            throw new InvalidRecipeComponentValueException("Item " + value.kjs$toItemString0(ctx.ops().nbt()) + " doesn't match filter " + this.filter.kjs$toIngredientString(ctx.ops().nbt()), this, value);
        }
    }

    @Override
    public List<ItemStack> spread(ItemStack value) {
        int count = value.getCount();
        if (count <= 0) {
            return List.of();
        }
        if (count == 1) {
            return List.of(value.copyWithCount(1));
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(count);
        for (int i = 0; i < count; ++i) {
            list.add(value.copyWithCount(1));
        }
        return list;
    }
}

