/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.holder.HolderWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ItemWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public record RegistryComponent<T>(Registry<T> registry, @Nullable RegistryType<T> regType, Codec<Holder<T>> codec, TypeInfo typeInfo) implements RecipeComponent<Holder<T>>
{
    public static final RecipeComponentType<?> TYPE = RecipeComponentType.dynamic(KubeJS.id("registry_element"), (type, ctx) -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)KubeJSCodecs.REGISTRY_KEY_CODEC.fieldOf("registry").forGetter(c -> c.registry.key())).apply((Applicative)instance, key -> new RegistryComponent(ctx.registries(), (ResourceKey)key))));

    public RegistryComponent(RegistryAccessContainer registries, @Nullable RegistryType<T> regType, ResourceKey key) {
        this((Registry<T>)((Registry)registries.access().registry(key).orElseThrow()), regType, (Codec<Holder<T>>)RegistryFixedCodec.create((ResourceKey)key), regType == null || regType.type() == TypeInfo.STRING ? TypeInfo.STRING : TypeInfo.STRING.or(regType.type()));
    }

    public RegistryComponent(RegistryAccessContainer registries, ResourceKey key) {
        this(registries, RegistryType.ofKey(key), key);
    }

    @Override
    public RecipeComponentType<?> type() {
        return TYPE;
    }

    @Override
    public Holder<T> wrap(RecipeScriptContext cx, Object from) {
        if (this.registry == BuiltInRegistries.ITEM) {
            if (from instanceof ItemStack) {
                ItemStack is = (ItemStack)from;
                return is.getItem().builtInRegistryHolder();
            }
            if (from instanceof Item) {
                Item item = (Item)from;
                return item.builtInRegistryHolder();
            }
            return ItemWrapper.wrap(cx.cx(), from).getItemHolder();
        }
        if (this.registry == BuiltInRegistries.FLUID) {
            if (from instanceof FluidStack) {
                FluidStack fs = (FluidStack)from;
                return fs.getFluid().builtInRegistryHolder();
            }
            if (from instanceof Fluid) {
                Fluid fluid = (Fluid)from;
                return fluid.builtInRegistryHolder();
            }
            return FluidWrapper.wrap(cx.registries(), from).getFluidHolder();
        }
        if (this.regType != null) {
            return HolderWrapper.wrap((KubeJSContext)cx.cx(), from, this.regType.type());
        }
        if (from instanceof ResourceKey) {
            ResourceKey key = (ResourceKey)from;
            return this.registry.getHolderOrThrow(key);
        }
        if (from instanceof CharSequence || from instanceof ResourceLocation) {
            return this.registry.getHolderOrThrow(ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)ID.mc(from.toString())));
        }
        throw new IllegalStateException("Missing key in " + String.valueOf(this.registry.key()) + ": " + String.valueOf(from));
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        JsonPrimitive json;
        return this.regType != null && this.regType.baseClass().isInstance(from) || from instanceof CharSequence && ID.mc(from.toString()) != null || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isString() && ID.mc(json.getAsString()) != null;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, Holder<T> value) {
        ResourceKey id = value.getKey();
        if (id != null) {
            builder.append(id.location());
        }
    }

    @Override
    public String toString() {
        return "registry_element<" + ID.reduce(this.registry.key().location()) + ">";
    }
}

