/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.latvian.mods.kubejs.command.CommandRegistryKubeEvent;
import dev.latvian.mods.kubejs.command.KubeJSCommands;
import dev.latvian.mods.kubejs.gui.chest.CustomChestMenu;
import dev.latvian.mods.kubejs.level.SimpleLevelKubeEvent;
import dev.latvian.mods.kubejs.plugin.builtin.event.LevelEvents;
import dev.latvian.mods.kubejs.plugin.builtin.event.ServerEvents;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.CommandKubeEvent;
import dev.latvian.mods.kubejs.server.KubeJSReloadListener;
import dev.latvian.mods.kubejs.server.ServerKubeEvent;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.web.LocalWebServer;
import dev.latvian.mods.kubejs.web.WebServerProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@EventBusSubscriber(modid="kubejs")
public class KubeJSServerEventHandler {
    private static final LevelResource PERSISTENT_DATA = new LevelResource("kubejs_persistent_data.nbt");

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        KubeJSCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        if (ServerEvents.COMMAND_REGISTRY.hasListeners()) {
            ServerEvents.COMMAND_REGISTRY.post(ScriptType.SERVER, new CommandRegistryKubeEvent((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection()));
        }
    }

    @SubscribeEvent
    public static void serverBeforeStart(ServerAboutToStartEvent event) {
        Path p;
        MinecraftServer server = event.getServer();
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER && !PlatformWrapper.isGeneratingData() && WebServerProperties.get().enabled && !WebServerProperties.get().publicAddress.isEmpty()) {
            LocalWebServer.start(server, false);
        }
        if (Files.exists(p = server.getWorldPath(PERSISTENT_DATA), new LinkOption[0])) {
            try {
                CompoundTag tag = NbtIo.readCompressed((Path)p, (NbtAccounter)NbtAccounter.unlimitedHeap());
                if (tag != null) {
                    CompoundTag t = tag.getCompound("__restore_inventories");
                    if (!t.isEmpty()) {
                        tag.remove("__restore_inventories");
                        Map playerMap = server.kjs$restoreInventories();
                        for (String key : t.getAllKeys()) {
                            ListTag list = t.getList(key, 10);
                            Map map = playerMap.computeIfAbsent(UUID.fromString(key), k -> new HashMap());
                            for (Tag tag2 : list) {
                                short slot = ((CompoundTag)tag2).getShort("Slot");
                                Optional stack = ItemStack.parse((HolderLookup.Provider)server.registryAccess(), (Tag)tag2);
                                if (!stack.isPresent()) continue;
                                map.put(Integer.valueOf(slot), (ItemStack)stack.get());
                            }
                        }
                    }
                    server.kjs$getPersistentData().merge(tag);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void serverStarting(ServerStartingEvent event) {
        ServerEvents.LOADED.post(ScriptType.SERVER, new ServerKubeEvent(event.getServer()));
    }

    @SubscribeEvent
    public static void serverStopping(ServerStoppingEvent event) {
        ServerEvents.UNLOADED.post(ScriptType.SERVER, new ServerKubeEvent(event.getServer()));
    }

    @SubscribeEvent
    public static void serverStopped(ServerStoppedEvent event) {
        RegistryAccessContainer.current = RegistryAccessContainer.BUILTIN;
    }

    @SubscribeEvent
    public static void serverLevelLoaded(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && LevelEvents.LOADED.hasListeners((ResourceKey<Level>)(level = (ServerLevel)levelAccessor).dimension())) {
            LevelEvents.LOADED.post(new SimpleLevelKubeEvent((Level)level), (ResourceKey<Level>)level.dimension());
        }
    }

    @SubscribeEvent
    public static void serverLevelSaved(LevelEvent.Save event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && LevelEvents.SAVED.hasListeners((ResourceKey<Level>)(level = (ServerLevel)levelAccessor).dimension())) {
            LevelEvents.SAVED.post(new SimpleLevelKubeEvent((Level)level), (ResourceKey<Level>)level.dimension());
        }
        if ((levelAccessor = event.getLevel()) instanceof ServerLevel && (level = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            CompoundTag serverData = level.getServer().kjs$getPersistentData().copy();
            Path p = level.getServer().getWorldPath(PERSISTENT_DATA);
            Map playerMap = level.getServer().kjs$restoreInventories();
            if (!playerMap.isEmpty()) {
                CompoundTag nbt = new CompoundTag();
                for (Map.Entry entry : playerMap.entrySet()) {
                    ListTag list = new ListTag();
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        CompoundTag tag = new CompoundTag();
                        tag.putShort("Slot", ((Integer)entry2.getKey()).shortValue());
                        ((ItemStack)entry2.getValue()).save((HolderLookup.Provider)level.registryAccess(), (Tag)tag);
                        list.add((Object)tag);
                    }
                    nbt.put(((UUID)entry.getKey()).toString(), (Tag)list);
                }
                serverData.put("__restore_inventories", (Tag)nbt);
            }
            Util.ioPool().execute(() -> {
                try {
                    NbtIo.writeCompressed((CompoundTag)serverData, (Path)p);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    @SubscribeEvent
    public static void command(CommandEvent event) {
        CommandKubeEvent e;
        if (ServerEvents.COMMAND.hasListeners() && ServerEvents.COMMAND.hasListeners((e = new CommandKubeEvent(event)).getCommandName())) {
            ServerEvents.COMMAND.post(e, e.getCommandName()).applyCancel((ICancellableEvent)event);
        }
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new KubeJSReloadListener(event.getServerResources()));
    }

    @SubscribeEvent
    public static void preventPickupDuringChestGUI(ItemEntityPickupEvent.Pre event) {
        ServerPlayer player;
        Player e = event.getPlayer();
        if (e instanceof ServerPlayer && (player = (ServerPlayer)e).isAlive() && !player.hasDisconnected() && player.containerMenu instanceof CustomChestMenu) {
            event.setCanPickup(TriState.FALSE);
        }
    }
}

