/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import dev.latvian.mods.kubejs.util.JsonSerializable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface JsonUtils {
    @HideFromJS
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().serializeNulls().create();
    public static final MapLike<JsonElement> MAP_LIKE = MapLike.forMap(Map.of(), (DynamicOps)JsonOps.INSTANCE);

    public static JsonElement copy(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return JsonNull.INSTANCE;
        }
        if (element instanceof JsonArray) {
            JsonArray a = new JsonArray();
            for (JsonElement e : (JsonArray)element) {
                a.add(JsonUtils.copy(e));
            }
            return a;
        }
        if (element instanceof JsonObject) {
            JsonObject o = new JsonObject();
            for (Map.Entry entry : ((JsonObject)element).entrySet()) {
                o.add((String)entry.getKey(), JsonUtils.copy((JsonElement)entry.getValue()));
            }
            return o;
        }
        return element;
    }

    public static JsonElement of(Context cx, @Nullable Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonElement.class, JsonSerializable.class, CharSequence.class, Boolean.class, Number.class, Character.class}, (Object)object, n)) {
            case 0 -> {
                JsonElement e = (JsonElement)object;
                yield e;
            }
            case 1 -> {
                JsonSerializable s = (JsonSerializable)object;
                yield s.toJson(cx);
            }
            case 2 -> {
                CharSequence ignore = (CharSequence)object;
                yield new JsonPrimitive(o.toString());
            }
            case 3 -> {
                Boolean b = (Boolean)object;
                yield new JsonPrimitive(b);
            }
            case 4 -> {
                Number n = (Number)object;
                yield new JsonPrimitive(n);
            }
            case 5 -> {
                Character c = (Character)object;
                yield new JsonPrimitive(c);
            }
            case -1 -> JsonNull.INSTANCE;
            default -> cx.isMapLike(o) ? JsonUtils.objectOf(cx, o) : (cx.isListLike(o) ? JsonUtils.arrayOf(cx, o) : JsonNull.INSTANCE);
        };
    }

    public static JsonPrimitive primitiveOf(Context cx, @Nullable Object o) {
        JsonPrimitive p;
        JsonElement jsonElement = JsonUtils.of(cx, o);
        return jsonElement instanceof JsonPrimitive ? (p = (JsonPrimitive)jsonElement) : null;
    }

    @Nullable
    public static JsonObject objectOf(Context cx, @Nullable Object map) {
        if (map instanceof JsonObject) {
            JsonObject json = (JsonObject)map;
            return json;
        }
        if (map instanceof CharSequence) {
            try {
                return (JsonObject)GSON.fromJson(map.toString(), JsonObject.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        Map m = (Map)cx.jsToJava(map, TypeInfo.RAW_MAP);
        if (m != null) {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : m.entrySet()) {
                Double d;
                Number number;
                JsonPrimitive p;
                JsonElement e = JsonUtils.of(cx, entry.getValue());
                if (e instanceof JsonPrimitive && (p = (JsonPrimitive)e).isNumber() && (number = p.getAsNumber()) instanceof Double && (d = (Double)number) <= 9.223372036854776E18 && d >= -9.223372036854776E18 && d == (double)d.longValue()) {
                    long l = d.longValue();
                    if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                        json.add(String.valueOf(entry.getKey()), (JsonElement)new JsonPrimitive((Number)((int)l)));
                        continue;
                    }
                    json.add(String.valueOf(entry.getKey()), (JsonElement)new JsonPrimitive((Number)l));
                    continue;
                }
                json.add(String.valueOf(entry.getKey()), e);
            }
            return json;
        }
        return null;
    }

    @Nullable
    public static JsonArray arrayOf(Context cx, @Nullable Object array) {
        if (array instanceof JsonArray) {
            JsonArray arr = (JsonArray)array;
            return arr;
        }
        if (array instanceof CharSequence) {
            try {
                return (JsonArray)GSON.fromJson(array.toString(), JsonArray.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (array instanceof Iterable) {
            Iterable itr = (Iterable)array;
            JsonArray json = new JsonArray();
            for (Object o1 : itr) {
                json.add(JsonUtils.of(cx, o1));
            }
            return json;
        }
        return null;
    }

    @Nullable
    public static Object toObject(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (json.isJsonObject()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            JsonObject o = json.getAsJsonObject();
            for (Map.Entry entry : o.entrySet()) {
                map.put((String)entry.getKey(), JsonUtils.toObject((JsonElement)entry.getValue()));
            }
            return map;
        }
        if (json.isJsonArray()) {
            JsonArray a = json.getAsJsonArray();
            ArrayList<Object> objects = new ArrayList<Object>(a.size());
            for (JsonElement e : a) {
                objects.add(JsonUtils.toObject(e));
            }
            return objects;
        }
        return JsonUtils.toPrimitive(json);
    }

    public static String toString(JsonElement json) {
        return GSON.toJson(json);
    }

    public static String toPrettyString(JsonElement json) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        jsonWriter.setIndent("\t");
        GSON.toJson(json, jsonWriter);
        return writer.toString();
    }

    public static JsonElement fromString(@Nullable String string) {
        if (string == null || string.isEmpty() || string.equals("null")) {
            return JsonNull.INSTANCE;
        }
        try {
            return (JsonElement)GSON.fromJson(string, JsonElement.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JsonNull.INSTANCE;
        }
    }

    @Nullable
    public static Object toPrimitive(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive p = element.getAsJsonPrimitive();
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                return p.getAsNumber();
            }
            try {
                Double.parseDouble(p.getAsString());
                return p.getAsNumber();
            }
            catch (Exception ex) {
                return p.getAsString();
            }
        }
        return null;
    }
}

