/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.entity;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachment;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentFactory;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentInfo;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentType;
import dev.latvian.mods.kubejs.block.entity.KubeBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class FluidTankAttachment
implements BlockEntityAttachment {
    public static final BlockEntityAttachmentType TYPE = new BlockEntityAttachmentType(KubeJS.id("fluid_tank"), Factory.class);
    public final KubeBlockEntity entity;
    public final Wrapped fluidTank;

    public FluidTankAttachment(KubeBlockEntity entity, int capacity, Predicate<FluidStack> filter) {
        this.entity = entity;
        this.fluidTank = new Wrapped(this, capacity, filter);
    }

    @Override
    public Object getWrappedObject() {
        return this.fluidTank;
    }

    @Override
    @Nullable
    public <CAP, SRC> CAP getCapability(BlockCapability<CAP, SRC> capability) {
        if (capability == Capabilities.FluidHandler.BLOCK) {
            return (CAP)((Object)this.fluidTank);
        }
        return null;
    }

    @Override
    @Nullable
    public Tag serialize(HolderLookup.Provider registries) {
        return this.fluidTank.getFluid().isEmpty() ? null : this.fluidTank.getFluid().save(registries);
    }

    @Override
    public void deserialize(HolderLookup.Provider registries, @Nullable Tag tag) {
        this.fluidTank.setFluid(tag == null ? FluidStack.EMPTY : FluidStack.parse((HolderLookup.Provider)registries, (Tag)tag).orElse(FluidStack.EMPTY));
    }

    public static class Wrapped
    extends FluidTank {
        private final FluidTankAttachment attachment;

        public Wrapped(FluidTankAttachment attachment, int capacity, Predicate<FluidStack> inputFilter) {
            super(capacity, inputFilter);
            this.attachment = attachment;
        }

        protected void onContentsChanged() {
            this.attachment.entity.save();
        }
    }

    public record Factory(int capacity, Optional<FluidIngredient> inputFilter) implements BlockEntityAttachmentFactory
    {
        private static final Predicate<FluidStack> ALWAYS_TRUE = stack -> true;

        @Override
        public BlockEntityAttachment create(BlockEntityAttachmentInfo info, KubeBlockEntity entity) {
            return new FluidTankAttachment(entity, this.capacity, this.inputFilter.isEmpty() ? ALWAYS_TRUE : (Predicate)this.inputFilter.get());
        }

        @Override
        public List<BlockCapability<?, ?>> getCapabilities() {
            return List.of(Capabilities.FluidHandler.BLOCK);
        }
    }
}

