/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.component.MutableDataComponentHolderFunctions;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.fluid.FluidLike;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.WithCodec;
import dev.latvian.mods.kubejs.web.RelativeURL;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public interface FluidStackKJS
extends Replaceable,
SpecialEquality,
WithCodec,
FluidLike,
FluidMatch,
MutableDataComponentHolderFunctions,
RegistryObjectKJS<Fluid> {
    default public FluidStack kjs$self() {
        return (FluidStack)this;
    }

    @Override
    default public boolean specialEquals(Context cx, Object o, boolean shallow) {
        if (o instanceof CharSequence) {
            return this.kjs$getId().equals(ID.string(o.toString()));
        }
        if (o instanceof ResourceLocation) {
            return this.kjs$getIdLocation().equals(o);
        }
        if (o instanceof FluidStack) {
            FluidStack s = (FluidStack)o;
            return this.kjs$equalsIgnoringCount(s);
        }
        return this.kjs$equalsIgnoringCount(FluidWrapper.wrap(RegistryAccessContainer.of(cx), o));
    }

    default public boolean kjs$equalsIgnoringCount(FluidStack stack) {
        FluidStack self = this.kjs$self();
        if (self == stack) {
            return true;
        }
        if (self.isEmpty()) {
            return stack.isEmpty();
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)self, (FluidStack)stack);
    }

    @Override
    default public ResourceKey<Registry<Fluid>> kjs$getRegistryId() {
        return Registries.FLUID;
    }

    @Override
    default public Registry<Fluid> kjs$getRegistry() {
        return BuiltInRegistries.FLUID;
    }

    @Override
    default public ResourceLocation kjs$getIdLocation() {
        return this.kjs$self().getFluid().kjs$getIdLocation();
    }

    @Override
    default public Holder<Fluid> kjs$asHolder() {
        return this.kjs$self().getFluid().kjs$asHolder();
    }

    @Override
    default public ResourceKey<Fluid> kjs$getKey() {
        return this.kjs$self().getFluid().kjs$getKey();
    }

    @Override
    default public String kjs$getId() {
        return this.kjs$self().getFluid().kjs$getId();
    }

    @Override
    default public String kjs$getMod() {
        return this.kjs$self().getFluid().kjs$getMod();
    }

    @Override
    default public int kjs$getAmount() {
        return this.kjs$self().getAmount();
    }

    @Override
    default public boolean kjs$isEmpty() {
        return this.kjs$self().isEmpty();
    }

    @Override
    default public Fluid kjs$getFluid() {
        return this.kjs$self().getFluid();
    }

    @Override
    default public FluidLike kjs$copy(int amount) {
        return (FluidLike)this.kjs$self().copyWithAmount(amount);
    }

    @Override
    default public Codec<?> getCodec(Context cx) {
        return FluidStack.CODEC;
    }

    @Override
    default public Object replaceThisWith(RecipeScriptContext cx, Object with) {
        FluidStack r;
        FluidStack t = this.kjs$self();
        if (!FluidStack.isSameFluidSameComponents((FluidStack)t, (FluidStack)(r = FluidWrapper.wrap(cx.registries(), with)))) {
            r.setAmount(t.getAmount());
            return r;
        }
        return this;
    }

    @Override
    default public boolean matches(RecipeMatchContext cx, FluidStack s, boolean exact) {
        return this.kjs$self().getFluid() == s.getFluid();
    }

    @Override
    default public boolean matches(RecipeMatchContext cx, FluidIngredient ingredient, boolean exact) {
        return ingredient.test(this.kjs$self());
    }

    default public RelativeURL kjs$getWebIconURL(DynamicOps<Tag> ops, int size) {
        String url = "/img/" + size + "/fluid/" + ID.url(this.kjs$getIdLocation());
        String c = DataComponentWrapper.patchToString(new StringBuilder(), ops, DataComponentWrapper.visualPatch(this.kjs$self().getComponentsPatch())).toString();
        return new RelativeURL(url, c.equals("[]") ? Map.of() : Map.of("components", c.substring(1, c.length() - 1)));
    }
}

