/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.core.ReloadableServerResourcesKJS;
import dev.latvian.mods.kubejs.plugin.builtin.event.ServerEvents;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.server.tag.PreTagKubeEvent;
import dev.latvian.mods.kubejs.server.tag.TagEventFilter;
import dev.latvian.mods.kubejs.server.tag.TagKubeEvent;
import dev.latvian.mods.kubejs.server.tag.TagWrapper;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import org.jetbrains.annotations.Nullable;

public interface TagLoaderKJS<T> {
    default public void kjs$customTags(ReloadableServerResourcesKJS kjs$resources, Map<ResourceLocation, List<TagLoader.EntryWithSource>> map) {
        Registry<T> reg = this.kjs$getRegistry();
        if (reg == null) {
            return;
        }
        RegistryObjectStorage objStorage = RegistryObjectStorage.of(reg.key());
        boolean hasDefaultTags = false;
        for (BuilderBase builderBase : objStorage.objects.values()) {
            if (builderBase.defaultTags.isEmpty()) continue;
            hasDefaultTags = true;
            break;
        }
        if (hasDefaultTags || ServerEvents.TAGS.hasListeners(objStorage.key)) {
            PreTagKubeEvent preEvent = this.kjs$getResources().kjs$getServerScriptManager().preTagEvents.get(reg.key());
            TagKubeEvent tagKubeEvent = new TagKubeEvent(objStorage.key, reg);
            for (Map.Entry<ResourceLocation, List<TagLoader.EntryWithSource>> entry : map.entrySet()) {
                TagWrapper w = new TagWrapper(tagKubeEvent, entry.getKey(), entry.getValue());
                tagKubeEvent.tags.put(w.id, w);
                if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                ConsoleJS.SERVER.debug("Tags %s/#%s; %d".formatted(objStorage, w.id, w.entries.size()));
            }
            for (BuilderBase builderBase : objStorage.objects.values()) {
                for (ResourceLocation s : builderBase.defaultTags) {
                    tagKubeEvent.add(s, new TagEventFilter.ID(builderBase.id));
                }
            }
            if (preEvent == null) {
                ServerEvents.TAGS.post(tagKubeEvent, objStorage.key);
            } else {
                for (Consumer consumer : preEvent.actions) {
                    consumer.accept(tagKubeEvent);
                }
            }
            map.clear();
            for (Map.Entry entry : tagKubeEvent.tags.entrySet()) {
                map.put((ResourceLocation)entry.getKey(), ((TagWrapper)entry.getValue()).entries);
            }
            if (tagKubeEvent.totalAdded > 0 || tagKubeEvent.totalRemoved > 0 || ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.info("[%s] Found %d tags, added %d objects, removed %d objects".formatted(objStorage, tagKubeEvent.tags.size(), tagKubeEvent.totalAdded, tagKubeEvent.totalRemoved));
            }
        }
        kjs$resources.kjs$getServerScriptManager().getRegistries().cacheTags(reg, map);
    }

    public void kjs$init(ReloadableServerResourcesKJS var1, Registry<T> var2);

    public ReloadableServerResourcesKJS kjs$getResources();

    @Nullable
    public Registry<T> kjs$getRegistry();
}

