/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.util.NBTSerializable;
import dev.latvian.mods.kubejs.util.NBTUtils;
import dev.latvian.mods.kubejs.util.OrderedCompoundTag;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Undefined;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public interface NBTWrapper {
    public static boolean isTagCompound(Object o) {
        return o == null || Undefined.isUndefined((Object)o) || o instanceof CompoundTag || o instanceof CharSequence || o instanceof Map || o instanceof JsonElement;
    }

    public static boolean isTagCollection(Object o) {
        return o == null || Undefined.isUndefined((Object)o) || o instanceof CharSequence || o instanceof Collection || o instanceof JsonArray;
    }

    @Nullable
    public static Object fromTag(@Nullable Tag t) {
        Tag tag = t;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EndTag.class, StringTag.class, NumericTag.class, CompoundTag.class, CollectionTag.class}, (Object)tag, n)) {
            case -1 -> null;
            case 0 -> {
                EndTag ignore = (EndTag)tag;
                yield null;
            }
            case 1 -> {
                StringTag ignore = (StringTag)tag;
                yield t.getAsString();
            }
            case 2 -> {
                NumericTag num = (NumericTag)tag;
                yield num.getAsNumber();
            }
            case 3 -> {
                CompoundTag tag = (CompoundTag)tag;
                if (tag.isEmpty()) {
                    yield Map.of();
                }
                Map<String, Tag> map0 = NBTUtils.accessTagMap(tag);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(map0.size());
                for (Map.Entry<String, Tag> entry : map0.entrySet()) {
                    map.put(entry.getKey(), NBTWrapper.fromTag(entry.getValue()));
                }
                yield map;
            }
            case 4 -> {
                CollectionTag tag = (CollectionTag)tag;
                if (tag.isEmpty()) {
                    yield List.of();
                }
                ArrayList<Object> list = new ArrayList<Object>(tag.size());
                for (Tag v : tag) {
                    list.add(NBTWrapper.fromTag(v));
                }
                yield list;
            }
            default -> t;
        };
    }

    @Nullable
    public static Tag toTag(@Nullable Tag tag) {
        return tag;
    }

    @Nullable
    public static Tag wrap(Context cx, @Nullable Object v) {
        if (v == null || v instanceof EndTag) {
            return null;
        }
        if (v instanceof Tag) {
            Tag tag = (Tag)v;
            return tag;
        }
        if (v instanceof NBTSerializable) {
            NBTSerializable s = (NBTSerializable)v;
            return s.toNBT(cx);
        }
        if (v instanceof CharSequence || v instanceof Character) {
            return StringTag.valueOf((String)v.toString());
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return ByteTag.valueOf((boolean)b);
        }
        if (v instanceof Number) {
            Number number = (Number)v;
            if (number instanceof Byte) {
                return ByteTag.valueOf((byte)number.byteValue());
            }
            if (number instanceof Short) {
                return ShortTag.valueOf((short)number.shortValue());
            }
            if (number instanceof Integer) {
                return IntTag.valueOf((int)number.intValue());
            }
            if (number instanceof Long) {
                return LongTag.valueOf((long)number.longValue());
            }
            if (number instanceof Float) {
                return FloatTag.valueOf((float)number.floatValue());
            }
            return DoubleTag.valueOf((double)number.doubleValue());
        }
        if (v instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)v;
            if (json.isNumber()) {
                return NBTWrapper.wrap(cx, json.getAsNumber());
            }
            if (json.isBoolean()) {
                return ByteTag.valueOf((boolean)json.getAsBoolean());
            }
            return StringTag.valueOf((String)json.getAsString());
        }
        if (v instanceof Map) {
            Map map = (Map)v;
            OrderedCompoundTag tag = new OrderedCompoundTag();
            for (Map.Entry entry : map.entrySet()) {
                Tag nbt1 = NBTWrapper.wrap(cx, entry.getValue());
                if (nbt1 == null) continue;
                tag.put(String.valueOf(entry.getKey()), nbt1);
            }
            return tag;
        }
        if (v instanceof JsonObject) {
            JsonObject json = (JsonObject)v;
            OrderedCompoundTag tag = new OrderedCompoundTag();
            for (Map.Entry entry : json.entrySet()) {
                Tag nbt1 = NBTWrapper.wrap(cx, entry.getValue());
                if (nbt1 == null) continue;
                tag.put((String)entry.getKey(), nbt1);
            }
            return tag;
        }
        if (v instanceof Collection) {
            Collection c = (Collection)v;
            return NBTWrapper.wrapCollection0(cx, c);
        }
        if (v instanceof JsonArray) {
            JsonArray array = (JsonArray)v;
            ArrayList<Tag> list = new ArrayList<Tag>(array.size());
            for (JsonElement element : array) {
                list.add(NBTWrapper.wrap(cx, element));
            }
            return NBTWrapper.wrapCollection0(cx, list);
        }
        return null;
    }

    @Nullable
    public static CompoundTag wrapCompound(Context cx, @Nullable Object v) {
        CompoundTag compoundTag;
        Object object = v;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompoundTag.class, CharSequence.class, JsonPrimitive.class, JsonObject.class}, (Object)object, n)) {
            case -1: {
                CompoundTag compoundTag2;
                compoundTag = compoundTag2 = null;
                break;
            }
            case 0: {
                CompoundTag nbt;
                CompoundTag compoundTag3;
                compoundTag = compoundTag3 = (nbt = (CompoundTag)object);
                break;
            }
            case 1: {
                CharSequence ignored = (CharSequence)object;
                try {
                    CompoundTag compoundTag4;
                    compoundTag = compoundTag4 = TagParser.parseTag((String)v.toString());
                    break;
                }
                catch (Exception ex) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)ex, (Context)cx);
                }
            }
            case 2: {
                JsonPrimitive json = (JsonPrimitive)object;
                try {
                    CompoundTag compoundTag5;
                    compoundTag = compoundTag5 = TagParser.parseTag((String)json.getAsString());
                    break;
                }
                catch (Exception ex) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)ex, (Context)cx);
                }
            }
            case 3: {
                JsonObject json = (JsonObject)object;
                try {
                    CompoundTag compoundTag6;
                    compoundTag = compoundTag6 = TagParser.parseTag((String)json.toString());
                    break;
                }
                catch (Exception ex) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)ex, (Context)cx);
                }
            }
            default: {
                CompoundTag nbt;
                CompoundTag compoundTag7;
                Tag tag = NBTWrapper.wrap(cx, v);
                compoundTag = compoundTag7 = tag instanceof CompoundTag ? (nbt = (CompoundTag)tag) : null;
            }
        }
        return compoundTag;
    }

    @Nullable
    public static CollectionTag<?> wrapCollection(Context cx, @Nullable Object v) {
        CollectionTag<?> collectionTag;
        Object object = v;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CollectionTag.class, CharSequence.class, JsonArray.class}, (Object)object, n)) {
            case -1: {
                CollectionTag<?> collectionTag2;
                collectionTag = collectionTag2 = null;
                break;
            }
            case 0: {
                CollectionTag<?> tag;
                CollectionTag<?> collectionTag3;
                collectionTag = collectionTag3 = (tag = (CollectionTag<?>)object);
                break;
            }
            case 1: {
                CharSequence ignored = (CharSequence)object;
                try {
                    CollectionTag<?> collectionTag4;
                    collectionTag = collectionTag4 = (CollectionTag<?>)TagParser.parseTag((String)("{a:" + String.valueOf(v) + "}")).get("a");
                    break;
                }
                catch (Exception ex) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)ex, (Context)cx);
                }
            }
            case 2: {
                CollectionTag<?> collectionTag5;
                JsonArray array = (JsonArray)object;
                ArrayList<Tag> list = new ArrayList<Tag>(array.size());
                for (JsonElement element : array) {
                    list.add(NBTWrapper.wrap(cx, element));
                }
                collectionTag = collectionTag5 = NBTWrapper.wrapCollection0(cx, list);
                break;
            }
            default: {
                CollectionTag<?> collectionTag6;
                collectionTag = collectionTag6 = NBTWrapper.wrapCollection0(cx, (Collection)v);
            }
        }
        return collectionTag;
    }

    @Nullable
    public static ListTag wrapListTag(Context cx, @Nullable Object list) {
        return (ListTag)NBTWrapper.wrapCollection(cx, list);
    }

    private static CollectionTag<?> wrapCollection0(Context cx, Collection<?> c) {
        Object[] array;
        if (c.isEmpty()) {
            return new ListTag();
        }
        Tag[] values = new Tag[c.size()];
        int s = 0;
        byte commmonId = -1;
        for (Object o : c) {
            values[s] = NBTWrapper.wrap(cx, o);
            if (values[s] == null) continue;
            if (commmonId == -1) {
                commmonId = values[s].getId();
            } else if (commmonId != values[s].getId()) {
                commmonId = 0;
            }
            ++s;
        }
        if (commmonId == 3) {
            array = new int[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumericTag)values[i]).getAsInt();
            }
            return new IntArrayTag(array);
        }
        if (commmonId == 1) {
            array = new byte[s];
            for (int i = 0; i < s; ++i) {
                array[i] = ((NumericTag)values[i]).getAsByte();
            }
            return new ByteArrayTag((byte[])array);
        }
        if (commmonId == 4) {
            array = new long[s];
            for (int i = 0; i < s; ++i) {
                array[i] = (int)((NumericTag)values[i]).getAsLong();
            }
            return new LongArrayTag((long[])array);
        }
        if (commmonId == 0 || commmonId == -1) {
            return new ListTag();
        }
        ListTag nbt = new ListTag();
        for (Tag nbt1 : values) {
            if (nbt1 == null) {
                return nbt;
            }
            nbt.add((Object)nbt1);
        }
        return nbt;
    }

    public static Tag compoundTag() {
        return new OrderedCompoundTag();
    }

    public static Tag compoundTag(Context cx, Map<?, ?> map) {
        OrderedCompoundTag tag = new OrderedCompoundTag();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Tag tag1 = NBTWrapper.wrap(cx, entry.getValue());
            if (tag1 == null) continue;
            tag.put(String.valueOf(entry.getKey()), tag1);
        }
        return tag;
    }

    public static Tag listTag() {
        return new ListTag();
    }

    public static Tag listTag(Context cx, List<?> list) {
        ListTag tag = new ListTag();
        for (Object v : list) {
            tag.add((Object)NBTWrapper.wrap(cx, v));
        }
        return tag;
    }

    public static Tag byteTag(byte v) {
        return ByteTag.valueOf((byte)v);
    }

    public static Tag b(byte v) {
        return ByteTag.valueOf((byte)v);
    }

    public static Tag shortTag(short v) {
        return ShortTag.valueOf((short)v);
    }

    public static Tag s(short v) {
        return ShortTag.valueOf((short)v);
    }

    public static Tag intTag(int v) {
        return IntTag.valueOf((int)v);
    }

    public static Tag i(int v) {
        return IntTag.valueOf((int)v);
    }

    public static Tag longTag(long v) {
        return LongTag.valueOf((long)v);
    }

    public static Tag l(long v) {
        return LongTag.valueOf((long)v);
    }

    public static Tag floatTag(float v) {
        return FloatTag.valueOf((float)v);
    }

    public static Tag f(float v) {
        return FloatTag.valueOf((float)v);
    }

    public static Tag doubleTag(double v) {
        return DoubleTag.valueOf((double)v);
    }

    public static Tag d(double v) {
        return DoubleTag.valueOf((double)v);
    }

    public static Tag stringTag(String v) {
        return StringTag.valueOf((String)v);
    }

    public static Tag intArrayTag(int[] v) {
        return new IntArrayTag(v);
    }

    public static Tag ia(int[] v) {
        return new IntArrayTag(v);
    }

    public static Tag longArrayTag(long[] v) {
        return new LongArrayTag(v);
    }

    public static Tag la(long[] v) {
        return new LongArrayTag(v);
    }

    public static Tag byteArrayTag(byte[] v) {
        return new ByteArrayTag(v);
    }

    public static Tag ba(byte[] v) {
        return new ByteArrayTag(v);
    }

    public static JsonElement toJson(@Nullable Tag t) {
        return NBTUtils.toJson(t);
    }

    @Nullable
    public static OrderedCompoundTag read(FriendlyByteBuf buf) {
        return NBTUtils.read(buf);
    }
}

