/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.script.SourceLine;
import java.util.function.Function;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;

public class KubeRecipeEventOps<T>
extends ConditionalOps<T> {
    private final RecipesKubeEvent event;
    public static final Codec<KubeRecipe> KUBE_RECIPE_CODEC = Codec.of((Encoder)ExtraCodecs.JSON.comap(recipe -> {
        recipe.serialize();
        recipe.json.addProperty("type", recipe.type.idString);
        return recipe.json;
    }), (Decoder)new Decoder<KubeRecipe>(){

        public <V> DataResult<Pair<KubeRecipe, V>> decode(DynamicOps<V> ops, V input) {
            if (!(ops instanceof KubeRecipeEventOps)) {
                return DataResult.error(() -> "Component requires recipe event context, but wasn't specified!");
            }
            KubeRecipeEventOps recipeOps = (KubeRecipeEventOps)ops;
            JsonElement json = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
            if (!(json instanceof JsonObject)) {
                return DataResult.error(() -> "Not a JSON object: " + String.valueOf(input));
            }
            return recipeOps.event.parseJson(json.getAsJsonObject(), SourceLine.UNKNOWN).map(recipe -> Pair.of((Object)recipe, (Object)ops.empty()));
        }
    });
    public static final Function<KubeRecipe, KubeRecipe> MARK_SYNTHETIC = r -> {
        r.newRecipe = false;
        return r;
    };
    public static final Codec<KubeRecipe> SYNTHETIC_CODEC = KUBE_RECIPE_CODEC.xmap(MARK_SYNTHETIC, MARK_SYNTHETIC);

    public KubeRecipeEventOps(RecipesKubeEvent event, RegistryOps<T> ops) {
        super(ops, (ICondition.IContext)event.registries);
        this.event = event;
    }
}

