/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.core.RecipeManagerKJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.error.RecipeComponentException;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.plugin.builtin.event.ServerEvents;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.StringUtilsWrapper;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.KubeRecipeEventOps;
import dev.latvian.mods.kubejs.recipe.NamespaceFunction;
import dev.latvian.mods.kubejs.recipe.RecipeFunction;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.filter.ConstantFilter;
import dev.latvian.mods.kubejs.recipe.filter.IDFilter;
import dev.latvian.mods.kubejs.recipe.filter.OrFilter;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.filter.RegexIDFilter;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType;
import dev.latvian.mods.kubejs.recipe.schema.UnknownRecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeFunctionInstance;
import dev.latvian.mods.kubejs.recipe.special.SpecialRecipeSerializerManager;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.server.ChangesForChat;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.ErrorStack;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.RegistryOpsContainer;
import dev.latvian.mods.kubejs.util.TimeJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import org.jetbrains.annotations.Nullable;

public class RecipesKubeEvent
implements KubeEvent {
    public static final Pattern POST_SKIP_ERROR = ConsoleJS.methodPattern(RecipesKubeEvent.class, "post");
    public static final Pattern CREATE_RECIPE_SKIP_ERROR = ConsoleJS.methodPattern(RecipesKubeEvent.class, "createRecipe");
    private static final Predicate<KubeRecipe> RECIPE_NOT_REMOVED = r -> r != null && !r.removed;
    private static final Predicate<KubeRecipe> RECIPE_IS_SYNTHETIC = r -> !r.newRecipe;
    private final Stopwatch overallTimer;
    public final RecipeSchemaStorage recipeSchemaStorage;
    public final RegistryAccessContainer registries;
    public final ResourceManager resourceManager;
    public final RegistryOpsContainer ops;
    public final Map<ResourceLocation, KubeRecipe> originalRecipes;
    public final Collection<KubeRecipe> addedRecipes;
    public final Collection<KubeRecipe> removedRecipes;
    int modifiedCount;
    int failedCount;
    private final Map<ResourceLocation, KubeRecipe> takenIds;
    private final Map<String, Object> recipeFunctions;
    public final transient RecipeTypeFunction vanillaShaped;
    public final transient RecipeTypeFunction vanillaShapeless;
    public final RecipeTypeFunction shaped;
    public final RecipeTypeFunction shapeless;
    public final RecipeTypeFunction smelting;
    public final RecipeTypeFunction blasting;
    public final RecipeTypeFunction smoking;
    public final RecipeTypeFunction campfireCooking;
    public final RecipeTypeFunction stonecutting;
    public final RecipeTypeFunction smithing;
    public final RecipeTypeFunction smithingTrim;
    final RecipeSerializer<?> stageSerializer;

    public RecipesKubeEvent(ServerScriptManager manager, ResourceManager resourceManager) {
        ConsoleJS.SERVER.info("Initializing recipe event...");
        this.overallTimer = Stopwatch.createStarted();
        this.recipeSchemaStorage = manager.recipeSchemaStorage;
        this.registries = manager.getRegistries();
        this.resourceManager = resourceManager;
        this.ops = new RegistryOpsContainer((RegistryOps<Tag>)new KubeRecipeEventOps<Tag>(this, this.registries.nbt()), (RegistryOps<JsonElement>)new KubeRecipeEventOps<JsonElement>(this, this.registries.json()), (RegistryOps<Object>)new KubeRecipeEventOps<Object>(this, this.registries.java()));
        this.originalRecipes = new HashMap<ResourceLocation, KubeRecipe>();
        this.addedRecipes = new ConcurrentLinkedQueue<KubeRecipe>();
        this.removedRecipes = new ConcurrentLinkedQueue<KubeRecipe>();
        this.recipeFunctions = new HashMap<String, Object>();
        this.takenIds = new ConcurrentHashMap<ResourceLocation, KubeRecipe>();
        for (RecipeNamespace recipeNamespace : this.recipeSchemaStorage.namespaces.values()) {
            HashMap<String, RecipeTypeFunction> nsMap = new HashMap<String, RecipeTypeFunction>();
            this.recipeFunctions.put(recipeNamespace.name, new NamespaceFunction(recipeNamespace, nsMap));
            for (Map.Entry entry : recipeNamespace.entrySet()) {
                RecipeTypeFunction func = new RecipeTypeFunction(this, (RecipeSchemaType)entry.getValue());
                nsMap.put(((RecipeSchemaType)entry.getValue()).id.getPath(), func);
                this.recipeFunctions.put(((RecipeSchemaType)entry.getValue()).id.toString(), func);
            }
        }
        this.vanillaShaped = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:crafting_shaped");
        this.vanillaShapeless = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:crafting_shapeless");
        this.shaped = CommonProperties.get().serverOnly ? this.vanillaShaped : (RecipeTypeFunction)this.recipeFunctions.get("kubejs:shaped");
        this.shapeless = CommonProperties.get().serverOnly ? this.vanillaShapeless : (RecipeTypeFunction)this.recipeFunctions.get("kubejs:shapeless");
        this.smelting = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smelting");
        this.blasting = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:blasting");
        this.smoking = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smoking");
        this.campfireCooking = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:campfire_cooking");
        this.stonecutting = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:stonecutting");
        this.smithing = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smithing_transform");
        this.smithingTrim = (RecipeTypeFunction)this.recipeFunctions.get("minecraft:smithing_trim");
        for (Map.Entry entry : new ArrayList<Map.Entry<String, Object>>(this.recipeFunctions.entrySet())) {
            String s;
            if (!(entry.getValue() instanceof RecipeTypeFunction) || ((String)entry.getKey()).indexOf(58) == -1 || (s = StringUtilsWrapper.snakeCaseToCamelCase((String)entry.getKey())).equals(entry.getKey())) continue;
            this.recipeFunctions.put(s, entry.getValue());
        }
        for (Map.Entry entry : this.recipeSchemaStorage.mappings.entrySet()) {
            Object type = this.recipeFunctions.get(((ResourceLocation)entry.getValue()).toString());
            if (!(type instanceof RecipeTypeFunction)) continue;
            this.recipeFunctions.put((String)entry.getKey(), type);
        }
        this.recipeFunctions.put("shaped", this.shaped);
        this.recipeFunctions.put("shapeless", this.shapeless);
        this.recipeFunctions.put("smelting", this.smelting);
        this.recipeFunctions.put("blasting", this.blasting);
        this.recipeFunctions.put("smoking", this.smoking);
        this.recipeFunctions.put("campfireCooking", this.campfireCooking);
        this.recipeFunctions.put("stonecutting", this.stonecutting);
        this.recipeFunctions.put("smithing", this.smithing);
        this.recipeFunctions.put("smithingTrim", this.smithingTrim);
        this.stageSerializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(ResourceLocation.parse((String)"recipestages:stage"));
    }

    @HideFromJS
    public void post(RecipeManagerKJS recipeManager, Map<ResourceLocation, JsonElement> datapackRecipeMap) {
        this.discoverRecipes(recipeManager, datapackRecipeMap);
        this.postEvent();
        this.applyChanges(datapackRecipeMap);
    }

    /*
     * Unable to fully structure code
     */
    @HideFromJS
    public void discoverRecipes(RecipeManagerKJS recipeManager, Map<ResourceLocation, JsonElement> datapackRecipeMap) {
        block11: {
            timer = Stopwatch.createStarted();
            KubeJSPlugins.forEachPlugin((Consumer<KubeJSPlugin>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$discoverRecipes$2(dev.latvian.mods.kubejs.core.RecipeManagerKJS java.util.Map dev.latvian.mods.kubejs.plugin.KubeJSPlugin ), (Ldev/latvian/mods/kubejs/plugin/KubeJSPlugin;)V)((RecipesKubeEvent)this, (RecipeManagerKJS)recipeManager, datapackRecipeMap));
            skippedRecipes = 0;
            block7: for (Map.Entry<ResourceLocation, JsonElement> entry : datapackRecipeMap.entrySet()) {
                recipeId = entry.getKey();
                if (recipeId == null || recipeId.getPath().startsWith("_")) {
                    this.infoSkip("Skipping recipe %s, filename starts with _".formatted(new Object[]{recipeId}));
                    ++skippedRecipes;
                    continue;
                }
                originalJsonElement = entry.getValue();
                if (!originalJsonElement.isJsonObject()) {
                    this.warnSkip("Skipping recipe %s, not a json object".formatted(new Object[]{recipeId}));
                    continue;
                }
                originalJson = originalJsonElement.getAsJsonObject();
                if (!originalJson.has("type")) {
                    this.warnSkip("Skipping recipe %s, not a json object".formatted(new Object[]{recipeId}));
                    continue;
                }
                codec = ConditionalOps.createConditionalCodec((Codec)Codec.unit((Object)originalJson));
                Objects.requireNonNull(codec.parse(this.ops.json(), (Object)originalJson));
                var12_13 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)var11_12, var12_13)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        var13_14 = (DataResult.Success)var11_12;
                        jsonResult = var16_17 = (Optional)var13_14.value();
                        lifecycle = var16_17 = var13_14.lifecycle();
                        if (!jsonResult.isEmpty()) ** GOTO lbl35
                        this.infoSkip("Skipping recipe %s, conditions not met".formatted(new Object[]{recipeId}));
                        ++skippedRecipes;
                        continue block7;
lbl35:
                        // 1 sources

                        this.parseOriginalRecipe((JsonObject)jsonResult.get(), recipeId);
                        continue block7;
                    }
                    case 1: 
                }
                error = (DataResult.Error)var11_12;
                this.errorSkip("Skipping recipe %s, error parsing conditions: %s".formatted(new Object[]{recipeId, error.message()}));
            }
            break block11;
            catch (Throwable var5_6) {
                throw new MatchException(var5_6.toString(), var5_6);
            }
        }
        this.takenIds.putAll(this.originalRecipes);
        ConsoleJS.SERVER.info("Found %,d recipes (skipped %,d) in %s".formatted(new Object[]{this.originalRecipes.size(), skippedRecipes, timer.stop()}));
    }

    private void parseOriginalRecipe(JsonObject json, ResourceLocation recipeId) {
        String typeStr = GsonHelper.getAsString((JsonObject)json, (String)"type");
        String recipeIdAndType = String.valueOf(recipeId) + "[" + typeStr + "]";
        RecipeTypeFunction type = this.getRecipeFunction(typeStr);
        if (type == null) {
            this.warnSkip("Skipping recipe %s, unknown type: %s".formatted(recipeId, typeStr));
            return;
        }
        ErrorStack stack = new ErrorStack();
        try {
            KubeRecipe recipe = type.schemaType.schema.deserialize(SourceLine.UNKNOWN, type, recipeId, json);
            recipe.afterLoaded(stack);
            this.originalRecipes.put(recipeId, recipe);
            if (ConsoleJS.SERVER.shouldPrintDebug()) {
                Recipe<?> original = recipe.getOriginalRecipe();
                if (original == null || SpecialRecipeSerializerManager.INSTANCE.isSpecial(original)) {
                    ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": <dynamic>");
                } else {
                    ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": " + recipe.getFromToString());
                }
            }
        }
        catch (Throwable ex) {
            String recipeStr = "'%s'%s".formatted(recipeIdAndType, stack.atString());
            if (ex instanceof RecipeComponentException || DevProperties.get().logErroringParsedRecipes) {
                ConsoleJS.SERVER.warn("Failed to parse recipe %s! Falling back to vanilla".formatted(recipeStr), ex, POST_SKIP_ERROR);
            }
            try {
                this.originalRecipes.put(recipeId, UnknownRecipeSchema.SCHEMA.deserialize(SourceLine.UNKNOWN, type, recipeId, json));
            }
            catch (JsonParseException | IllegalArgumentException | NullPointerException ex2) {
                if (DevProperties.get().logErroringParsedRecipes) {
                    ConsoleJS.SERVER.error("Failed to parse recipe %s".formatted(recipeStr), ex2, POST_SKIP_ERROR);
                }
            }
            catch (Exception ex3) {
                ConsoleJS.SERVER.error("Failed to parse recipe %s".formatted(recipeStr), ex3, POST_SKIP_ERROR);
            }
        }
    }

    private void infoSkip(String s) {
        if (DevProperties.get().logSkippedRecipes) {
            ConsoleJS.SERVER.info(s);
        } else {
            RecipeManager.LOGGER.debug(s);
        }
    }

    private void warnSkip(String s) {
        if (DevProperties.get().logSkippedRecipes) {
            ConsoleJS.SERVER.warn(s);
        } else {
            RecipeManager.LOGGER.warn(s);
        }
    }

    private void errorSkip(String s) {
        if (DevProperties.get().logSkippedRecipes) {
            ConsoleJS.SERVER.error(s);
        } else {
            RecipeManager.LOGGER.error(s);
        }
    }

    @HideFromJS
    public void postEvent() {
        Stopwatch timer = Stopwatch.createStarted();
        ServerEvents.RECIPES.post(ScriptType.SERVER, this);
        for (KubeRecipe r : this.originalRecipes.values()) {
            if (r.removed) {
                this.removedRecipes.add(r);
                continue;
            }
            if (!r.hasChanged()) continue;
            ++this.modifiedCount;
        }
        ConsoleJS.SERVER.info("Posted recipe events in " + TimeJS.msToString(timer.stop().elapsed(TimeUnit.MILLISECONDS)));
    }

    @HideFromJS
    public void applyChanges(Map<ResourceLocation, JsonElement> map) {
        Stopwatch timer = Stopwatch.createStarted();
        this.addedRecipes.removeIf(RECIPE_IS_SYNTHETIC);
        map.clear();
        map.putAll((Map<ResourceLocation, JsonElement>)this.originalRecipes.values().parallelStream().filter(RECIPE_NOT_REMOVED).map(KubeRecipe::serializeChanges).peek(this::addToExport).collect(Collectors.toConcurrentMap(KubeRecipe::getOrCreateId, recipe -> recipe.json, (a, b) -> b)));
        map.putAll((Map<ResourceLocation, JsonElement>)this.addedRecipes.parallelStream().filter(RECIPE_NOT_REMOVED).map(KubeRecipe::serializeChanges).peek(this::addToExport).collect(Collectors.toConcurrentMap(KubeRecipe::getOrCreateId, recipe -> recipe.json, (a, b) -> {
            ConsoleJS.SERVER.warn("KubeJS has found two recipes with the same ID in your custom recipes! Picking the last one encountered!");
            ConsoleJS.SERVER.warn("Recipe A JSON: " + String.valueOf(a));
            ConsoleJS.SERVER.warn("Recipe B JSON: " + String.valueOf(b));
            return b;
        })));
        ConsoleJS.SERVER.info("KubeJS modifications to recipe manager finished in %s".formatted(timer.stop()));
    }

    @HideFromJS
    public void finishEvent() {
        ChangesForChat.recipesAdded = this.addedRecipes.size();
        ChangesForChat.recipesModified = this.modifiedCount;
        ChangesForChat.recipesRemoved = this.removedRecipes.size();
        ChangesForChat.recipesMs = this.overallTimer.stop().elapsed(TimeUnit.MILLISECONDS);
        ConsoleJS.SERVER.info("Added %d recipes, removed %d recipes, modified %d recipes, with %d failed recipes taking %s in total".formatted(this.addedRecipes.size(), this.removedRecipes.size(), this.modifiedCount, this.failedCount, TimeJS.msToString(ChangesForChat.recipesMs)));
        if (DataExport.export != null) {
            for (KubeRecipe r : this.removedRecipes) {
                DataExport.export.addJson("removed_recipes/" + r.getId() + ".json", (JsonElement)r.json);
            }
        }
        if (DevProperties.get().logRecipeDebug) {
            ConsoleJS.SERVER.info("======== Debug output of all added recipes ========");
            for (KubeRecipe r : this.addedRecipes) {
                ConsoleJS.SERVER.info(String.valueOf(r.getOrCreateId()) + ": " + String.valueOf(r.json));
            }
            ConsoleJS.SERVER.info("======== Debug output of all modified recipes ========");
            for (KubeRecipe r : this.originalRecipes.values()) {
                if (r.removed || !r.hasChanged()) continue;
                ConsoleJS.SERVER.info(String.valueOf(r.getOrCreateId()) + ": " + String.valueOf(r.json) + " FROM " + String.valueOf(r.originalJson));
            }
            ConsoleJS.SERVER.info("======== Debug output of all removed recipes ========");
            for (KubeRecipe r : this.removedRecipes) {
                ConsoleJS.SERVER.info(String.valueOf(r.getOrCreateId()) + ": " + String.valueOf(r.json));
            }
        }
        RegexIDFilter.clearInternCache();
    }

    private void addToExport(KubeRecipe r) {
        String path = r.kjs$getMod() + "/" + r.getPath();
        if (DataExport.export != null) {
            DataExport.export.addJson("recipes/%s.json".formatted(path), (JsonElement)r.json);
            if (r.newRecipe) {
                DataExport.export.addJson("added_recipes/%s.json".formatted(path), (JsonElement)r.json);
            }
        }
    }

    @HideFromJS
    public void handleFailedRecipe(ResourceLocation id, JsonElement json, Throwable ex) {
        if (json.isJsonObject() && json.getAsJsonObject().has("_kubejs_changed_marker")) {
            json.getAsJsonObject().remove("_kubejs_changed_marker");
            if (DevProperties.get().logErroringRecipes) {
                ConsoleJS.SERVER.error("Error parsing recipe %s: %s".formatted(id, json), ex);
            }
            ++this.failedCount;
        }
    }

    public Map<String, Object> getRecipes() {
        return this.recipeFunctions;
    }

    public KubeRecipe addRecipe(KubeRecipe r, boolean json) {
        this.addedRecipes.add(r);
        if (DevProperties.get().logAddedRecipes) {
            ConsoleJS.SERVER.info("+ " + String.valueOf(r.kjs$getType()) + ": " + r.getFromToString() + (json ? " [json]" : ""));
        } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.debug("+ " + String.valueOf(r.kjs$getType()) + ": " + r.getFromToString() + (json ? " [json]" : ""));
        }
        return r;
    }

    public Stream<KubeRecipe> recipeStream(Context cx, RecipeFilter filter) {
        block5: {
            if (filter == ConstantFilter.FALSE) {
                return Stream.empty();
            }
            if (filter instanceof IDFilter) {
                IDFilter id = (IDFilter)filter;
                KubeRecipe r = this.originalRecipes.get(id.id);
                return r == null || r.removed ? Stream.empty() : Stream.of(r);
            }
            if (filter instanceof OrFilter) {
                OrFilter or = (OrFilter)filter;
                if (or.list.isEmpty()) {
                    return Stream.empty();
                }
                for (RecipeFilter recipeFilter : or.list) {
                    if (recipeFilter instanceof IDFilter) continue;
                    break block5;
                }
                return or.list.stream().map(idf -> this.originalRecipes.get(((IDFilter)idf).id)).filter(RECIPE_NOT_REMOVED);
            }
        }
        return this.originalRecipes.values().stream().filter(new RecipeStreamFilter(cx, filter));
    }

    private <T> T reduceRecipesAsync(Context cx, RecipeFilter filter, Function<Stream<KubeRecipe>, T> function) {
        return function.apply(this.recipeStream(cx, filter));
    }

    public void forEachRecipe(Context cx, RecipeFilter filter, Consumer<KubeRecipe> consumer) {
        if (filter instanceof IDFilter) {
            IDFilter id = (IDFilter)filter;
            KubeRecipe r = this.originalRecipes.get(id.id);
            if (r != null && !r.removed) {
                consumer.accept(r);
            }
        } else {
            this.recipeStream(cx, filter).forEach(consumer);
        }
    }

    public int countRecipes(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, s -> (int)s.count());
    }

    public boolean containsRecipe(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, s -> s.findAny().isPresent());
    }

    public Collection<KubeRecipe> findRecipes(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, Stream::toList);
    }

    public Collection<ResourceLocation> findRecipeIds(Context cx, RecipeFilter filter) {
        return this.reduceRecipesAsync(cx, filter, s -> s.map(KubeRecipe::getOrCreateId).toList());
    }

    public void remove(Context cx, RecipeFilter filter) {
        this.forEachRecipe(cx, filter, KubeRecipe::remove);
    }

    public void replaceInput(Context cx, RecipeFilter filter, ReplacementMatchInfo match, Object with) {
        String dstring = DevProperties.get().logModifiedRecipes || ConsoleJS.SERVER.shouldPrintDebug() ? ": IN " + String.valueOf(match) + " -> " + String.valueOf(with) : "";
        this.forEachRecipe(cx, filter, r -> {
            if (r.replaceInput(new RecipeScriptContext.Impl(cx, (KubeRecipe)r), match, with)) {
                if (DevProperties.get().logModifiedRecipes) {
                    ConsoleJS.SERVER.info("~ " + String.valueOf(r) + dstring);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + String.valueOf(r) + dstring);
                }
            }
        });
    }

    public void replaceOutput(Context cx, RecipeFilter filter, ReplacementMatchInfo match, Object with) {
        String dstring = DevProperties.get().logModifiedRecipes || ConsoleJS.SERVER.shouldPrintDebug() ? ": OUT " + String.valueOf(match) + " -> " + String.valueOf(with) : "";
        this.forEachRecipe(cx, filter, r -> {
            if (r.replaceOutput(new RecipeScriptContext.Impl(cx, (KubeRecipe)r), match, with)) {
                if (DevProperties.get().logModifiedRecipes) {
                    ConsoleJS.SERVER.info("~ " + String.valueOf(r) + dstring);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + String.valueOf(r) + dstring);
                }
            }
        });
    }

    public RecipeTypeFunction getRecipeFunction(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        Object object = this.recipeFunctions.get(ID.string(id));
        if (object instanceof RecipeTypeFunction) {
            RecipeTypeFunction fn = (RecipeTypeFunction)object;
            return fn;
        }
        return null;
    }

    public KubeRecipe custom(Context cx, JsonObject json) {
        return (KubeRecipe)this.parseJson(json, SourceLine.of(cx)).getPartialOrThrow(KubeRuntimeException::new);
    }

    @HideFromJS
    public DataResult<KubeRecipe> parseJson(JsonObject json, SourceLine sourceLine) {
        if (json == null || !json.has("type")) {
            return DataResult.error(() -> "JSON must contain 'type'!");
        }
        RecipeTypeFunction type = this.getRecipeFunction(json.get("type").getAsString());
        if (type == null) {
            return DataResult.error(() -> "Unknown recipe type: " + json.get("type").getAsString());
        }
        ErrorStack stack = new ErrorStack();
        try {
            KubeRecipe recipe = type.schemaType.schema.deserialize(sourceLine, type, null, json);
            recipe.afterLoaded(stack);
            return DataResult.success((Object)this.addRecipe(recipe, true));
        }
        catch (Throwable cause) {
            KubeRecipe recipe = type.schemaType.schema.recipeFactory.create(type, sourceLine, true);
            recipe.creationError = true;
            String errorString = "Failed to create custom recipe" + stack.atString() + " from json " + JsonUtils.toString((JsonElement)json);
            ConsoleJS.SERVER.error(errorString, sourceLine, cause, POST_SKIP_ERROR);
            recipe.json = json;
            recipe.newRecipe = true;
            return DataResult.error(() -> errorString, (Object)recipe);
        }
    }

    private void printTypes(Predicate<RecipeSchemaType> predicate, boolean all) {
        int t = 0;
        Reference2ObjectLinkedOpenHashMap map = new Reference2ObjectLinkedOpenHashMap();
        for (RecipeNamespace ns : this.recipeSchemaStorage.namespaces.values()) {
            for (RecipeSchemaType recipeSchemaType : ns.values()) {
                if (!predicate.test(recipeSchemaType)) continue;
                ++t;
                ((Set)map.computeIfAbsent((Object)recipeSchemaType.schema, s -> new LinkedHashSet())).add(recipeSchemaType.id);
            }
        }
        if (all) {
            ConsoleJS.SERVER.info("- All recipe types");
            ConsoleJS.SERVER.info("  - .id(id)");
            ConsoleJS.SERVER.info("  - .group(string)");
            ConsoleJS.SERVER.info("  - .set(key, value)");
            ConsoleJS.SERVER.info("  - .merge(json)");
            ConsoleJS.SERVER.info("- All crafting table recipe types");
            ConsoleJS.SERVER.info("  - .stage(string)");
            ConsoleJS.SERVER.info("  - .damageIngredient(filter, int?)");
            ConsoleJS.SERVER.info("  - .replaceIngredient(filter, item_stack)");
            ConsoleJS.SERVER.info("  - .customIngredientAction(filter, string)");
            ConsoleJS.SERVER.info("  - .keepIngredient(filter)");
            ConsoleJS.SERVER.info("  - .consumeIngredient(filter)");
            ConsoleJS.SERVER.info("  - .modifyResult(string)");
        }
        for (Map.Entry entry : map.entrySet()) {
            ConsoleJS.SERVER.info("- " + ((Set)entry.getValue()).stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
            for (RecipeConstructor recipeConstructor : ((RecipeSchema)entry.getKey()).constructors().values()) {
                ConsoleJS.SERVER.info("  - " + recipeConstructor.toString());
            }
            for (RecipeKey recipeKey : ((RecipeSchema)entry.getKey()).keys) {
                String name = recipeKey.getPrimaryFunctionName();
                if (!RecipeFunction.isValidIdentifier(name.toCharArray())) continue;
                ConsoleJS.SERVER.info("  - ." + name + "(" + String.valueOf(recipeKey.component) + ")");
            }
            for (RecipeFunctionInstance recipeFunctionInstance : ((RecipeSchema)entry.getKey()).functions.values()) {
                if (!RecipeFunction.isValidIdentifier(recipeFunctionInstance.name().toCharArray())) continue;
                ConsoleJS.SERVER.info("  - ." + String.valueOf(recipeFunctionInstance));
            }
        }
        ConsoleJS.SERVER.info(t + " types");
    }

    public void printTypes(Context cx) {
        ConsoleJS.SERVER.info("== All recipe types [used] ==");
        Set set = this.reduceRecipesAsync(cx, ConstantFilter.TRUE, s -> s.map(r -> r.type.id).collect(Collectors.toSet()));
        this.printTypes(t -> set.contains(t.id), false);
    }

    public void printAllTypes() {
        ConsoleJS.SERVER.info("== All recipe types [available] ==");
        this.printTypes(t -> BuiltInRegistries.RECIPE_SERIALIZER.get(t.id) != null, true);
    }

    public void printExamples(String type) {
        List list = this.originalRecipes.values().stream().filter(recipeJS -> recipeJS.type.toString().equals(type)).collect(Collectors.toList());
        Collections.shuffle(list);
        ConsoleJS.SERVER.info("== Random examples of '" + type + "' ==");
        for (int i = 0; i < Math.min(list.size(), 5); ++i) {
            KubeRecipe r = (KubeRecipe)list.get(i);
            ConsoleJS.SERVER.info("- " + String.valueOf(r.getOrCreateId()) + ":\n" + JsonIO.toPrettyString((JsonElement)r.json));
        }
    }

    public synchronized ResourceLocation takeId(KubeRecipe recipe, String prefix, String ids) {
        int i = 2;
        ResourceLocation id = ResourceLocation.parse((String)(prefix + ids));
        while (this.takenIds.containsKey(id)) {
            id = ResourceLocation.parse((String)(prefix + ids + "_" + i));
            ++i;
        }
        this.takenIds.put(id, recipe);
        return id;
    }

    public void stage(Context cx, RecipeFilter filter, String stage) {
        this.forEachRecipe(cx, filter, r -> r.stage(stage));
    }

    private /* synthetic */ void lambda$discoverRecipes$2(RecipeManagerKJS recipeManager, Map datapackRecipeMap, KubeJSPlugin p) {
        p.beforeRecipeLoading(this, recipeManager, datapackRecipeMap);
    }

    private record RecipeStreamFilter(Context cx, RecipeFilter filter) implements Predicate<KubeRecipe>
    {
        @Override
        public boolean test(KubeRecipe r) {
            return r != null && !r.removed && this.filter.test(new RecipeMatchContext.Impl(this.cx, r));
        }
    }
}

