/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.type.JSObjectTypeInfo;
import dev.latvian.mods.rhino.type.JSOptionalParam;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.RegistryOps;
import org.jetbrains.annotations.NotNull;

public class CustomObjectRecipeComponent
implements RecipeComponent<List<Value>> {
    public static final RecipeComponentType<?> TYPE = RecipeComponentType.dynamic(KubeJS.id("custom_object"), (type, ctx) -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Key.createCodec(ctx).listOf().fieldOf("keys").forGetter(CustomObjectRecipeComponent::keys)).apply((Applicative)instance, CustomObjectRecipeComponent::new)));
    private final List<Key> keys;
    public Predicate<Set<String>> hasPriority;
    private Codec<List<Value>> codec;
    private TypeInfo typeInfo;

    public CustomObjectRecipeComponent(List<Key> keys) {
        this.keys = List.copyOf(keys);
    }

    @Override
    public RecipeComponentType<?> type() {
        return TYPE;
    }

    public List<Key> keys() {
        return this.keys;
    }

    public CustomObjectRecipeComponent hasPriority(Predicate<Set<String>> hasPriority) {
        this.hasPriority = hasPriority;
        return this;
    }

    public CustomObjectRecipeComponent createCopy() {
        CustomObjectRecipeComponent copy = new CustomObjectRecipeComponent(this.keys);
        copy.hasPriority = this.hasPriority;
        return copy;
    }

    @Override
    public List<Value> wrap(RecipeScriptContext cx, Object from) {
        List list = cx.cx().optionalListOf(from, TypeInfo.of(Value.class));
        if (list != null) {
            return (List)Cast.to(list);
        }
        if (cx.cx().isMapLike(from)) {
            RegistryOps<Object> ops = cx.ops().java();
            MapLike mapLike = MapLike.forMap((Map)((Map)Cast.to(cx.cx().optionalMapOf(from))), ops);
            return (List)this.mapCodec().decode(ops, mapLike).getOrThrow();
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(from));
    }

    public MapCodec<List<Value>> mapCodec() {
        return new MapCodec<List<Value>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return CustomObjectRecipeComponent.this.keys.stream().map(Key::name).map(arg_0 -> ops.createString(arg_0));
            }

            public <T> DataResult<List<Value>> decode(DynamicOps<T> ops, MapLike<T> input) {
                ArrayList list = new ArrayList(CustomObjectRecipeComponent.this.keys.size());
                HashMap keyMap = new HashMap();
                CustomObjectRecipeComponent.this.keys.forEach(key -> keyMap.put(key.name, key));
                Stream.Builder failed = Stream.builder();
                DataResult result = input.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, pair) -> {
                    DataResult keyResult = ops.getStringValue(pair.getFirst()).flatMap(k -> {
                        if (keyMap.containsKey(k)) {
                            return DataResult.success((Object)((Key)keyMap.get(k)));
                        }
                        return DataResult.error(() -> "Unknown key in custom object: " + k);
                    });
                    DataResult valueResult = keyResult.map(k -> k.component.codec()).flatMap(codec -> codec.decode(ops, pair.getSecond())).map(Pair::getFirst);
                    DataResult entryResult = keyResult.apply2stable((k, v) -> new Value((Key)k, CustomObjectRecipeComponent.this.keys.indexOf(k), v), valueResult);
                    entryResult.resultOrPartial().ifPresent(list::add);
                    if (entryResult.isError()) {
                        failed.add(pair);
                    }
                    return r.apply2stable((u, p) -> u, entryResult);
                }, (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
                if (list.size() >= 2) {
                    list.sort(null);
                }
                Object errors = ops.createMap(failed.build());
                return result.map(unit -> list).setPartial(list).mapError(e -> e + " missed input: " + String.valueOf(errors));
            }

            public <T> RecordBuilder<T> encode(List<Value> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                RecordBuilder builder = ops.mapBuilder();
                for (Value entry : input) {
                    builder.add(ops.createString(entry.key.name), entry.key.component.codec().encodeStart(ops, Cast.to(entry.value)));
                }
                return builder;
            }
        };
    }

    @Override
    public Codec<List<Value>> codec() {
        if (this.codec == null) {
            this.codec = this.mapCodec().codec();
        }
        return this.codec;
    }

    @Override
    public TypeInfo typeInfo() {
        if (this.typeInfo == null) {
            ArrayList<JSOptionalParam> list = new ArrayList<JSOptionalParam>(this.keys.size());
            for (Key key : this.keys) {
                list.add(new JSOptionalParam(key.name, key.component.typeInfo(), key.optional()));
            }
            this.typeInfo = new JSObjectTypeInfo(list);
        }
        return this.typeInfo;
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        if (from instanceof Map) {
            Map m = (Map)from;
            if (this.hasPriority != null) {
                return this.hasPriority.test(m.keySet());
            }
            for (Key key : this.keys) {
                if (key.optional() || m.containsKey(key.name)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            if (this.hasPriority != null) {
                return this.hasPriority.test(json.keySet());
            }
            for (Key key : this.keys) {
                if (key.optional() || json.has(key.name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(RecipeMatchContext cx, List<Value> value, ReplacementMatchInfo match) {
        for (Value e : value) {
            if (!e.key.component.matches(cx, Cast.to(e.value), match)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Value> replace(RecipeScriptContext cx, List<Value> original, ReplacementMatchInfo match, Object with) {
        List<Value> replaced = original;
        for (Value e : original) {
            Object r = e.key.component.replace(cx, Cast.to(e.value), match, with);
            if (r == e.value) continue;
            if (replaced == original) {
                replaced = new ArrayList<Value>(original);
            }
            replaced.set(e.index, new Value(e.key, e.index, r));
        }
        return replaced;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, List<Value> list) {
        boolean first = true;
        for (Value value : list) {
            if (value.value == null) continue;
            if (first) {
                first = false;
            } else {
                builder.appendSeparator();
            }
            value.key.component.buildUniqueId(builder, Cast.to(value.value));
        }
    }

    @Override
    public void validate(RecipeValidationContext ctx, List<Value> value) {
        RecipeComponent.super.validate(ctx, value);
        ctx.errors().push(this);
        for (Value entry : value) {
            ctx.errors().setKey(entry.key.name);
            entry.key.component.validate(ctx, Cast.to(entry.value));
        }
        ctx.errors().pop();
    }

    @Override
    public boolean isEmpty(List<Value> value) {
        return this.keys.isEmpty();
    }

    public String toString() {
        return this.keys.stream().map(Key::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    public record Value(Key key, int index, Object value) implements Map.Entry<Key, Object>,
    Comparable<Value>
    {
        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(@NotNull Value value) {
            return Integer.compare(this.index, value.index);
        }
    }

    public record Key(String name, RecipeComponent<?> component, boolean optional, boolean alwaysWrite) {
        public Key(String name, RecipeComponent<?> component, boolean optional) {
            this(name, component, optional, false);
        }

        public Key(String name, RecipeComponent<?> component) {
            this(name, component, false);
        }

        public static Codec<Key> createCodec(RecipeTypeRegistryContext ctx) {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Key::name), (App)ctx.recipeComponentCodec().fieldOf("component").forGetter(Key::component), (App)Codec.BOOL.optionalFieldOf("optional", (Object)false).forGetter(Key::optional), (App)Codec.BOOL.optionalFieldOf("always_write", (Object)false).forGetter(Key::alwaysWrite)).apply((Applicative)instance, Key::new));
        }

        @Override
        public String toString() {
            return this.name + (this.optional ? "?" : "") + (this.alwaysWrite ? "!" : "") + ": " + String.valueOf(this.component);
        }
    }
}

