/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KubeFileResourcePack
implements PackResources {
    public static final PackLocationInfo PACK_LOCATION_INFO = new PackLocationInfo("kubejs", (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty());
    private final PackType packType;
    private Map<ResourceLocation, GeneratedData> generated;
    private Set<String> generatedNamespaces;

    private static Stream<Path> tryWalk(Path path) {
        try {
            return Files.walk(path, new FileVisitOption[0]);
        }
        catch (Exception exception) {
            return Stream.empty();
        }
    }

    public static void scanForInvalidFiles(String pathName, Path path) throws IOException {
        long start = System.currentTimeMillis();
        int files = 0;
        block2: for (Path p : Files.list(path).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(KubeFileResourcePack::tryWalk).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).toList()) {
            ++files;
            try {
                char[] chars;
                String fileName = p.getFileName().toString();
                String fileNameLC = fileName.toLowerCase(Locale.ROOT);
                if (fileNameLC.endsWith(".zip") || fileNameLC.equals(".ds_store") || fileNameLC.equals("thumbs.db") || fileNameLC.equals("desktop.ini")) continue;
                if (Files.isHidden(path)) {
                    ConsoleJS.STARTUP.error("Invisible file found: " + pathName + path.relativize(p).toString().replace('\\', '/')).withExternalFile(p);
                    continue;
                }
                for (char c : chars = fileName.toCharArray()) {
                    if (c >= 'A' && c <= 'Z') {
                        ConsoleJS.STARTUP.error("Invalid file name: Uppercase '" + c + "' in " + pathName + path.relativize(p).toString().replace('\\', '/')).withExternalFile(p);
                        continue block2;
                    }
                    if (c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '/' || c == '.') continue;
                    ConsoleJS.STARTUP.error("Invalid file name: Invalid character '" + c + "' in " + pathName + path.relativize(p).toString().replace('\\', '/')).withExternalFile(p);
                    continue block2;
                }
            }
            catch (Exception ex) {
                ConsoleJS.STARTUP.error("Invalid file name: " + pathName + path.relativize(p).toString().replace('\\', '/'), ex).withExternalFile(p);
            }
        }
        ConsoleJS.STARTUP.info("Validated " + files + " files in " + pathName + " in " + (System.currentTimeMillis() - start) + "ms");
    }

    public static int findBeforeModsIndex(List<PackResources> packs) {
        for (int i = 0; i < packs.size(); ++i) {
            PackResources pack = packs.get(i);
            if (!(pack instanceof VanillaPackResources)) continue;
            return i + 1;
        }
        return 1;
    }

    public static int findAfterModsIndex(List<PackResources> packs) {
        for (int i = packs.size() - 1; i >= 0; --i) {
            PackResources pack = packs.get(i);
            if (!(pack instanceof FilePackResources)) continue;
            return i + 1;
        }
        return packs.size();
    }

    public static void scanAndLoad(Path path, List<PackResources> packs) {
        for (File file : Objects.requireNonNull(path.toFile().listFiles())) {
            String fileName = file.getName();
            if (!file.isFile() || !fileName.endsWith(".zip")) continue;
            StringBuilder packName = new StringBuilder();
            for (char c : fileName.toCharArray()) {
                if (!(c == '_' || c == '.' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') && (c < 'A' || c > 'Z')) continue;
                packName.append(c);
            }
            long lastModified = 0L;
            if (file.exists()) {
                lastModified = file.lastModified();
            }
            packs.add((PackResources)new FilePackResources(new PackLocationInfo(fileName, (Component)Component.literal((String)fileName), PackSource.BUILT_IN, Optional.of(new KnownPack("kubejs", "kubejs_file_" + packName.toString().toLowerCase(Locale.ROOT), lastModified <= 0L ? "1" : Long.toUnsignedString(lastModified)))), new FilePackResources.SharedZipFileAccess(file), ""));
        }
    }

    public KubeFileResourcePack(PackType t) {
        this.packType = t;
    }

    @Nullable
    public GeneratedData getRootResource(String ... path) {
        return switch (path.length == 1 ? path[0] : "") {
            case "pack.mcmeta" -> GeneratedData.PACK_META;
            case "pack.png" -> GeneratedData.PACK_ICON;
            default -> null;
        };
    }

    public Map<ResourceLocation, GeneratedData> getGenerated() {
        if (this.generated == null) {
            this.generated = new HashMap<ResourceLocation, GeneratedData>();
            this.generate(this.generated);
            boolean debug = DevProperties.get().logGeneratedData;
            try {
                Path root = KubeJSPaths.get(this.packType);
                for (Path dir : Files.list(root).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList()) {
                    String ns = dir.getFileName().toString();
                    if (debug) {
                        KubeJS.LOGGER.info("# Walking namespace '" + ns + "'");
                    }
                    for (Path path : Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).toList()) {
                        String pathStr = dir.relativize(path).toString().replace('\\', '/').toLowerCase(Locale.ROOT);
                        int sindex = pathStr.lastIndexOf(47);
                        String fileNameLC = sindex == -1 ? pathStr : pathStr.substring(sindex + 1);
                        if (fileNameLC.endsWith(".zip") || fileNameLC.equals(".ds_store") || fileNameLC.equals("thumbs.db") || fileNameLC.equals("desktop.ini") || Files.isHidden(path)) continue;
                        GeneratedData data = new GeneratedData(ResourceLocation.fromNamespaceAndPath((String)ns, (String)pathStr), () -> {
                            try {
                                return Files.readAllBytes(path);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                return new byte[0];
                            }
                        });
                        if (debug) {
                            KubeJS.LOGGER.info("- File found: '" + String.valueOf(data.id()) + "' (" + data.data().get().length + " bytes)");
                        }
                        if (this.skipFile(data)) {
                            if (!debug) continue;
                            KubeJS.LOGGER.info("- Skipping '" + String.valueOf(data.id()) + "'");
                            continue;
                        }
                        this.generated.put(data.id(), data);
                    }
                }
            }
            catch (Exception ex) {
                KubeJS.LOGGER.error("Failed to load files from kubejs/" + this.packType.getDirectory(), (Throwable)ex);
            }
            this.generated.put(GeneratedData.INTERNAL_RELOAD.id(), GeneratedData.INTERNAL_RELOAD);
            this.generated = Map.copyOf(this.generated);
            if (debug) {
                KubeJS.LOGGER.info("Generated " + String.valueOf(this.packType) + " data (" + this.generated.size() + " files)");
            }
        }
        return this.generated;
    }

    protected boolean skipFile(GeneratedData data) {
        if (this.packType == PackType.CLIENT_RESOURCES) {
            return data.id().getPath().startsWith("lang/");
        }
        return false;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        GeneratedData r;
        GeneratedData generatedData = r = type == this.packType ? this.getGenerated().get(location) : null;
        if (r == GeneratedData.INTERNAL_RELOAD) {
            this.close();
        }
        return r;
    }

    public void generate(Map<ResourceLocation, GeneratedData> map) {
    }

    public void listResources(PackType type, String namespace, String path, PackResources.ResourceOutput visitor) {
        if (type == this.packType) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            for (Map.Entry<ResourceLocation, GeneratedData> r : this.getGenerated().entrySet()) {
                if (!r.getKey().getNamespace().equals(namespace) || !r.getKey().getPath().startsWith((String)path)) continue;
                visitor.accept((Object)r.getKey(), (Object)r.getValue());
            }
        }
    }

    @NotNull
    public Set<String> getNamespaces(PackType type) {
        if (type == this.packType) {
            if (this.generatedNamespaces == null) {
                this.generatedNamespaces = new HashSet<String>();
                for (Map.Entry<ResourceLocation, GeneratedData> s : this.getGenerated().entrySet()) {
                    this.generatedNamespaces.add(s.getKey().getNamespace());
                }
            }
            return this.generatedNamespaces;
        }
        return Collections.emptySet();
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) throws IOException {
        GeneratedData inputSupplier = this.getRootResource("pack.mcmeta");
        if (inputSupplier != null) {
            try (InputStream input = inputSupplier.get();){
                Object object = AbstractPackResources.getMetadataFromStream(serializer, (InputStream)input);
                return (T)object;
            }
        }
        return null;
    }

    @NotNull
    public String packId() {
        return "KubeJS File Resource Pack [" + this.packType.getDirectory() + "]";
    }

    public void close() {
        this.generated = null;
        this.generatedNamespaces = null;
    }

    public PackLocationInfo location() {
        return PACK_LOCATION_INFO;
    }

    public String toString() {
        return this.packId();
    }
}

