/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.generator.KubeResourceGenerator;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.TextIcons;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.script.data.GeneratedData;
import dev.latvian.mods.kubejs.script.data.GeneratedDataStage;
import dev.latvian.mods.kubejs.script.data.KubeFileResourcePack;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualResourcePack
extends AbstractPackResources
implements KubeResourceGenerator,
ExportablePackResources {
    public final ScriptType scriptType;
    public final PackType packType;
    public final GeneratedDataStage stage;
    public final Supplier<RegistryAccessContainer> registries;
    public final String info;
    public final Component component;
    private final Map<ResourceLocation, GeneratedData> locationToData;
    private final Map<String, GeneratedData> pathToData;
    private final Set<String> namespaces;
    private final Map<DataMapType<?, ?>, Map<ResourceLocation, Object>> dataMaps;

    public VirtualResourcePack(ScriptType scriptType, PackType packType, GeneratedDataStage stage, Supplier<RegistryAccessContainer> registries) {
        super(KubeFileResourcePack.PACK_LOCATION_INFO);
        this.scriptType = scriptType;
        this.packType = packType;
        this.stage = stage;
        this.registries = registries;
        this.info = stage.displayName + ", " + packType.getDirectory();
        this.component = Component.empty().append(TextIcons.NAME).append(" (" + this.info + ", )");
        this.locationToData = new HashMap<ResourceLocation, GeneratedData>();
        this.pathToData = new HashMap<String, GeneratedData>();
        this.namespaces = new HashSet<String>();
        this.dataMaps = new HashMap();
    }

    public void reset() {
        this.locationToData.clear();
        this.pathToData.clear();
        this.namespaces.clear();
        this.dataMaps.clear();
    }

    @Override
    public RegistryAccessContainer getRegistries() {
        return this.registries.get();
    }

    @Override
    public void add(GeneratedData data) {
        this.locationToData.put(data.id(), data);
        this.pathToData.put(this.packType.getDirectory() + "/" + data.id().getNamespace() + "/" + data.id().getPath(), data);
        this.namespaces.add(data.id().getNamespace());
        if (DevProperties.get().virtualPackOutput) {
            this.scriptType.console.info("Registered virtual file [" + this.info + "] '" + String.valueOf(data.id()) + "': " + String.valueOf(data));
        }
    }

    @Override
    public <R, T> void dataMap(DataMapType<R, T> type, Consumer<BiConsumer<ResourceLocation, T>> consumer) {
        Map map = this.dataMaps.computeIfAbsent(type, k -> new HashMap());
        consumer.accept(map::put);
    }

    @Override
    public void flush() {
        RegistryOps<JsonElement> jsonOps = this.getRegistries().json();
        for (Map.Entry<DataMapType<?, ?>, Map<ResourceLocation, Object>> typeEntry : this.dataMaps.entrySet()) {
            DataMapType<?, ?> type = typeEntry.getKey();
            JsonObject json = new JsonObject();
            JsonObject valuesJson = new JsonObject();
            for (Map.Entry<ResourceLocation, Object> entry : typeEntry.getValue().entrySet()) {
                Object data = entry.getValue();
                DataResult result = type.codec().encodeStart(jsonOps, Cast.to(data));
                if (result.isSuccess()) {
                    valuesJson.add(entry.getKey().toString(), (JsonElement)result.getOrThrow());
                    continue;
                }
                throw new RuntimeException("Failed to encode data for " + String.valueOf(type.registryKey().location()) + " / " + String.valueOf(type.id()) + " / " + String.valueOf(entry.getKey()) + ": " + ((DataResult.Error)result.error().get()).message());
            }
            json.add("values", (JsonElement)valuesJson);
            this.add(GeneratedData.json(type.id().withPath("data_maps/" + ID.resourcePath(type.registryKey().location()) + "/" + type.id().getPath() + ".json"), () -> json));
        }
        this.dataMaps.clear();
    }

    @Override
    @Nullable
    public GeneratedData getGenerated(ResourceLocation id) {
        return this.locationToData.get(id);
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... path) {
        return switch (path.length == 1 ? path[0] : "") {
            case "pack.mcmeta" -> GeneratedData.PACK_META;
            case "pack.png" -> GeneratedData.PACK_ICON;
            default -> null;
        };
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        if (type != this.packType) {
            return null;
        }
        GeneratedData s = this.locationToData.get(location);
        if (s != null) {
            if (DevProperties.get().virtualPackOutput) {
                this.scriptType.console.info("Served virtual file [" + this.info + "] '" + String.valueOf(location) + "': " + String.valueOf(s));
            }
            return s;
        }
        return null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput visitor) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        for (ResourceLocation r : this.locationToData.keySet()) {
            if (!r.getNamespace().equals(namespace) || !r.getPath().startsWith((String)path)) continue;
            visitor.accept((Object)r, this.getResource(packType, r));
        }
    }

    public Set<String> getNamespaces(PackType type) {
        return Set.copyOf(this.namespaces);
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) {
        return null;
    }

    public String toString() {
        return this.packId();
    }

    @NotNull
    public String packId() {
        return "KubeJS Virtual Resource Pack [" + this.info + "]";
    }

    @Override
    public String exportPath() {
        return this.packType.getDirectory() + "/" + this.stage.name;
    }

    @Override
    public void export(Path root) throws IOException {
        for (Map.Entry<String, GeneratedData> file : this.pathToData.entrySet()) {
            Path path = root.resolve(file.getKey());
            Path parent = path.getParent();
            if (Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(path, file.getValue().data().get(), new OpenOption[0]);
        }
    }

    public void close() {
        if (!FMLLoader.isProduction()) {
            KubeJS.LOGGER.info("Closed " + this.packId());
        }
    }
}

