/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.core.RegistryObjectKJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.UnaryOperator;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface ID {
    public static final ResourceLocation UNKNOWN = ResourceLocation.fromNamespaceAndPath((String)"unknown", (String)"unknown");
    public static final ResourceLocation AIR = ResourceLocation.withDefaultNamespace((String)"air");
    public static final UnaryOperator<String> BLOCKSTATE = s -> "blockstates/" + s;
    public static final UnaryOperator<String> BLOCK = s -> "block/" + s;
    public static final UnaryOperator<String> ITEM = s -> "item/" + s;
    public static final UnaryOperator<String> MODEL = s -> "models/" + s;
    public static final UnaryOperator<String> BLOCK_MODEL = s -> "models/block/" + s;
    public static final UnaryOperator<String> ITEM_MODEL = s -> "models/item/" + s;
    public static final UnaryOperator<String> BLOCK_LOOT_TABLE = s -> "loot_table/blocks/" + s;
    public static final UnaryOperator<String> PNG_TEXTURE = s -> "textures/" + s + ".png";
    public static final UnaryOperator<String> PNG_TEXTURE_MCMETA = s -> "textures/" + s + ".png.mcmeta";
    public static final UnaryOperator<String> PARTICLE = s -> "particles/" + s;

    public static String string(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return "";
        }
        if (id.indexOf(58) == -1) {
            return "minecraft:" + id;
        }
        return id;
    }

    public static String kjsString(String id) {
        if (id == null || id.isEmpty()) {
            return "";
        }
        if (id.indexOf(58) == -1) {
            return "kubejs:" + id;
        }
        return id;
    }

    public static String namespace(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft";
        }
        int i = s.indexOf(58);
        return i == -1 ? "minecraft" : s.substring(0, i);
    }

    public static String path(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "air";
        }
        int i = s.indexOf(58);
        return i == -1 ? s : s.substring(i + 1);
    }

    public static ResourceLocation of(@Nullable Object o, boolean preferKJS) {
        ResourceLocation resourceLocation;
        Object object = o;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ResourceLocation.class, ResourceKey.class, Holder.class, RegistryObjectKJS.class}, (Object)object, n)) {
            case -1: {
                ResourceLocation resourceLocation2;
                resourceLocation = resourceLocation2 = null;
                break;
            }
            case 0: {
                ResourceLocation id;
                ResourceLocation resourceLocation3;
                resourceLocation = resourceLocation3 = (id = (ResourceLocation)object);
                break;
            }
            case 1: {
                ResourceLocation resourceLocation4;
                ResourceKey key = (ResourceKey)object;
                resourceLocation = resourceLocation4 = key.location();
                break;
            }
            case 2: {
                ResourceLocation resourceLocation5;
                Holder holder = (Holder)object;
                resourceLocation = resourceLocation5 = holder.getKey().location();
                break;
            }
            case 3: {
                ResourceLocation resourceLocation6;
                RegistryObjectKJS key = (RegistryObjectKJS)object;
                resourceLocation = resourceLocation6 = key.kjs$getIdLocation();
                break;
            }
            default: {
                Object s;
                if (o instanceof JsonPrimitive) {
                    JsonPrimitive p = (JsonPrimitive)o;
                    v1 = p.getAsString();
                } else {
                    v1 = s = o.toString();
                }
                if (((String)s).indexOf(58) == -1 && preferKJS) {
                    s = "kubejs:" + (String)s;
                }
                try {
                    ResourceLocation resourceLocation7;
                    resourceLocation = resourceLocation7 = ResourceLocation.parse((String)s);
                    break;
                }
                catch (ResourceLocationException ex) {
                    throw new KubeRuntimeException("Could not create ID from '%s'!".formatted(s));
                }
            }
        }
        return resourceLocation;
    }

    public static ResourceLocation mc(@Nullable Object o) {
        return ID.of(o, false);
    }

    public static ResourceLocation kjs(@Nullable Object o) {
        return ID.of(o, true);
    }

    public static boolean isKey(Object from) {
        return from instanceof CharSequence || from instanceof ResourceLocation || from instanceof ResourceKey;
    }

    public static String url(ResourceLocation id) {
        return URLEncoder.encode(id.getNamespace(), StandardCharsets.UTF_8) + "/" + URLEncoder.encode(id.getPath(), StandardCharsets.UTF_8);
    }

    public static String reduce(ResourceLocation id) {
        return id.getNamespace().equals("minecraft") ? id.getPath() : id.toString();
    }

    public static String reduceKjs(ResourceLocation id) {
        return id.getNamespace().equals("kubejs") ? id.getPath() : id.toString();
    }

    public static String resourcePath(ResourceLocation id) {
        return id.getNamespace().equals("minecraft") ? id.getPath() : id.getNamespace() + "/" + id.getPath();
    }
}

