/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class JsonIO {
    @Nullable
    public static Object toObject(@Nullable JsonElement json) {
        return JsonUtils.toObject(json);
    }

    public static String toString(JsonElement json) {
        return JsonUtils.toString(json);
    }

    public static String toPrettyString(JsonElement json) {
        return JsonUtils.toPrettyString(json);
    }

    public static JsonElement parseRaw(@Nullable String string) {
        return JsonUtils.fromString(string);
    }

    public static Object parse(String string) {
        return UtilsJS.wrap(JsonIO.parseRaw(string), JSObjectType.ANY);
    }

    @Nullable
    public static Object toPrimitive(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive p = element.getAsJsonPrimitive();
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                return p.getAsNumber();
            }
            try {
                Double.parseDouble(p.getAsString());
                return p.getAsNumber();
            }
            catch (Exception ex) {
                return p.getAsString();
            }
        }
        return null;
    }

    @Nullable
    public static JsonElement readJson(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader fileReader = Files.newBufferedReader(path);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)fileReader);
            return jsonElement;
        }
    }

    public static String readString(Path path) throws IOException {
        return JsonIO.toString(JsonIO.readJson(path));
    }

    @Nullable
    public static Map<?, ?> read(Context cx, Path path) throws IOException {
        return cx.optionalMapOf((Object)JsonIO.readJson(path));
    }

    public static void write(Path path, @Nullable JsonElement json) throws IOException {
        if (json == null || json.isJsonNull()) {
            Files.deleteIfExists(path);
        } else {
            Files.writeString(path, (CharSequence)JsonUtils.toPrettyString(json), new OpenOption[0]);
        }
    }

    public static JsonArray toArray(JsonElement element) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        JsonArray a = new JsonArray();
        a.add(element);
        return a;
    }

    public static void writeJsonHash(DataOutputStream stream, @Nullable JsonElement element) throws IOException {
        if (element == null || element.isJsonNull()) {
            stream.writeByte(45);
        } else if (element instanceof JsonArray) {
            JsonArray arr = (JsonArray)element;
            stream.writeByte(91);
            for (JsonElement e : arr) {
                JsonIO.writeJsonHash(stream, e);
            }
        } else if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            stream.writeByte(123);
            for (Map.Entry e : obj.entrySet()) {
                stream.writeBytes((String)e.getKey());
                JsonIO.writeJsonHash(stream, (JsonElement)e.getValue());
            }
        } else if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            stream.writeByte(61);
            if (primitive.isBoolean()) {
                stream.writeBoolean(element.getAsBoolean());
            } else if (primitive.isNumber()) {
                stream.writeDouble(element.getAsDouble());
            } else {
                stream.writeBytes(element.getAsString());
            }
        } else {
            stream.writeByte(63);
            stream.writeInt(element.hashCode());
        }
    }

    public static byte[] getJsonHashBytes(JsonElement json) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonIO.writeJsonHash(new DataOutputStream(baos), json);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            int h = json.hashCode();
            return new byte[]{(byte)(h >> 24), (byte)(h >> 16), (byte)(h >> 8), (byte)h};
        }
        return baos.toByteArray();
    }

    public static String getJsonHashString(JsonElement json) {
        try {
            MessageDigest messageDigest = Objects.requireNonNull(MessageDigest.getInstance("MD5"));
            return new BigInteger(HexFormat.of().formatHex(messageDigest.digest(JsonIO.getJsonHashBytes(json))), 16).toString(36);
        }
        catch (Exception ex) {
            return "%08x".formatted(json.hashCode());
        }
    }
}

