/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.util.OrderedCompoundTag;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public interface NBTUtils {
    public static final TagType<OrderedCompoundTag> COMPOUND_TYPE = new TagType.VariableSize<OrderedCompoundTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OrderedCompoundTag load(DataInput dataInput, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                byte typeId;
                accounter.accountBytes(48L);
                LinkedHashMap<String, Tag> map = new LinkedHashMap<String, Tag>();
                while ((typeId = dataInput.readByte()) != 0) {
                    TagType<?> valueType;
                    Tag tag;
                    String key = 1.readString(dataInput, accounter);
                    if (map.put(key, tag = CompoundTag.readNamedTagData(valueType = NBTUtils.convertType(TagTypes.getType((int)typeId)), (String)key, (DataInput)dataInput, (NbtAccounter)accounter)) != null) continue;
                    accounter.accountBytes(36L);
                }
                OrderedCompoundTag orderedCompoundTag = new OrderedCompoundTag(map);
                return orderedCompoundTag;
            }
            finally {
                accounter.popDepth();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StreamTagVisitor.ValueResult parse(DataInput dataInput, StreamTagVisitor visitor, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                byte typeId;
                accounter.accountBytes(48L);
                block19: while ((typeId = dataInput.readByte()) != 0) {
                    TagType<?> valueType = NBTUtils.convertType(TagTypes.getType((int)typeId));
                    switch (visitor.visitEntry(valueType)) {
                        case HALT: {
                            StreamTagVisitor.ValueResult valueResult = StreamTagVisitor.ValueResult.HALT;
                            return valueResult;
                        }
                        case BREAK: {
                            StringTag.skipString((DataInput)dataInput);
                            valueType.skip(dataInput, accounter);
                            break block19;
                        }
                        case SKIP: {
                            StringTag.skipString((DataInput)dataInput);
                            valueType.skip(dataInput, accounter);
                            continue block19;
                        }
                        default: {
                            String key = 1.readString(dataInput, accounter);
                            switch (visitor.visitEntry(valueType, key)) {
                                case HALT: {
                                    StreamTagVisitor.ValueResult valueResult = StreamTagVisitor.ValueResult.HALT;
                                    return valueResult;
                                }
                                case BREAK: {
                                    valueType.skip(dataInput, accounter);
                                    break block19;
                                }
                                case SKIP: {
                                    valueType.skip(dataInput, accounter);
                                    continue block19;
                                }
                            }
                            accounter.accountBytes(36L);
                            switch (valueType.parse(dataInput, visitor, accounter)) {
                                case HALT: {
                                    StreamTagVisitor.ValueResult valueResult = StreamTagVisitor.ValueResult.HALT;
                                    return valueResult;
                                }
                            }
                            continue block19;
                        }
                    }
                }
                if (typeId != 0) {
                    while ((typeId = dataInput.readByte()) != 0) {
                        StringTag.skipString((DataInput)dataInput);
                        NBTUtils.convertType(TagTypes.getType((int)typeId)).skip(dataInput, accounter);
                    }
                }
                StreamTagVisitor.ValueResult valueResult = visitor.visitContainerEnd();
                return valueResult;
            }
            finally {
                accounter.popDepth();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void skip(DataInput dataInput, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                byte typeId;
                while ((typeId = dataInput.readByte()) != 0) {
                    StringTag.skipString((DataInput)dataInput);
                    NBTUtils.convertType(TagTypes.getType((int)typeId)).skip(dataInput, accounter);
                }
            }
            finally {
                accounter.popDepth();
            }
        }

        public String getName() {
            return "COMPOUND";
        }

        public String getPrettyName() {
            return "TAG_Compound";
        }

        private static String readString(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            String string = dataInput.readUTF();
            nbtAccounter.accountBytes(28L);
            nbtAccounter.accountBytes(2L, (long)string.length());
            return string;
        }
    };
    public static final TagType<ListTag> LIST_TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListTag load(DataInput dataInput, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                accounter.accountBytes(37L);
                byte typeId = dataInput.readByte();
                int size = dataInput.readInt();
                if (typeId == 0 && size > 0) {
                    throw new NbtFormatException("Missing type on ListTag");
                }
                accounter.accountBytes(4L, (long)size);
                TagType<?> valueType = NBTUtils.convertType(TagTypes.getType((int)typeId));
                ArrayList list = Lists.newArrayListWithCapacity((int)size);
                for (int j = 0; j < size; ++j) {
                    list.add(valueType.load(dataInput, accounter));
                }
                ListTag listTag = new ListTag((List)list, typeId);
                return listTag;
            }
            finally {
                accounter.popDepth();
            }
        }

        /*
         * Exception decompiling
         */
        public StreamTagVisitor.ValueResult parse(DataInput dataInput, StreamTagVisitor visitor, NbtAccounter accounter) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[SWITCH], 13[CASE]], but top level block is 14[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void skip(DataInput dataInput, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                TagType<?> tagType = NBTUtils.convertType(TagTypes.getType((int)dataInput.readByte()));
                int i = dataInput.readInt();
                tagType.skip(dataInput, i, accounter);
            }
            finally {
                accounter.popDepth();
            }
        }

        public String getName() {
            return "LIST";
        }

        public String getPrettyName() {
            return "TAG_List";
        }
    };

    public static void quoteAndEscape(StringBuilder stringBuilder, String string) {
        int start = stringBuilder.length();
        stringBuilder.append(' ');
        int c = 0;
        for (int i = 0; i < string.length(); ++i) {
            int d = string.charAt(i);
            if (d == 92) {
                stringBuilder.append('\\');
            } else if (d == 34 || d == 39) {
                if (c == 0) {
                    int n = c = d == 39 ? 34 : 39;
                }
                if (c == d) {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append((char)d);
        }
        if (c == 0) {
            c = 39;
        }
        stringBuilder.setCharAt(start, (char)c);
        stringBuilder.append((char)c);
    }

    public static TagType<?> convertType(TagType<?> tagType) {
        return tagType == CompoundTag.TYPE ? COMPOUND_TYPE : (tagType == ListTag.TYPE ? LIST_TYPE : tagType);
    }

    public static JsonElement toJson(@Nullable Tag t) {
        if (t == null || t instanceof EndTag) {
            return JsonNull.INSTANCE;
        }
        if (t instanceof StringTag) {
            return new JsonPrimitive(t.getAsString());
        }
        if (t instanceof NumericTag) {
            return new JsonPrimitive(((NumericTag)t).getAsNumber());
        }
        if (t instanceof CollectionTag) {
            CollectionTag l = (CollectionTag)t;
            JsonArray array = new JsonArray();
            for (Tag tag : l) {
                array.add(NBTUtils.toJson(tag));
            }
            return array;
        }
        if (t instanceof CompoundTag) {
            CompoundTag c = (CompoundTag)t;
            JsonObject object = new JsonObject();
            for (String key : c.getAllKeys()) {
                object.add(key, NBTUtils.toJson(c.get(key)));
            }
            return object;
        }
        return JsonNull.INSTANCE;
    }

    @Nullable
    public static OrderedCompoundTag read(FriendlyByteBuf buf) {
        int i = buf.readerIndex();
        byte b = buf.readByte();
        if (b == 0) {
            return null;
        }
        buf.readerIndex(i);
        try {
            DataInputStream stream = new DataInputStream((InputStream)new ByteBufInputStream((ByteBuf)buf));
            byte b1 = stream.readByte();
            if (b1 == 0) {
                return null;
            }
            stream.readUTF();
            TagType<?> tagType = NBTUtils.convertType(TagTypes.getType((int)b1));
            if (tagType != COMPOUND_TYPE) {
                return null;
            }
            return (OrderedCompoundTag)COMPOUND_TYPE.load((DataInput)stream, NbtAccounter.unlimitedHeap());
        }
        catch (IOException var5) {
            throw new EncoderException((Throwable)var5);
        }
    }

    public static Map<String, Tag> accessTagMap(CompoundTag tag) {
        return tag.tags;
    }
}

