/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.latvian.mods.kubejs.util.TickDuration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface TimeJS {
    public static final Pattern TEMPORAL_AMOUNT_PATTERN = Pattern.compile("(\\d+)\\s*(y|M|d|w|h|m|s|ms|ns|t)\\b");

    public static TemporalAmount wrapTemporalAmount(Object o) {
        if (o instanceof TemporalAmount) {
            TemporalAmount d = (TemporalAmount)o;
            return d;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return Duration.ofMillis(n.longValue());
        }
        if (o instanceof CharSequence) {
            Matcher matcher = TEMPORAL_AMOUNT_PATTERN.matcher(o.toString());
            double millis = 0.0;
            double nanos = 0.0;
            double ticks = Double.NaN;
            block24: while (matcher.find()) {
                double amount = Double.parseDouble(matcher.group(1));
                switch (matcher.group(2)) {
                    case "t": {
                        if (Double.isNaN(ticks)) {
                            ticks = 0.0;
                        }
                        ticks += amount;
                        continue block24;
                    }
                    case "ns": {
                        nanos += amount;
                        continue block24;
                    }
                    case "ms": {
                        millis += amount;
                        continue block24;
                    }
                    case "s": {
                        millis = amount * 1000.0;
                        continue block24;
                    }
                    case "m": {
                        millis = amount * 60000.0;
                        continue block24;
                    }
                    case "h": {
                        millis = amount * 60000.0 * 60.0;
                        continue block24;
                    }
                    case "d": {
                        millis = amount * 86400.0 * 1000.0;
                        continue block24;
                    }
                    case "w": {
                        millis = amount * 86400.0 * 7000.0;
                        continue block24;
                    }
                    case "M": {
                        millis = amount * 3.1556952E7 / 12.0 * 1000.0;
                        continue block24;
                    }
                    case "y": {
                        millis = amount * 3.1556952E7 * 1000.0;
                        continue block24;
                    }
                }
                throw new IllegalArgumentException("Invalid temporal unit: " + matcher.group(2));
            }
            if (!Double.isNaN(ticks)) {
                return TickDuration.of((long)(ticks + millis / 50.0));
            }
            return Duration.ofMillis((long)millis).plusNanos((long)nanos);
        }
        throw new IllegalArgumentException("Invalid temporal amount: " + String.valueOf(o));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Duration wrapDuration(Object o) {
        TemporalAmount t = TimeJS.wrapTemporalAmount(o);
        if (t instanceof Duration) {
            return (Duration)t;
        }
        if (t instanceof TickDuration) {
            TickDuration tickDuration = (TickDuration)t;
            try {
                long l;
                long ticks = l = tickDuration.ticks();
                return Duration.ofMillis(ticks * 50L);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        Duration d = Duration.ZERO;
        Iterator<TemporalUnit> iterator = t.getUnits().iterator();
        while (iterator.hasNext()) {
            TemporalUnit unit = iterator.next();
            d = d.plus(t.get(unit), unit);
        }
        return d;
    }

    public static void appendTimestamp(StringBuilder builder, Calendar calendar) {
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        if (h < 10) {
            builder.append('0');
        }
        builder.append(h);
        builder.append(':');
        if (m < 10) {
            builder.append('0');
        }
        builder.append(m);
        builder.append(':');
        if (s < 10) {
            builder.append('0');
        }
        builder.append(s);
    }

    public static String msToString(long ms) {
        if (ms < 1000L) {
            return ms + " ms";
        }
        return "%.3f".formatted(Float.valueOf((float)ms / 1000.0f)) + " s";
    }
}

