/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.codec.OrCodec;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.StringUtilsWrapper;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.TimeJS;
import dev.latvian.mods.rhino.type.ClassTypeInfo;
import dev.latvian.mods.rhino.type.EnumTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public interface KubeJSCodecs {
    public static final Codec<Character> CHARACTER = Codec.STRING.comapFlatMap(str -> {
        if (str.length() != 1) {
            return DataResult.error(() -> "Expected a single character, got empty string");
        }
        return DataResult.success((Object)Character.valueOf(str.charAt(0)));
    }, Object::toString);
    public static final Codec<ResourceLocation> KUBEJS_ID = Codec.STRING.comapFlatMap(s -> {
        try {
            if (s.indexOf(58) == -1) {
                return DataResult.success((Object)KubeJS.id(s));
            }
            return DataResult.success((Object)ResourceLocation.parse((String)s));
        }
        catch (ResourceLocationException ex) {
            return DataResult.error(() -> "Not a valid resource location: " + s + " " + ex.getMessage());
        }
    }, ID::reduceKjs).stable();
    public static final Codec<Class<?>> ENUM_CLASS = Codec.STRING.comapFlatMap(str -> {
        try {
            Class<?> c = Class.forName(str);
            if (!c.isEnum()) {
                return DataResult.error(() -> "Class '" + str + "' is not an enum");
            }
            return DataResult.success(c);
        }
        catch (ClassNotFoundException e) {
            return DataResult.error(() -> "Could not find enum class: " + str);
        }
    }, Class::getName);
    public static final Codec<EnumTypeInfo> ENUM_TYPE_INFO = ENUM_CLASS.comapFlatMap(c -> {
        TypeInfo patt0$temp = TypeInfo.of((Class)c);
        if (patt0$temp instanceof EnumTypeInfo) {
            EnumTypeInfo info = (EnumTypeInfo)patt0$temp;
            return DataResult.success((Object)info);
        }
        return DataResult.error(() -> "Class " + c.getTypeName() + " is not an enum!");
    }, ClassTypeInfo::asClass);
    public static final Codec<ResourceKey<? extends Registry<?>>> REGISTRY_KEY = ResourceLocation.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
    public static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");
    public static final Codec<Duration> DURATION = KubeJSCodecs.stringResolverCodec(Duration::toString, TimeJS::wrapDuration);
    public static final Codec<ResourceKey<? extends Registry<?>>> REGISTRY_KEY_CODEC = ResourceLocation.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
    public static final Codec<Map<String, JsonElement>> JSON_MAP = Codec.unboundedMap((Codec)Codec.STRING, (Codec)ExtraCodecs.JSON);
    public static final Codec<Integer> NON_NEGATIVE_INT = Codec.INT.validate(v -> v >= 0 ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be non-negative: " + v));
    public static final Codec<Integer> POSITIVE_INT = Codec.INT.validate(v -> v > 0 ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be positive: " + v));
    public static final Codec<Long> NON_NEGATIVE_LONG = Codec.LONG.validate(v -> v >= 0L ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be non-negative: " + v));
    public static final Codec<Long> POSITIVE_LONG = Codec.LONG.validate(v -> v > 0L ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be positive: " + v));
    public static final Codec<Float> NON_NEGATIVE_FLOAT = Codec.FLOAT.validate(v -> v.floatValue() >= 0.0f ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be non-negative: " + v));
    public static final Codec<Float> POSITIVE_FLOAT = Codec.FLOAT.validate(v -> v.floatValue() > 0.0f ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be positive: " + v));
    public static final Codec<Double> NON_NEGATIVE_DOUBLE = Codec.DOUBLE.validate(v -> v >= 0.0 ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be non-negative: " + v));
    public static final Codec<Double> POSITIVE_DOUBLE = Codec.DOUBLE.validate(v -> v > 0.0 ? DataResult.success((Object)v) : DataResult.error(() -> "Value must be positive: " + v));

    public static <E> Codec<E> stringResolverCodec(Function<E, String> toStringFunction, Function<String, E> fromStringFunction) {
        return Codec.STRING.flatXmap(str -> Optional.ofNullable(fromStringFunction.apply((String)str)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + str)), object -> DataResult.success((Object)((String)toStringFunction.apply(object))));
    }

    public static <E extends Enum<E>> E byName(Codec<E> codec, String s) {
        return (E)((Enum)KubeJSCodecs.fromJsonOrThrow((JsonElement)new JsonPrimitive(s), codec));
    }

    public static <E> E fromJsonOrThrow(JsonElement json, Codec<E> codec) {
        return KubeJSCodecs.fromJsonOrThrow(json, codec, str -> {
            throw new JsonSyntaxException("Could not decode element from JSON: " + str);
        });
    }

    public static <E> JsonElement toJsonOrThrow(E value, Codec<E> codec) {
        return KubeJSCodecs.toJsonOrThrow(value, codec, str -> {
            throw new IllegalArgumentException("Could not encode element to JSON: " + str);
        });
    }

    public static <E, X extends Throwable> E fromJsonOrThrow(JsonElement json, Codec<E> codec, Function<String, X> onError) throws X {
        return (E)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(onError);
    }

    public static <E, X extends Throwable> JsonElement toJsonOrThrow(E value, Codec<E> codec, Function<String, X> onError) throws X {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow(onError);
    }

    public static <T> String getUniqueId(T input, Codec<T> codec) {
        return StringUtilsWrapper.getUniqueId(input, (T o) -> KubeJSCodecs.toJsonOrThrow(o, codec));
    }

    public static JsonElement numberProviderJson(NumberProvider gen) {
        return KubeJSCodecs.toJsonOrThrow(gen, NumberProviders.CODEC);
    }

    public static <T> Codec<List<T>> listOfOrSelf(Codec<T> codec) {
        return KubeJSCodecs.listOfOrSelf(codec.listOf(), codec);
    }

    public static <T> Codec<List<T>> listOfOrSelf(Codec<List<T>> listCodec, Codec<T> codec) {
        return Codec.either(listCodec, codec).xmap(either -> (List)either.map(Function.identity(), List::of), Either::left);
    }

    public static <V> Codec<V> or(List<Codec<? extends V>> codecs) {
        return new OrCodec(codecs);
    }

    public static <V> Codec<V> or(Codec<? extends V> first, Codec<? extends V> second) {
        return new OrCodec(List.of(first, second));
    }

    public static Codec<Long> longRangeWithMessage(long min, long max, Function<Long, String> errorMessage) {
        return Codec.LONG.validate(v -> v.compareTo(min) >= 0 && v.compareTo(max) <= 0 ? DataResult.success((Object)v) : DataResult.error(() -> (String)errorMessage.apply((Long)v)));
    }
}

