/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.fluid.NamespaceFluidIngredient;
import dev.latvian.mods.kubejs.fluid.RegExFluidIngredient;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.DataComponentFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public interface FluidWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(FluidStack.class);
    public static final TypeInfo FLUID_TYPE_INFO = TypeInfo.of(Fluid.class);
    public static final TypeInfo INGREDIENT_TYPE_INFO = TypeInfo.of(FluidIngredient.class);
    public static final TypeInfo SIZED_INGREDIENT_TYPE_INFO = TypeInfo.of(SizedFluidIngredient.class);
    public static final SizedFluidIngredient EMPTY_SIZED = new SizedFluidIngredient(FluidIngredient.empty(), 1000);

    @HideFromJS
    public static FluidStack wrap(Context cx, Object o) {
        FluidStack fluidStack;
        RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
        Object object = o;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FluidStack.class, Fluid.class, Fluid.class, FluidIngredient.class, FluidIngredient.class, SizedFluidIngredient.class}, (Object)object, n)) {
                case -1: {
                    fluidStack = FluidStack.EMPTY;
                    break block9;
                }
                case 0: {
                    FluidStack stack = (FluidStack)object;
                    if (stack.isEmpty()) {
                        fluidStack = FluidStack.EMPTY;
                        break block9;
                    }
                    fluidStack = stack;
                    break block9;
                }
                case 1: {
                    Fluid fluid = (Fluid)object;
                    if (!fluid.kjs$isEmpty()) {
                        n = 2;
                        continue block9;
                    }
                    fluidStack = FluidStack.EMPTY;
                    break block9;
                }
                case 2: {
                    Fluid fluid = (Fluid)object;
                    fluidStack = new FluidStack(fluid, 1000);
                    break block9;
                }
                case 3: {
                    FluidIngredient in = (FluidIngredient)object;
                    if (!in.isEmpty() && !in.hasNoFluids()) {
                        n = 4;
                        continue block9;
                    }
                    fluidStack = FluidStack.EMPTY;
                    break block9;
                }
                case 4: {
                    FluidIngredient in = (FluidIngredient)object;
                    fluidStack = in.getStacks()[0];
                    break block9;
                }
                case 5: {
                    SizedFluidIngredient s = (SizedFluidIngredient)object;
                    fluidStack = s.getFluids()[0];
                    break block9;
                }
                default: {
                    fluidStack = FluidWrapper.ofString(cx, registries.nbt(), o.toString());
                    break block9;
                }
            }
            break;
        }
        return fluidStack;
    }

    public static FluidIngredient ingredientOf(FluidIngredient of) {
        return of;
    }

    @HideFromJS
    public static FluidIngredient wrapIngredient(Context cx, Object o) {
        FluidIngredient fluidIngredient;
        RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
        Object object = o;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FluidStack.class, Fluid.class, FluidIngredient.class, FluidStack.class, Fluid.class, FluidIngredient.class, SizedFluidIngredient.class}, (Object)object, n)) {
                case -1: {
                    fluidIngredient = FluidIngredient.empty();
                    break block10;
                }
                case 0: {
                    FluidStack stack = (FluidStack)object;
                    if (!stack.isEmpty()) {
                        n = 1;
                        continue block10;
                    }
                    fluidIngredient = FluidIngredient.empty();
                    break block10;
                }
                case 1: {
                    Fluid fluid = (Fluid)object;
                    if (!fluid.kjs$isEmpty()) {
                        n = 2;
                        continue block10;
                    }
                    fluidIngredient = FluidIngredient.empty();
                    break block10;
                }
                case 2: {
                    FluidIngredient in = (FluidIngredient)object;
                    if (!in.isEmpty()) {
                        n = 3;
                        continue block10;
                    }
                    fluidIngredient = FluidIngredient.empty();
                    break block10;
                }
                case 3: {
                    FluidStack stack = (FluidStack)object;
                    fluidIngredient = FluidIngredient.of((FluidStack[])new FluidStack[]{stack});
                    break block10;
                }
                case 4: {
                    Fluid fluid = (Fluid)object;
                    fluidIngredient = FluidIngredient.of((Fluid[])new Fluid[]{fluid});
                    break block10;
                }
                case 5: {
                    FluidIngredient in;
                    fluidIngredient = in = (FluidIngredient)object;
                    break block10;
                }
                case 6: {
                    SizedFluidIngredient s = (SizedFluidIngredient)object;
                    fluidIngredient = s.ingredient();
                    break block10;
                }
                default: {
                    fluidIngredient = FluidWrapper.ingredientOfString(cx, registries.nbt(), o.toString());
                    break block10;
                }
            }
            break;
        }
        return fluidIngredient;
    }

    public static SizedFluidIngredient sizedIngredientOf(SizedFluidIngredient of) {
        return of;
    }

    public static SizedFluidIngredient sizedIngredientOf(FluidIngredient in, int amount) {
        return new SizedFluidIngredient(in, amount);
    }

    @HideFromJS
    public static SizedFluidIngredient wrapSizedIngredient(Context cx, Object o) {
        SizedFluidIngredient sizedFluidIngredient;
        RegistryAccessContainer registries = RegistryAccessContainer.of(cx);
        Object object = o;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FluidStack.class, Fluid.class, FluidIngredient.class, FluidStack.class, Fluid.class, FluidIngredient.class, SizedFluidIngredient.class}, (Object)object, n)) {
                case -1: {
                    sizedFluidIngredient = EMPTY_SIZED;
                    break block10;
                }
                case 0: {
                    FluidStack stack = (FluidStack)object;
                    if (!stack.isEmpty()) {
                        n = 1;
                        continue block10;
                    }
                    sizedFluidIngredient = EMPTY_SIZED;
                    break block10;
                }
                case 1: {
                    Fluid fluid = (Fluid)object;
                    if (!fluid.kjs$isEmpty()) {
                        n = 2;
                        continue block10;
                    }
                    sizedFluidIngredient = EMPTY_SIZED;
                    break block10;
                }
                case 2: {
                    FluidIngredient in = (FluidIngredient)object;
                    if (!in.isEmpty()) {
                        n = 3;
                        continue block10;
                    }
                    sizedFluidIngredient = EMPTY_SIZED;
                    break block10;
                }
                case 3: {
                    FluidStack stack = (FluidStack)object;
                    sizedFluidIngredient = SizedFluidIngredient.of((FluidStack)stack);
                    break block10;
                }
                case 4: {
                    Fluid fluid = (Fluid)object;
                    sizedFluidIngredient = SizedFluidIngredient.of((Fluid)fluid, (int)1000);
                    break block10;
                }
                case 5: {
                    FluidIngredient in = (FluidIngredient)object;
                    sizedFluidIngredient = new SizedFluidIngredient(in, 1000);
                    break block10;
                }
                case 6: {
                    SizedFluidIngredient s;
                    sizedFluidIngredient = s = (SizedFluidIngredient)object;
                    break block10;
                }
                default: {
                    sizedFluidIngredient = FluidWrapper.sizedIngredientOfString(cx, registries.nbt(), o.toString());
                    break block10;
                }
            }
            break;
        }
        return sizedFluidIngredient;
    }

    public static FluidStack of(FluidStack o) {
        return o;
    }

    public static FluidStack of(FluidStack o, int amount) {
        o.setAmount(amount);
        return o;
    }

    public static FluidStack of(FluidStack o, DataComponentMap components) {
        o.applyComponents(components);
        return o;
    }

    public static FluidStack of(FluidStack o, int amount, DataComponentMap components) {
        o.setAmount(amount);
        o.applyComponents(components);
        return o;
    }

    public static FluidStack water() {
        return FluidWrapper.water(1000);
    }

    public static FluidStack lava() {
        return FluidWrapper.lava(1000);
    }

    public static FluidStack water(int amount) {
        return new FluidStack((Fluid)Fluids.WATER, amount);
    }

    public static FluidStack lava(int amount) {
        return new FluidStack((Fluid)Fluids.LAVA, amount);
    }

    public static Fluid getType(ResourceLocation id) {
        return (Fluid)BuiltInRegistries.FLUID.get(id);
    }

    public static List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            types.add(fluid.kjs$getId());
        }
        return types;
    }

    public static FluidStack getEmpty() {
        return FluidStack.EMPTY;
    }

    public static boolean exists(ResourceLocation id) {
        return BuiltInRegistries.FLUID.containsKey(id);
    }

    public static ResourceLocation getId(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static <T> T readWithContext(Context cx, DynamicOps<Tag> registryOps, String s, ReadFn<T> fn) {
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            return fn.read(registryOps, reader);
        }
        catch (CommandSyntaxException e) {
            throw new KubeRuntimeException(e).source(SourceLine.of(cx));
        }
    }

    public static FluidStack ofString(Context cx, DynamicOps<Tag> registryOps, String s) {
        return switch (s) {
            case "", "-", "empty", "minecraft:empty" -> FluidStack.EMPTY;
            default -> FluidWrapper.readWithContext(cx, registryOps, s, FluidWrapper::read);
        };
    }

    public static FluidStack read(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        char next;
        if (!reader.canRead()) {
            return FluidStack.EMPTY;
        }
        if (reader.peek() == '-') {
            return FluidStack.EMPTY;
        }
        long amount = FluidWrapper.readFluidAmount(reader);
        ResourceLocation fluidId = ResourceLocation.read((StringReader)reader);
        FluidStack fluidStack = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(fluidId), (int)amount);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            fluidStack.applyComponents(DataComponentWrapper.readPatch(registryOps, reader));
        }
        return fluidStack;
    }

    public static FluidIngredient ingredientOfString(Context cx, DynamicOps<Tag> registryOps, String s) {
        return switch (s) {
            case "", "-", "empty", "minecraft:empty" -> FluidIngredient.empty();
            default -> FluidWrapper.readWithContext(cx, registryOps, s, FluidWrapper::readIngredient);
        };
    }

    public static FluidIngredient readIngredient(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        DataComponentPredicate components;
        char next;
        if (!reader.canRead()) {
            return FluidIngredient.empty();
        }
        switch (reader.peek()) {
            case '-': {
                return FluidIngredient.empty();
            }
            case '#': {
                reader.skip();
                ResourceLocation tag = ResourceLocation.read((StringReader)reader);
                return FluidIngredient.tag((TagKey)FluidTags.create((ResourceLocation)tag));
            }
            case '@': {
                reader.skip();
                String id = reader.readString();
                return new NamespaceFluidIngredient(id);
            }
            case '/': {
                reader.skip();
                Pattern pattern = RegExpKJS.read(reader);
                return new RegExFluidIngredient(pattern);
            }
        }
        ResourceLocation fluidId = ResourceLocation.read((StringReader)reader);
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if ((next == '[' || next == '{') && (components = DataComponentWrapper.readPredicate(registryOps, reader)) != DataComponentPredicate.EMPTY) {
            return new DataComponentFluidIngredient((HolderSet)HolderSet.direct((Holder[])new Holder[]{fluid.kjs$asHolder()}), components, false);
        }
        return FluidIngredient.of((Fluid[])new Fluid[]{fluid});
    }

    public static SizedFluidIngredient sizedIngredientOfString(Context cx, DynamicOps<Tag> registryOps, String s) {
        return switch (s) {
            case "", "-", "empty", "minecraft:empty" -> EMPTY_SIZED;
            default -> FluidWrapper.readWithContext(cx, registryOps, s, FluidWrapper::readSizedIngredient);
        };
    }

    public static SizedFluidIngredient readSizedIngredient(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return EMPTY_SIZED;
        }
        long amount = FluidWrapper.readFluidAmount(reader);
        return new SizedFluidIngredient(FluidWrapper.readIngredient(registryOps, reader), (int)amount);
    }

    public static long readFluidAmount(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            double amountd = reader.readDouble();
            reader.skipWhitespace();
            if (reader.peek() == 'b' || reader.peek() == 'B') {
                reader.skip();
                reader.skipWhitespace();
                amountd *= 1000.0;
            }
            if (reader.peek() == '/') {
                reader.skip();
                reader.skipWhitespace();
                amountd /= reader.readDouble();
            }
            long amount = (long)amountd;
            reader.expect('x');
            reader.skipWhitespace();
            if (amount < 1L) {
                throw new IllegalArgumentException("Fluid amount smaller than 1 is not allowed!");
            }
            return amount;
        }
        return 1000L;
    }

    public static interface ReadFn<T> {
        public T read(DynamicOps<Tag> var1, StringReader var2) throws CommandSyntaxException;
    }
}

