/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.generator;

import dev.latvian.mods.kubejs.generator.KubeResourceGenerator;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.util.TickDuration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.random.Weight;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.registries.datamaps.builtin.BiomeVillagerType;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.MonsterRoomMob;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import net.neoforged.neoforge.registries.datamaps.builtin.Oxidizable;
import net.neoforged.neoforge.registries.datamaps.builtin.ParrotImitation;
import net.neoforged.neoforge.registries.datamaps.builtin.RaidHeroGift;
import net.neoforged.neoforge.registries.datamaps.builtin.VibrationFrequency;
import net.neoforged.neoforge.registries.datamaps.builtin.Waxable;

public interface KubeDataGenerator
extends KubeResourceGenerator {
    default public void setCompostable(ItemPredicate items, float chance, boolean canVillagerCompost) {
        this.dataMap(NeoForgeDataMaps.COMPOSTABLES, callback -> {
            Compostable data = new Compostable(chance, canVillagerCompost);
            for (Item item : items.kjs$getItemTypes()) {
                callback.accept(item.kjs$getIdLocation(), data);
            }
        });
    }

    default public void setFurnaceFuel(ItemPredicate items, TickDuration ticks) {
        this.dataMap(NeoForgeDataMaps.FURNACE_FUELS, callback -> {
            FurnaceFuel data = new FurnaceFuel(ticks.intTicks());
            for (Item item : items.kjs$getItemTypes()) {
                callback.accept(item.kjs$getIdLocation(), data);
            }
        });
    }

    default public void setMonsterRoomMobs(EntityType<?> entityType, int weight) {
        this.dataMap(NeoForgeDataMaps.MONSTER_ROOM_MOBS, callback -> callback.accept(entityType.kjs$getIdLocation(), new MonsterRoomMob(Weight.of((int)weight))));
    }

    default public void setOxidizable(Block from, Block to) {
        if (from != to) {
            this.dataMap(NeoForgeDataMaps.OXIDIZABLES, callback -> callback.accept(from.kjs$getIdLocation(), new Oxidizable(to)));
        }
    }

    default public void setParrotImitation(EntityType<?> type, SoundEvent sound) {
        this.dataMap(NeoForgeDataMaps.PARROT_IMITATIONS, callback -> callback.accept(type.kjs$getIdLocation(), new ParrotImitation(sound)));
    }

    default public void setRaidHeroGifts(VillagerProfession profession, ResourceKey<LootTable> lootTable) {
        this.dataMap(NeoForgeDataMaps.RAID_HERO_GIFTS, callback -> callback.accept(BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession), new RaidHeroGift(lootTable)));
    }

    default public void setVibrationFrequency(GameEvent gameEvent, int frequency) {
        this.dataMap(NeoForgeDataMaps.VIBRATION_FREQUENCIES, callback -> callback.accept(BuiltInRegistries.GAME_EVENT.getKey((Object)gameEvent), new VibrationFrequency(frequency)));
    }

    default public void setVillagerType(ResourceKey<Biome> biome, VillagerType villagerType) {
        this.dataMap(NeoForgeDataMaps.VILLAGER_TYPES, callback -> callback.accept(biome.location(), new BiomeVillagerType(villagerType)));
    }

    default public void setWaxable(Block from, Block to) {
        if (from != to) {
            this.dataMap(NeoForgeDataMaps.WAXABLES, callback -> callback.accept(from.kjs$getIdLocation(), new Waxable(to)));
        }
    }
}

