/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.level.LevelBlock;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.NBTWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.StringUtilsWrapper;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.ClampedInt;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface MiscWrappers {
    public static IntProvider wrapIntProvider(Context cx, Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            return ConstantInt.of((int)n.intValue());
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return UniformInt.of((int)min.intValue(), (int)max.intValue());
        }
        if (o instanceof Map) {
            Optional decoded;
            Map m = (Map)o;
            UniformInt intBounds = MiscWrappers.parseIntBounds(m);
            if (intBounds != null) {
                return intBounds;
            }
            if (m.containsKey("clamped")) {
                IntProvider source = MiscWrappers.wrapIntProvider(cx, m.get("clamped"));
                UniformInt clampTo = MiscWrappers.parseIntBounds(m);
                if (clampTo != null) {
                    return ClampedInt.of((IntProvider)source, (int)clampTo.getMinValue(), (int)clampTo.getMaxValue());
                }
            } else if (m.containsKey("clamped_normal")) {
                UniformInt clampTo = MiscWrappers.parseIntBounds(m);
                int mean = ((Number)m.get("mean")).intValue();
                int deviation = ((Number)m.get("deviation")).intValue();
                if (clampTo != null) {
                    return ClampedNormalInt.of((float)mean, (float)deviation, (int)clampTo.getMinValue(), (int)clampTo.getMaxValue());
                }
            }
            if ((decoded = IntProvider.CODEC.parse(RegistryAccessContainer.of(cx).nbt(), (Object)NBTWrapper.wrapCompound(cx, m)).result()).isPresent()) {
                return (IntProvider)decoded.get();
            }
        }
        return ConstantInt.of((int)0);
    }

    public static FloatProvider wrapFloatProvider(Context cx, Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            return ConstantFloat.of((float)n.floatValue());
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return UniformFloat.of((float)min.floatValue(), (float)max.floatValue());
        }
        if (o instanceof Map) {
            Optional decoded;
            Map m = (Map)o;
            UniformFloat floatBounds = MiscWrappers.parseFloatBounds(m);
            if (floatBounds != null) {
                return floatBounds;
            }
            if (m.containsKey("clamped_normal")) {
                UniformFloat clampTo = MiscWrappers.parseFloatBounds(m);
                int mean = ((Number)m.get("mean")).intValue();
                int deviation = ((Number)m.get("deviation")).intValue();
                if (clampTo != null) {
                    return ClampedNormalFloat.of((float)mean, (float)deviation, (float)clampTo.getMinValue(), (float)clampTo.getMaxValue());
                }
            }
            if ((decoded = FloatProvider.CODEC.parse(RegistryAccessContainer.of(cx).nbt(), (Object)NBTWrapper.wrapCompound(cx, m)).result()).isPresent()) {
                return (FloatProvider)decoded.get();
            }
        }
        return ConstantFloat.of((float)0.0f);
    }

    public static NumberProvider wrapNumberProvider(Object o) {
        List l;
        if (o instanceof Number) {
            Number n = (Number)o;
            float f = n.floatValue();
            return UniformGenerator.between((float)f, (float)f);
        }
        if (o instanceof List && !(l = (List)o).isEmpty()) {
            Number min = (Number)l.get(0);
            Number max = l.size() >= 2 ? (Number)((Number)l.get(1)) : (Number)min;
            return UniformGenerator.between((float)min.floatValue(), (float)max.floatValue());
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.containsKey("min") && m.containsKey("max")) {
                return UniformGenerator.between((float)((Number)m.get("min")).intValue(), (float)((Number)m.get("max")).floatValue());
            }
            if (m.containsKey("n") && m.containsKey("p")) {
                return BinomialDistributionGenerator.binomial((int)((Number)m.get("n")).intValue(), (float)((Number)m.get("p")).floatValue());
            }
            if (m.containsKey("value")) {
                float f = ((Number)m.get("value")).floatValue();
                return UniformGenerator.between((float)f, (float)f);
            }
        }
        return ConstantValue.exactly((float)0.0f);
    }

    public static Vec3 wrapVec3(@Nullable Object o) {
        Vec3 vec3;
        Object object = o;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Vec3.class, Entity.class, List.class, BlockPos.class, LevelBlock.class}, (Object)object, n)) {
                case 0: {
                    Vec3 vec;
                    vec3 = vec = (Vec3)object;
                    break block7;
                }
                case 1: {
                    Entity entity = (Entity)object;
                    vec3 = entity.position();
                    break block7;
                }
                case 2: {
                    List list = (List)object;
                    if (list.size() < 3) {
                        n = 3;
                        continue block7;
                    }
                    vec3 = new Vec3(StringUtilsWrapper.parseDouble(list.get(0), 0.0), StringUtilsWrapper.parseDouble(list.get(1), 0.0), StringUtilsWrapper.parseDouble(list.get(2), 0.0));
                    break block7;
                }
                case 3: {
                    BlockPos pos = (BlockPos)object;
                    vec3 = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                    break block7;
                }
                case 4: {
                    LevelBlock block = (LevelBlock)object;
                    vec3 = new Vec3(block.getCenterX(), block.getCenterY(), block.getCenterZ());
                    break block7;
                }
                default: {
                    vec3 = Vec3.ZERO;
                    break block7;
                }
            }
            break;
        }
        return vec3;
    }

    public static BlockPos wrapBlockPos(@Nullable Object o) {
        BlockPos blockPos;
        Object object = o;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockPos.class, List.class, LevelBlock.class, Vec3.class}, (Object)object, n)) {
                case 0: {
                    BlockPos pos;
                    blockPos = pos = (BlockPos)object;
                    break block6;
                }
                case 1: {
                    List list = (List)object;
                    if (list.size() < 3) {
                        n = 2;
                        continue block6;
                    }
                    blockPos = new BlockPos(StringUtilsWrapper.parseInt(list.get(0), 0), StringUtilsWrapper.parseInt(list.get(1), 0), StringUtilsWrapper.parseInt(list.get(2), 0));
                    break block6;
                }
                case 2: {
                    LevelBlock block = (LevelBlock)object;
                    blockPos = block.getPos();
                    break block6;
                }
                case 3: {
                    Vec3 vec = (Vec3)object;
                    blockPos = BlockPos.containing((double)vec.x, (double)vec.y, (double)vec.z);
                    break block6;
                }
                default: {
                    blockPos = BlockPos.ZERO;
                    break block6;
                }
            }
            break;
        }
        return blockPos;
    }

    private static UniformInt parseIntBounds(Map<String, Object> m) {
        Object object = m.get("bounds");
        if (object instanceof List) {
            List bounds = (List)object;
            return UniformInt.of((int)StringUtilsWrapper.parseInt(bounds.get(0), 0), (int)StringUtilsWrapper.parseInt(bounds.get(1), 0));
        }
        if (m.containsKey("min") && m.containsKey("max")) {
            return UniformInt.of((int)((Number)m.get("min")).intValue(), (int)((Number)m.get("max")).intValue());
        }
        if (m.containsKey("min_inclusive") && m.containsKey("max_inclusive")) {
            return UniformInt.of((int)((Number)m.get("min_inclusive")).intValue(), (int)((Number)m.get("max_inclusive")).intValue());
        }
        if (m.containsKey("value")) {
            int f = ((Number)m.get("value")).intValue();
            return UniformInt.of((int)f, (int)f);
        }
        return null;
    }

    private static UniformFloat parseFloatBounds(Map<String, Object> m) {
        Object object = m.get("bounds");
        if (object instanceof List) {
            List bounds = (List)object;
            return UniformFloat.of((float)((float)StringUtilsWrapper.parseDouble(bounds.get(0), 0.0)), (float)((float)StringUtilsWrapper.parseDouble(bounds.get(1), 0.0)));
        }
        if (m.containsKey("min") && m.containsKey("max")) {
            return UniformFloat.of((float)((Number)m.get("min")).floatValue(), (float)((Number)m.get("max")).floatValue());
        }
        if (m.containsKey("min_inclusive") && m.containsKey("max_inclusive")) {
            return UniformFloat.of((float)((Number)m.get("min_inclusive")).floatValue(), (float)((Number)m.get("max_inclusive")).floatValue());
        }
        if (m.containsKey("value")) {
            float f = ((Number)m.get("value")).floatValue();
            return UniformFloat.of((float)f, (float)f);
        }
        return null;
    }

    @Nullable
    public static Path wrapPath(Object o) {
        try {
            if (o instanceof Path) {
                return KubeJSPaths.verifyFilePath((Path)o);
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJSPaths.verifyFilePath(KubeJSPaths.GAMEDIR.resolve(o.toString()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public static File wrapFile(Object o) {
        try {
            if (o instanceof File) {
                return KubeJSPaths.verifyFilePath(((File)o).toPath()).toFile();
            }
            if (o == null || o.toString().isEmpty()) {
                return null;
            }
            return KubeJSPaths.verifyFilePath(KubeJSPaths.GAMEDIR.resolve(o.toString())).toFile();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

