/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.IngredientWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.SizedIngredientWrapper;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record SizedIngredientComponent(RecipeComponentType<?> type, Codec<SizedIngredient> codec, boolean allowEmpty) implements RecipeComponent<SizedIngredient>
{
    public static final RecipeComponentType<SizedIngredient> SIZED_INGREDIENT = RecipeComponentType.unit(KubeJS.id("sized_ingredient"), type -> new SizedIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedIngredient>)SizedIngredient.NESTED_CODEC, false));
    public static final RecipeComponentType<SizedIngredient> OPTIONAL_SIZED_INGREDIENT = RecipeComponentType.unit(KubeJS.id("optional_sized_ingredient"), type -> new SizedIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedIngredient>)SizedIngredient.NESTED_CODEC, true));
    public static final RecipeComponentType<SizedIngredient> FLAT = RecipeComponentType.unit(KubeJS.id("flat_sized_ingredient"), type -> new SizedIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedIngredient>)SizedIngredient.FLAT_CODEC, false));
    public static final RecipeComponentType<SizedIngredient> OPTIONAL_FLAT = RecipeComponentType.unit(KubeJS.id("optional_flat_sized_ingredient"), type -> new SizedIngredientComponent((RecipeComponentType<?>)type, (Codec<SizedIngredient>)SizedIngredient.FLAT_CODEC, true));

    @Override
    public TypeInfo typeInfo() {
        return SizedIngredientWrapper.TYPE_INFO;
    }

    @Override
    public boolean hasPriority(RecipeMatchContext cx, Object from) {
        return IngredientWrapper.isIngredientLike(from);
    }

    @Override
    public boolean matches(RecipeMatchContext cx, SizedIngredient value, ReplacementMatchInfo match) {
        ItemMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof ItemMatch && (m = (ItemMatch)replacementMatch).matches(cx, value.ingredient(), match.exact());
    }

    @Override
    public boolean isEmpty(SizedIngredient value) {
        return value.count() <= 0 || value.ingredient().isEmpty();
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, SizedIngredient value) {
        TagKey<Item> tag = IngredientWrapper.tagKeyOf(value.ingredient());
        if (tag != null) {
            builder.append(tag.location());
        } else {
            ItemStack first = value.ingredient().kjs$getFirst();
            if (!first.isEmpty()) {
                builder.append(first.kjs$getIdLocation());
            }
        }
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public List<Ingredient> spread(SizedIngredient value) {
        int count = value.count();
        if (count <= 0) {
            return List.of();
        }
        if (count == 1) {
            return List.of(value.ingredient());
        }
        ArrayList<Ingredient> list = new ArrayList<Ingredient>(count);
        Ingredient in = value.ingredient();
        for (int i = 0; i < count; ++i) {
            list.add(in);
        }
        return list;
    }
}

