/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.registry;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.BuilderType;
import dev.latvian.mods.kubejs.registry.BuilderTypeRegistryHandler;
import dev.latvian.mods.kubejs.registry.CustomBuilderObject;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.KubeResourceLocation;
import dev.latvian.mods.rhino.Context;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class ServerRegistryKubeEvent<T>
implements KubeEvent {
    public final ResourceKey<Registry<T>> registryKey;
    private final BuilderTypeRegistryHandler.Info<T> builderInfo;
    public final DynamicOps<JsonElement> jsonOps;
    public final Codec<T> codec;
    private final List<BuilderBase<?>> builders;

    public ServerRegistryKubeEvent(ResourceKey<Registry<T>> registryKey, DynamicOps<JsonElement> jsonOps, Codec<T> codec, List<BuilderBase<?>> builders) {
        this.registryKey = registryKey;
        this.builderInfo = BuilderTypeRegistryHandler.info(registryKey);
        this.jsonOps = jsonOps;
        this.codec = codec;
        this.builders = builders;
    }

    public BuilderBase<? extends T> create(Context cx, KubeResourceLocation id, KubeResourceLocation type) {
        SourceLine sourceLine = SourceLine.of(cx);
        BuilderType<T> t = this.builderInfo.namedType(type.wrapped());
        if (t == null) {
            throw new IllegalArgumentException("Unknown type '" + String.valueOf(type) + "' for object '" + String.valueOf(id) + "'!");
        }
        BuilderBase b = t.factory().createBuilder(id.wrapped());
        if (b == null) {
            throw new KubeRuntimeException("Unknown type '" + String.valueOf(type) + "' for object '" + String.valueOf(id) + "'!").source(sourceLine);
        }
        b.sourceLine = sourceLine;
        b.registryKey = this.registryKey;
        this.builders.add(b);
        return b;
    }

    public BuilderBase<? extends T> create(Context cx, KubeResourceLocation id) {
        SourceLine sourceLine = SourceLine.of(cx);
        BuilderType<T> t = this.builderInfo.defaultType();
        if (t == null) {
            throw new KubeRuntimeException("Registry '" + String.valueOf(this.registryKey.location()) + "' doesn't have a default type registered!").source(sourceLine);
        }
        BuilderBase b = t.factory().createBuilder(id.wrapped());
        if (b == null) {
            throw new KubeRuntimeException("Unknown type '" + String.valueOf(t.type()) + "' for object '" + String.valueOf(id) + "'!").source(sourceLine);
        }
        b.sourceLine = sourceLine;
        b.registryKey = this.registryKey;
        this.builders.add(b);
        return b;
    }

    public CustomBuilderObject createCustom(Context cx, KubeResourceLocation id, Supplier<Object> object) {
        SourceLine sourceLine = SourceLine.of(cx);
        if (object == null) {
            throw new KubeRuntimeException("Tried to register a null object with id: " + String.valueOf(id)).source(sourceLine);
        }
        CustomBuilderObject b = new CustomBuilderObject(id.wrapped(), object);
        b.sourceLine = sourceLine;
        b.registryKey = this.registryKey;
        this.builders.add(b);
        return b;
    }

    public CustomBuilderObject createFromJson(Context cx, KubeResourceLocation id, JsonElement json) {
        SourceLine sourceLine = SourceLine.of(cx);
        CustomBuilderObject b = new CustomBuilderObject(id.wrapped(), () -> this.codec.parse(this.jsonOps, (Object)json).result().orElseThrow());
        b.sourceLine = sourceLine;
        b.registryKey = this.registryKey;
        this.builders.add(b);
        return b;
    }
}

