/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.rhino.Context;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public record SourceLine(String source, int line) {
    public static final SourceLine UNKNOWN = new SourceLine("", 0);

    public static SourceLine of(@Nullable String source, int line) {
        if ((source == null || source.isEmpty()) && line <= 0) {
            return UNKNOWN;
        }
        return new SourceLine(source == null || source.isEmpty() ? "" : source, Math.max(line, 0));
    }

    public static SourceLine read(FriendlyByteBuf buf) {
        return SourceLine.of(buf.readUtf(), buf.readVarInt());
    }

    public static SourceLine of(@Nullable Context cx) {
        if (cx == null) {
            return UNKNOWN;
        }
        int[] lineP = new int[]{0};
        String source = Context.getSourcePositionFromStack((Context)cx, (int[])lineP);
        return SourceLine.of(source, lineP[0]);
    }

    public boolean isUnknown() {
        return this.source.isEmpty() && this.line <= 0;
    }

    @Override
    public String toString() {
        if (this.source.isEmpty() && this.line <= 0) {
            return "";
        }
        if (this.source.isEmpty()) {
            return "<unknown source>#" + this.line;
        }
        if (this.line <= 0) {
            return this.source;
        }
        return this.source + "#" + this.line;
    }

    public static void write(FriendlyByteBuf buf, SourceLine sourceLine) {
        buf.writeUtf(sourceLine.source);
        buf.writeVarInt(sourceLine.line);
    }
}

