/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.text.action;

import dev.latvian.mods.kubejs.text.action.AddTextAction;
import dev.latvian.mods.kubejs.text.action.ClearTextAction;
import dev.latvian.mods.kubejs.text.action.DynamicTextAction;
import dev.latvian.mods.kubejs.text.action.InsertTextAction;
import dev.latvian.mods.kubejs.text.action.RemoveExactTextTextAction;
import dev.latvian.mods.kubejs.text.action.RemoveLineTextAction;
import dev.latvian.mods.kubejs.text.action.RemoveTextTextAction;
import dev.latvian.mods.kubejs.text.action.TooltipActionType;
import dev.latvian.mods.kubejs.util.Cast;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;

public interface TextAction {
    public static final Map<Integer, TooltipActionType<?>> MAP = Stream.of(DynamicTextAction.TYPE, AddTextAction.TYPE, InsertTextAction.TYPE, RemoveLineTextAction.TYPE, RemoveTextTextAction.TYPE, RemoveExactTextTextAction.TYPE, ClearTextAction.TYPE).collect(Collectors.toMap(TooltipActionType::type, Function.identity()));
    public static final StreamCodec<RegistryFriendlyByteBuf, TextAction> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TextAction>(){

        public TextAction decode(RegistryFriendlyByteBuf buf) {
            byte id = buf.readByte();
            return (TextAction)MAP.get(id).streamCodec().decode((Object)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, TextAction value) {
            buf.writeByte(value.type().type());
            value.type().streamCodec().encode((Object)buf, (Object)((TextAction)Cast.to(value)));
        }
    };

    public TooltipActionType<?> type();

    public void apply(List<Component> var1);
}

