/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.state;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.level.ruletest.AllMatchRuleTest;
import dev.latvian.mods.kubejs.level.ruletest.AlwaysFalseRuleTest;
import dev.latvian.mods.kubejs.level.ruletest.AnyMatchRuleTest;
import dev.latvian.mods.kubejs.level.ruletest.InvertRuleTest;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.BlockWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.NBTWrapper;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.rhino.Context;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.jetbrains.annotations.Nullable;

public sealed interface BlockStatePredicate
extends Predicate<BlockState>,
ReplacementMatch {
    @Override
    public boolean test(BlockState var1);

    default public boolean testBlock(Block block) {
        return this.test(block.defaultBlockState());
    }

    @Nullable
    default public RuleTest asRuleTest() {
        return null;
    }

    public static BlockStatePredicate fromString(Context cx, String s) {
        BlockStatePredicate blockStatePredicate;
        String string = s;
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"*", "-", String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    blockStatePredicate = Simple.ALL;
                    break block6;
                }
                case 1: {
                    blockStatePredicate = Simple.NONE;
                    break block6;
                }
                case 2: {
                    String str = string2;
                    if (!str.startsWith("#")) {
                        n = 3;
                        continue block6;
                    }
                    blockStatePredicate = new TagMatch(Tags.block(ResourceLocation.parse((String)str.substring(1))));
                    break block6;
                }
                case 3: {
                    String str = string2;
                    if (str.indexOf(91) == -1) {
                        n = 4;
                        continue block6;
                    }
                    BlockState state = BlockWrapper.parseBlockState(RegistryAccessContainer.of(cx), str);
                    if (state != Blocks.AIR.defaultBlockState()) {
                        blockStatePredicate = new StateMatch(state);
                        break block6;
                    }
                    blockStatePredicate = Simple.NONE;
                    break block6;
                }
                default: {
                    Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)s));
                    if (block != Blocks.AIR) {
                        blockStatePredicate = new BlockMatch(block);
                        break block6;
                    }
                    blockStatePredicate = Simple.NONE;
                    break block6;
                }
            }
            break;
        }
        return blockStatePredicate;
    }

    public static BlockStatePredicate wrap(Context cx, Object o) {
        if (o == null || o == Simple.ALL) {
            return Simple.ALL;
        }
        if (o == Simple.NONE) {
            return Simple.NONE;
        }
        List<?> list = ListJS.orSelf(o);
        if (list.isEmpty()) {
            return Simple.NONE;
        }
        if (list.size() > 1) {
            ArrayList<BlockStatePredicate> predicates = new ArrayList<BlockStatePredicate>();
            for (Object o1 : list) {
                BlockStatePredicate p = BlockStatePredicate.wrap(cx, o1);
                if (p == Simple.ALL) {
                    return Simple.ALL;
                }
                if (p == Simple.NONE) continue;
                predicates.add(p);
            }
            return predicates.isEmpty() ? Simple.NONE : (predicates.size() == 1 ? (BlockStatePredicate)predicates.getFirst() : new OrMatch(predicates));
        }
        Object first = list.getFirst();
        Map map = cx.optionalMapOf(first);
        if (map != null) {
            if (map.isEmpty()) {
                return Simple.ALL;
            }
            ArrayList<BlockStatePredicate> predicates = new ArrayList<BlockStatePredicate>();
            if (map.get("or") != null) {
                predicates.add(BlockStatePredicate.wrap(cx, map.get("or")));
            }
            if (map.get("not") != null) {
                predicates.add(new NotMatch(BlockStatePredicate.wrap(cx, map.get("not"))));
            }
            return new AndMatch(predicates);
        }
        return BlockStatePredicate.ofSingle(cx, first);
    }

    public static RuleTest wrapRuleTest(Context cx, Object o) {
        RuleTest ruleTest;
        RegistryOps<Tag> nbt = RegistryAccessContainer.of(cx).nbt();
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RuleTest.class, BlockStatePredicate.class}, (Object)object2, n)) {
                case 0: {
                    RuleTest rule;
                    ruleTest = rule = (RuleTest)object2;
                    break block4;
                }
                case 1: {
                    BlockStatePredicate bsp = (BlockStatePredicate)object2;
                    if (bsp.asRuleTest() == null) {
                        n = 2;
                        continue block4;
                    }
                    ruleTest = bsp.asRuleTest();
                    break block4;
                }
                default: {
                    ruleTest = (RuleTest)Optional.ofNullable(NBTWrapper.wrapCompound(cx, o)).map(tag -> RuleTest.CODEC.parse((DynamicOps)nbt, tag)).flatMap(DataResult::result).or(() -> Optional.ofNullable(BlockStatePredicate.wrap(cx, o).asRuleTest())).orElseThrow(() -> new IllegalArgumentException("Could not parse valid rule test from " + String.valueOf(o) + "!"));
                    break block4;
                }
            }
            break;
        }
        return ruleTest;
    }

    private static BlockStatePredicate ofSingle(Context cx, Object o) {
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockStatePredicate.class, Block.class, BlockState.class, TagKey.class}, (Object)object2, n)) {
            case 0 -> {
                BlockStatePredicate bsp;
                yield bsp = (BlockStatePredicate)object2;
            }
            case 1 -> {
                Block block = (Block)object2;
                yield new BlockMatch(block);
            }
            case 2 -> {
                BlockState state = (BlockState)object2;
                yield new StateMatch(state);
            }
            case 3 -> {
                TagKey tag = (TagKey)object2;
                yield new TagMatch((TagKey<Block>)tag);
            }
            default -> {
                Pattern pattern = RegExpKJS.wrap(o);
                if (pattern == null) {
                    yield BlockStatePredicate.fromString(cx, o.toString());
                }
                yield new RegexMatch(pattern);
            }
        };
    }

    default public Collection<BlockState> getBlockStates() {
        HashSet<BlockState> states = new HashSet<BlockState>();
        for (BlockState state : BlockWrapper.getAllBlockStates()) {
            if (!this.test(state)) continue;
            states.add(state);
        }
        return states;
    }

    default public Collection<Block> getBlocks() {
        HashSet<Block> blocks = new HashSet<Block>();
        for (BlockState state : this.getBlockStates()) {
            blocks.add(state.getBlock());
        }
        return blocks;
    }

    default public Set<ResourceLocation> getBlockIds() {
        LinkedHashSet<ResourceLocation> set = new LinkedHashSet<ResourceLocation>();
        for (Block block : this.getBlocks()) {
            set.add(block.kjs$getIdLocation());
        }
        return set;
    }

    default public boolean check(List<OreConfiguration.TargetBlockState> targetStates) {
        for (OreConfiguration.TargetBlockState state : targetStates) {
            if (!this.test(state.state)) continue;
            return true;
        }
        return false;
    }

    public static enum Simple implements BlockStatePredicate
    {
        ALL(true),
        NONE(false);

        private final boolean match;

        private Simple(boolean match) {
            this.match = match;
        }

        @Override
        public boolean test(BlockState state) {
            return this.match;
        }

        @Override
        public boolean testBlock(Block block) {
            return this.match;
        }

        @Override
        public RuleTest asRuleTest() {
            return this.match ? AlwaysTrueTest.INSTANCE : AlwaysFalseRuleTest.INSTANCE;
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            return this.match ? BlockWrapper.getAllBlockStates() : List.of();
        }
    }

    public record TagMatch(TagKey<Block> tag) implements BlockStatePredicate
    {
        @Override
        public boolean test(BlockState state) {
            return state.is(this.tag);
        }

        @Override
        public boolean testBlock(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        @Override
        public Collection<Block> getBlocks() {
            return (Collection)Util.make(new LinkedHashSet(), set -> {
                for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag)) {
                    set.add((Block)holder.value());
                }
            });
        }

        @Override
        public RuleTest asRuleTest() {
            return new TagMatchTest(this.tag);
        }
    }

    public record StateMatch(BlockState state) implements BlockStatePredicate
    {
        @Override
        public boolean test(BlockState s) {
            return this.state == s;
        }

        @Override
        public boolean testBlock(Block block) {
            return this.state.getBlock() == block;
        }

        @Override
        public Collection<Block> getBlocks() {
            return Collections.singleton(this.state.getBlock());
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            return Collections.singleton(this.state);
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            return Set.of(this.state.getBlock().kjs$getIdLocation());
        }

        @Override
        public RuleTest asRuleTest() {
            return new BlockStateMatchTest(this.state);
        }
    }

    public record BlockMatch(Block block) implements BlockStatePredicate
    {
        @Override
        public boolean test(BlockState state) {
            return state.is(this.block);
        }

        @Override
        public boolean testBlock(Block block) {
            return this.block == block;
        }

        @Override
        public Collection<Block> getBlocks() {
            return Collections.singleton(this.block);
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            return this.block.getStateDefinition().getPossibleStates();
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            return Set.of(this.block.kjs$getIdLocation());
        }

        @Override
        public RuleTest asRuleTest() {
            return new BlockMatchTest(this.block);
        }
    }

    public record OrMatch(List<BlockStatePredicate> list) implements BlockStatePredicate
    {
        @Override
        public boolean test(BlockState state) {
            for (BlockStatePredicate predicate : this.list) {
                if (!predicate.test(state)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testBlock(Block block) {
            for (BlockStatePredicate predicate : this.list) {
                if (!predicate.testBlock(block)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<Block> getBlocks() {
            HashSet<Block> set = new HashSet<Block>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlocks());
            }
            return set;
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            HashSet<BlockState> set = new HashSet<BlockState>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlockStates());
            }
            return set;
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            LinkedHashSet<ResourceLocation> set = new LinkedHashSet<ResourceLocation>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlockIds());
            }
            return set;
        }

        @Override
        public RuleTest asRuleTest() {
            AnyMatchRuleTest test = new AnyMatchRuleTest();
            for (BlockStatePredicate predicate : this.list) {
                test.rules.add(predicate.asRuleTest());
            }
            return test;
        }
    }

    public static final class NotMatch
    implements BlockStatePredicate {
        private final BlockStatePredicate predicate;
        private final Collection<BlockState> cachedStates;

        public NotMatch(BlockStatePredicate predicate) {
            this.predicate = predicate;
            this.cachedStates = new LinkedHashSet<BlockState>();
            for (Block block : BuiltInRegistries.BLOCK) {
                for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                    if (predicate.test(state)) continue;
                    this.cachedStates.add(state);
                }
            }
        }

        @Override
        public boolean test(BlockState state) {
            return !this.predicate.test(state);
        }

        @Override
        public boolean testBlock(Block block) {
            return !this.predicate.testBlock(block);
        }

        @Override
        public Collection<Block> getBlocks() {
            HashSet<Block> set = new HashSet<Block>();
            for (BlockState blockState : this.getBlockStates()) {
                set.add(blockState.getBlock());
            }
            return set;
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            return this.cachedStates;
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
            for (Block block : this.getBlocks()) {
                set.add(block.kjs$getIdLocation());
            }
            return set;
        }

        @Override
        public RuleTest asRuleTest() {
            return new InvertRuleTest(this.predicate.asRuleTest());
        }
    }

    public static final class AndMatch
    implements BlockStatePredicate {
        private final List<BlockStatePredicate> list;
        private final Collection<BlockState> cachedStates;

        public AndMatch(List<BlockStatePredicate> list) {
            this.list = list;
            this.cachedStates = new LinkedHashSet<BlockState>();
            for (Block block : BuiltInRegistries.BLOCK) {
                for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                    boolean match = true;
                    for (BlockStatePredicate predicate : list) {
                        if (predicate.test(state)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    this.cachedStates.add(state);
                }
            }
        }

        @Override
        public boolean test(BlockState state) {
            for (BlockStatePredicate predicate : this.list) {
                if (predicate.test(state)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean testBlock(Block block) {
            for (BlockStatePredicate predicate : this.list) {
                if (predicate.testBlock(block)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Collection<Block> getBlocks() {
            HashSet<Block> set = new HashSet<Block>();
            for (BlockState blockState : this.getBlockStates()) {
                set.add(blockState.getBlock());
            }
            return set;
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            return this.cachedStates;
        }

        @Override
        public RuleTest asRuleTest() {
            AllMatchRuleTest test = new AllMatchRuleTest();
            for (BlockStatePredicate predicate : this.list) {
                test.rules.add(predicate.asRuleTest());
            }
            return test;
        }
    }

    public static final class RegexMatch
    implements BlockStatePredicate {
        public final Pattern pattern;
        private final LinkedHashSet<Block> matchedBlocks;

        public RegexMatch(Pattern p) {
            this.pattern = p;
            this.matchedBlocks = new LinkedHashSet();
            for (Block block : BuiltInRegistries.BLOCK) {
                if (this.matchedBlocks.contains(block) || !this.pattern.matcher(block.kjs$getId()).find()) continue;
                this.matchedBlocks.add(block);
            }
        }

        @Override
        public boolean test(BlockState state) {
            return this.matchedBlocks.contains(state.getBlock());
        }

        @Override
        public boolean testBlock(Block block) {
            return this.matchedBlocks.contains(block);
        }

        @Override
        public Collection<Block> getBlocks() {
            return this.matchedBlocks;
        }

        @Override
        public RuleTest asRuleTest() {
            AnyMatchRuleTest test = new AnyMatchRuleTest();
            for (Block block : this.matchedBlocks) {
                test.rules.add((RuleTest)new BlockMatchTest(block));
            }
            return test;
        }
    }
}

