/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.client.BlockEntityRendererRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.BlockTintFunctionWrapper;
import dev.latvian.mods.kubejs.client.ClientPlayerKubeEvent;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.client.DebugInfoKubeEvent;
import dev.latvian.mods.kubejs.client.EntityRendererRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.ItemTintFunctionWrapper;
import dev.latvian.mods.kubejs.client.KeybindRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import dev.latvian.mods.kubejs.client.KubeJSErrorScreen;
import dev.latvian.mods.kubejs.client.KubeJSKeybinds;
import dev.latvian.mods.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.mods.kubejs.client.KubeSessionData;
import dev.latvian.mods.kubejs.client.MenuScreenRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.ParticleProviderRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.TagInstance;
import dev.latvian.mods.kubejs.client.VSCodeExt;
import dev.latvian.mods.kubejs.client.highlight.HighlightRenderer;
import dev.latvian.mods.kubejs.command.KubeJSClientCommands;
import dev.latvian.mods.kubejs.fluid.FluidBlockBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.fluid.FluidTypeBuilder;
import dev.latvian.mods.kubejs.gui.KubeJSMenus;
import dev.latvian.mods.kubejs.gui.KubeJSScreen;
import dev.latvian.mods.kubejs.item.DynamicItemTooltipsKubeEvent;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemModelPropertiesKubeEvent;
import dev.latvian.mods.kubejs.item.ModifyItemTooltipsKubeEvent;
import dev.latvian.mods.kubejs.plugin.builtin.event.ClientEvents;
import dev.latvian.mods.kubejs.plugin.builtin.event.ItemEvents;
import dev.latvian.mods.kubejs.plugin.builtin.event.KeyBindEvents;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.TextIcons;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.stages.Stages;
import dev.latvian.mods.kubejs.text.action.DynamicTextAction;
import dev.latvian.mods.kubejs.text.action.TextAction;
import dev.latvian.mods.kubejs.text.tooltip.ItemTooltipData;
import dev.latvian.mods.kubejs.text.tooltip.TooltipRequirements;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.StackTraceCollector;
import dev.latvian.mods.kubejs.util.Tristate;
import dev.latvian.mods.kubejs.web.LocalWebServer;
import dev.latvian.mods.kubejs.web.WebServerProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="kubejs", value={Dist.CLIENT})
public class KubeJSClientEventHandler {
    public static final Pattern COMPONENT_ERROR = ConsoleJS.methodPattern(KubeJSClientEventHandler.class, "onItemTooltip");
    private static List<String> lastComponentError = List.of();

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void setupClient(FMLClientSetupEvent event) {
        KubeJS.PROXY = new KubeJSClient();
        event.enqueueWork(KubeJSClientEventHandler::setupClient0);
        if (VSCodeExt.isInstalled()) {
            ConsoleJS.CLIENT.info("VSCode " + VSCodeExt.getVersion() + " detected");
        }
    }

    @SubscribeEvent
    public static void addClientPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addRepositorySource((RepositorySource)new KubeJSResourcePackFinder());
        }
    }

    private static void setupClient0() {
        BuilderBase b;
        if (!PlatformWrapper.isGeneratingData() && Minecraft.getInstance() != null && WebServerProperties.get().enabled) {
            LocalWebServer.start(Minecraft.getInstance(), true);
        }
        ItemEvents.MODEL_PROPERTIES.post(ScriptType.STARTUP, new ItemModelPropertiesKubeEvent());
        for (BuilderBase<Block> builderBase : RegistryObjectStorage.BLOCK) {
            BlockRenderType blockRenderType;
            if (!(builderBase instanceof BlockBuilder)) continue;
            b = (BlockBuilder)builderBase;
            if (b instanceof FluidBlockBuilder) {
                FluidBlockBuilder fb = (FluidBlockBuilder)b;
                blockRenderType = fb.fluidBuilder.fluidType.renderType;
            } else {
                blockRenderType = ((BlockBuilder)b).renderType;
            }
            switch (blockRenderType) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.cutout());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.cutoutMipped());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.translucent());
                }
            }
        }
        for (BuilderBase<Block> builderBase : RegistryObjectStorage.FLUID) {
            if (!(builderBase instanceof FluidBuilder)) continue;
            b = (FluidBuilder)builderBase;
            switch (((FluidBuilder)b).fluidType.renderType) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.cutout());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.cutout());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.cutoutMipped());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.cutoutMipped());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.translucent());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.translucent());
                }
            }
        }
        ArrayList list = new ArrayList();
        ItemEvents.MODIFY_TOOLTIPS.post(ScriptType.CLIENT, new ModifyItemTooltipsKubeEvent(list::add));
        KubeJSClient.clientItemTooltips = List.copyOf(list);
    }

    @SubscribeEvent
    public static void blockColors(RegisterColorHandlersEvent.Block event) {
        for (BuilderBase<Block> builderBase : RegistryObjectStorage.BLOCK) {
            if (!(builderBase instanceof BlockBuilder)) continue;
            BlockBuilder b = (BlockBuilder)builderBase;
            if (b.tint == null) continue;
            event.register((BlockColor)new BlockTintFunctionWrapper(b.tint), new Block[]{(Block)b.get()});
        }
    }

    @SubscribeEvent
    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        for (BuilderBase<Item> builderBase : RegistryObjectStorage.ITEM) {
            if (!(builderBase instanceof ItemBuilder)) continue;
            ItemBuilder b = (ItemBuilder)builderBase;
            if (b.tint == null) continue;
            event.register((ItemColor)new ItemTintFunctionWrapper(b.tint), new ItemLike[]{(ItemLike)b.get()});
        }
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(KubeJSMenus.MENU.get(), KubeJSScreen::new);
        ClientEvents.MENU_SCREEN_REGISTRY.post(ScriptType.STARTUP, new MenuScreenRegistryKubeEvent(event));
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientEvents.ENTITY_RENDERER_REGISTRY.post(ScriptType.STARTUP, new EntityRendererRegistryKubeEvent(event));
        ClientEvents.BLOCK_ENTITY_RENDERER_REGISTRY.post(ScriptType.STARTUP, new BlockEntityRendererRegistryKubeEvent(event));
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        HighlightRenderer.keyMapping = new KeyMapping("key.kubejs.kubedex", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputConstants.Type.KEYSYM, 75, "key.categories.kubejs");
        event.register(HighlightRenderer.keyMapping);
        KeybindRegistryKubeEvent kubeEvent = new KeybindRegistryKubeEvent();
        KeyBindEvents.REGISTRY.post(kubeEvent);
        for (KubeJSKeybinds.KubeKey bind : kubeEvent.build()) {
            event.register(bind.mapping);
        }
        KubeJSKeybinds.triggerReload();
    }

    @SubscribeEvent
    public static void registerCoreShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ID.mc("kubejs/rendertype_highlight"), DefaultVertexFormat.POSITION_COLOR), s -> {
            HighlightRenderer.INSTANCE.highlightShader = s;
        });
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        for (BuilderBase<FluidType> builderBase : RegistryObjectStorage.FLUID_TYPE) {
            if (!(builderBase instanceof FluidTypeBuilder)) continue;
            final FluidTypeBuilder b = (FluidTypeBuilder)builderBase;
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return b.actualStillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return b.actualFlowingTexture;
                }

                public ResourceLocation getOverlayTexture() {
                    return b.blockOverlayTexture;
                }

                @Nullable
                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return b.screenOverlayTexture;
                }
            }, new FluidType[]{(FluidType)b.get()});
        }
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        if (ClientEvents.PARTICLE_PROVIDER_REGISTRY.hasListeners()) {
            ClientEvents.PARTICLE_PROVIDER_REGISTRY.post(new ParticleProviderRegistryKubeEvent(event));
        }
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        KubeJSClientCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void debugInfo(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            if (ClientEvents.DEBUG_LEFT.hasListeners()) {
                ClientEvents.DEBUG_LEFT.post(new DebugInfoKubeEvent(mc.player, event.getLeft()));
            }
            if (ClientEvents.DEBUG_RIGHT.hasListeners()) {
                ClientEvents.DEBUG_RIGHT.post(new DebugInfoKubeEvent(mc.player, event.getRight()));
            }
        }
    }

    private static <T> List<String> appendComponentValue(DynamicOps<Tag> ops, MutableComponent line, DataComponentType<T> type, T value) {
        if (value == null) {
            line.append((Component)Component.literal((String)"null").kjs$red());
            return List.of();
        }
        if (value instanceof Component) {
            Component c = (Component)value;
            line.append((Component)Component.empty().kjs$gold().append(c));
        }
        try {
            Tag tag = (Tag)type.codecOrThrow().encodeStart(ops, value).getOrThrow();
            line.append(NbtUtils.toPrettyComponent((Tag)tag));
            return List.of();
        }
        catch (Throwable ex) {
            line.append((Component)Component.literal((String)String.valueOf(value)).kjs$red());
            ArrayList<String> lines = new ArrayList<String>();
            ex.printStackTrace(new StackTraceCollector(lines, COMPONENT_ERROR, ConsoleJS.ERROR_REDUCE));
            return lines;
        }
    }

    public static boolean testRequirements(Minecraft mc, DynamicItemTooltipsKubeEvent event, TooltipRequirements r) {
        if (!r.advanced().test(event.advanced)) {
            return false;
        }
        if (!r.creative().test(event.creative)) {
            return false;
        }
        if (!r.shift().test(event.shift)) {
            return false;
        }
        if (!r.ctrl().test(event.ctrl)) {
            return false;
        }
        if (!r.alt().test(event.alt)) {
            return false;
        }
        if (!r.stages().isEmpty()) {
            Stages stages = mc.player.kjs$getStages();
            for (Map.Entry<String, Tristate> entry : r.stages().entrySet()) {
                if (entry.getValue() == Tristate.DEFAULT || entry.getValue().test(stages.has(entry.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void handleItemTooltips(Minecraft mc, ItemTooltipData tooltip, DynamicItemTooltipsKubeEvent event) {
        if ((tooltip.filter().isEmpty() || tooltip.filter().get().test(event.item)) && (tooltip.requirements().isEmpty() || KubeJSClientEventHandler.testRequirements(mc, event, tooltip.requirements().get()))) {
            for (TextAction action : tooltip.actions()) {
                if (action instanceof DynamicTextAction) {
                    String id;
                    DynamicTextAction dynamicTextAction = (DynamicTextAction)action;
                    try {
                        String string;
                        id = string = dynamicTextAction.id();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    try {
                        ItemEvents.DYNAMIC_TOOLTIPS.post(ScriptType.CLIENT, id, event);
                    }
                    catch (Exception ex) {
                        ConsoleJS.CLIENT.error("Item " + event.item.kjs$getId() + " dynamic tooltip error", ex);
                    }
                    continue;
                }
                action.apply(event.lines);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        List lines = event.getToolTip();
        TooltipFlag flags = event.getFlags();
        KubeSessionData sessionData = KubeSessionData.of(mc);
        DynamicItemTooltipsKubeEvent dynamicEvent = new DynamicItemTooltipsKubeEvent(stack, flags, lines, sessionData == null);
        for (ItemTooltipData tooltip : KubeJSClient.clientItemTooltips) {
            KubeJSClientEventHandler.handleItemTooltips(mc, tooltip, dynamicEvent);
        }
        if (sessionData != null) {
            for (ItemTooltipData tooltip : sessionData.itemTooltips) {
                KubeJSClientEventHandler.handleItemTooltips(mc, tooltip, dynamicEvent);
            }
        }
        boolean advanced = flags.isAdvanced();
        ClientProperties properties = ClientProperties.get();
        if (mc.level != null && advanced && properties.showComponents && dynamicEvent.alt) {
            List<String> errors0;
            MutableComponent line;
            ResourceLocation id;
            Registry components = BuiltInRegistries.DATA_COMPONENT_TYPE;
            RegistryOps ops = mc.level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            ArrayList<String> errors = new ArrayList<String>(0);
            for (Map.Entry entry : stack.getComponentsPatch().entrySet()) {
                id = components.getKey((Object)((DataComponentType)entry.getKey()));
                if (id == null) continue;
                line = Component.empty();
                line.append((Component)TextIcons.icon(Component.literal((String)"Q.")));
                if (((Optional)entry.getValue()).isEmpty()) {
                    line.append((Component)Component.literal((String)"!"));
                }
                line.append((Component)Component.literal((String)ID.reduce(id)).kjs$yellow());
                if (((Optional)entry.getValue()).isPresent()) {
                    line.append((Component)Component.literal((String)"="));
                    errors0 = KubeJSClientEventHandler.appendComponentValue((DynamicOps<Tag>)ops, line, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get());
                    if (!errors0.isEmpty()) {
                        lines.add(Component.literal((String)(ID.reduce(id) + " errored, see log")).kjs$darkRed());
                        errors.add("Failed to encode value of " + String.valueOf(id) + ": " + String.valueOf(((Optional)entry.getValue()).get()));
                        errors.addAll(errors0);
                    }
                }
                lines.add(line);
            }
            if (dynamicEvent.shift) {
                for (TypedDataComponent type : stack.getPrototype()) {
                    id = components.getKey((Object)type.type());
                    if (id == null || stack.getComponentsPatch().get(type.type()) != null) continue;
                    line = Component.empty();
                    line.append((Component)TextIcons.icon(Component.literal((String)"P.")));
                    line.append((Component)Component.literal((String)ID.reduce(id)).kjs$gray());
                    line.append((Component)Component.literal((String)"="));
                    errors0 = KubeJSClientEventHandler.appendComponentValue((DynamicOps<Tag>)ops, line, type.type(), type.value());
                    if (!errors0.isEmpty()) {
                        lines.add(Component.literal((String)(ID.reduce(id) + " errored, see log")).kjs$darkRed());
                        errors.add("Failed to encode value of " + String.valueOf(id) + ": " + String.valueOf(type.value()));
                        errors.addAll(errors0);
                    }
                    lines.add(line);
                }
            }
            if (!errors.isEmpty() && !lastComponentError.equals(errors)) {
                lastComponentError = errors;
                errors.forEach(ConsoleJS.CLIENT::error);
            }
        } else if (advanced && (properties.showTagNames || properties.showFuelValue) && dynamicEvent.shift) {
            Object s;
            int fuel;
            if (properties.showFuelValue && (fuel = stack.getBurnTime(null)) > 0) {
                MutableComponent line = Component.empty();
                line.append((Component)TextIcons.icon(Component.literal((String)"R.")));
                line.append((Component)Component.literal((String)"Fuel: ").kjs$gold());
                s = String.valueOf((float)fuel / 20.0f);
                line.append((Component)Component.literal((String)(fuel + " t / " + (String)(((String)s).endsWith(".0") ? ((String)s).substring(0, ((String)s).length() - 2) : s) + " s")).kjs$yellow());
                lines.add(line);
            }
            if (properties.showTagNames) {
                EntityType entityType;
                Item fluid;
                BlockItem item;
                LinkedHashMap<ResourceLocation, TagInstance> tempTagNames = new LinkedHashMap<ResourceLocation, TagInstance>();
                TagInstance.Type.ITEM.append(tempTagNames, stack.getItem().builtInRegistryHolder().tags());
                s = stack.getItem();
                if (s instanceof BlockItem) {
                    item = (BlockItem)s;
                    TagInstance.Type.BLOCK.append(tempTagNames, item.getBlock().builtInRegistryHolder().tags());
                }
                if ((s = stack.getItem()) instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)s;
                    fluid = bucket.content;
                    if (fluid != Fluids.EMPTY) {
                        TagInstance.Type.FLUID.append(tempTagNames, fluid.builtInRegistryHolder().tags());
                    }
                }
                if ((fluid = stack.getItem()) instanceof SpawnEggItem && (entityType = (item = (SpawnEggItem)fluid).getType(stack)) != null) {
                    TagInstance.Type.ENTITY.append(tempTagNames, entityType.builtInRegistryHolder().tags());
                }
                if (!tempTagNames.isEmpty()) {
                    tempTagNames.values().stream().sorted().map(TagInstance::toText).forEach(lines::add);
                }
            }
        }
    }

    @SubscribeEvent
    public static void loggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientEvents.LOGGED_IN.post(ScriptType.CLIENT, new ClientPlayerKubeEvent(event.getPlayer()));
    }

    @SubscribeEvent
    public static void loggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientEvents.LOGGED_OUT.post(ScriptType.CLIENT, new ClientPlayerKubeEvent(event.getPlayer()));
    }

    @SubscribeEvent
    public static void hudPostDraw(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        HighlightRenderer.INSTANCE.hudPostDraw(mc, event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaPartialTick(false));
    }

    @SubscribeEvent
    public static void screenPostDraw(ScreenEvent.Render.Post event) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            HighlightRenderer.INSTANCE.screen(mc, event.getGuiGraphics(), screen2, event.getMouseX(), event.getMouseY(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        HighlightRenderer.INSTANCE.tickPre(mc);
        KubeJSKeybinds.triggerKeyEvents(mc);
    }

    @SubscribeEvent
    public static void worldRender(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            HighlightRenderer.INSTANCE.clearBuffers(mc);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            HighlightRenderer.INSTANCE.renderAfterEntities(mc, event);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            HighlightRenderer.INSTANCE.renderAfterLevel(mc, event);
        }
    }

    @Nullable
    public static Screen setScreen(Screen screen) {
        if (screen instanceof TitleScreen && !ConsoleJS.STARTUP.errors.isEmpty() && CommonProperties.get().startupErrorGUI) {
            return new KubeJSErrorScreen(screen, ConsoleJS.STARTUP, false);
        }
        if (screen instanceof TitleScreen && !ConsoleJS.CLIENT.errors.isEmpty() && CommonProperties.get().startupErrorGUI) {
            return new KubeJSErrorScreen(screen, ConsoleJS.CLIENT, false);
        }
        return screen;
    }

    @SubscribeEvent
    public static void guiPostInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (ClientProperties.get().disableRecipeBook && screen instanceof RecipeUpdateListener) {
            Iterator iterator = screen.children().iterator();
            while (iterator.hasNext()) {
                GuiEventListener listener = (GuiEventListener)iterator.next();
                if (!(listener instanceof ImageButton)) continue;
                ImageButton button = (ImageButton)listener;
                if (!button.sprites.enabled().equals((Object)KubeJSClient.RECIPE_BUTTON_TEXTURE)) continue;
                screen.renderables.remove(listener);
                screen.narratables.remove(listener);
                iterator.remove();
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void openScreenEvent(ScreenEvent.Opening event) {
        Screen s = KubeJSClientEventHandler.setScreen(event.getScreen());
        if (s != null && event.getScreen() != s) {
            event.setNewScreen(s);
        }
    }

    @SubscribeEvent
    public static void tagsUpdated(TagsUpdatedEvent event) {
        Screen screen;
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && (screen = Minecraft.getInstance().screen) instanceof KubeJSErrorScreen) {
            KubeJSErrorScreen screen2 = (KubeJSErrorScreen)screen;
            if (screen2.scriptType == ScriptType.SERVER) {
                Minecraft.getInstance().kjs$runCommand("kubejs errors server");
            }
        }
    }
}

