/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.icon;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.latvian.mods.kubejs.client.icon.AtlasSpriteKubeIcon;
import dev.latvian.mods.kubejs.client.icon.ItemKubeIcon;
import dev.latvian.mods.kubejs.client.icon.KubeIcon;
import dev.latvian.mods.kubejs.client.icon.KubeIconType;
import dev.latvian.mods.kubejs.client.icon.TextureKubeIcon;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.Lazy;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public interface KubeIconRenderer {
    public static final Lazy<Map<KubeIconType<?>, Function<?, KubeIconRenderer>>> RENDERERS = Lazy.map(map -> {
        Registry registry = map::put;
        registry.register(TextureKubeIcon.TYPE, FromTexture::new);
        registry.register(AtlasSpriteKubeIcon.TYPE, FromAtlasSprite::new);
        registry.register(ItemKubeIcon.TYPE, FromItem::new);
    });

    @Nullable
    public static KubeIconRenderer from(KubeIcon icon) {
        Function<?, KubeIconRenderer> factory = RENDERERS.get().get(icon.getType());
        return factory != null ? factory.apply(Cast.to(icon)) : null;
    }

    public void draw(Minecraft var1, GuiGraphics var2, int var3, int var4, int var5);

    public static interface Registry {
        public <T extends KubeIcon> void register(KubeIconType<T> var1, Function<T, KubeIconRenderer> var2);
    }

    public record FromItem(ItemKubeIcon icon) implements KubeIconRenderer
    {
        @Override
        public void draw(Minecraft mc, GuiGraphics graphics, int x, int y, int size) {
            Matrix4fStack m = RenderSystem.getModelViewStack();
            m.pushMatrix();
            m.translate((float)x - 2.0f, (float)y + 2.0f, 0.0f);
            float s = (float)size / 16.0f;
            m.scale(s, s, s);
            RenderSystem.applyModelViewMatrix();
            graphics.renderFakeItem(this.icon.item(), -8, -8);
            m.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public record FromAtlasSprite(AtlasSpriteKubeIcon icon) implements KubeIconRenderer
    {
        @Override
        public void draw(Minecraft mc, GuiGraphics graphics, int x, int y, int size) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)(this.icon.atlas().isEmpty() ? mc.kjs$getBlockTextureAtlas() : mc.getTextureAtlas(this.icon.atlas().get())).apply(this.icon.sprite());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f m = graphics.pose().last().pose();
            int p0 = -size / 2;
            int p1 = p0 + size;
            float u0 = sprite.getU0();
            float v0 = sprite.getV0();
            float u1 = sprite.getU1();
            float v1 = sprite.getV1();
            BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buf.addVertex(m, (float)(x + p0), (float)(y + p1), 0.0f).setUv(u0, v1).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p1), 0.0f).setUv(u1, v1).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p0), 0.0f).setUv(u1, v0).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p0), (float)(y + p0), 0.0f).setUv(u0, v0).setColor(255, 255, 255, 255);
            BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        }
    }

    public record FromTexture(TextureKubeIcon icon) implements KubeIconRenderer
    {
        @Override
        public void draw(Minecraft mc, GuiGraphics graphics, int x, int y, int size) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.icon.texture());
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f m = graphics.pose().last().pose();
            int p0 = -size / 2;
            int p1 = p0 + size;
            BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buf.addVertex(m, (float)(x + p0), (float)(y + p1), 0.0f).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p1), 0.0f).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p0), 0.0f).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p0), (float)(y + p0), 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255);
            BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        }
    }
}

