/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.util.JsonUtils;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import org.jetbrains.annotations.Nullable;

public interface KubeJSStreamCodecs {
    public static final StreamCodec<? super RegistryFriendlyByteBuf, IntProvider> INT_PROVIDER = ByteBufCodecs.fromCodecWithRegistries((Codec)IntProvider.CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceLocation> KUBEJS_ID = new StreamCodec<RegistryFriendlyByteBuf, ResourceLocation>(){

        public ResourceLocation decode(RegistryFriendlyByteBuf buf) {
            String str = Utf8String.read((ByteBuf)buf, (int)Short.MAX_VALUE);
            return str.indexOf(58) == -1 ? KubeJS.id(str) : ResourceLocation.parse((String)str);
        }

        public void encode(RegistryFriendlyByteBuf buf, ResourceLocation value) {
            Utf8String.write((ByteBuf)buf, (CharSequence)(value.getNamespace().equals("kubejs") ? value.getPath() : value.toString()), (int)Short.MAX_VALUE);
        }
    };
    public static final StreamCodec<ByteBuf, JsonElement> JSON_ELEMENT = new StreamCodec<ByteBuf, JsonElement>(){

        public JsonElement decode(ByteBuf buffer) {
            String str = Utf8String.read((ByteBuf)buffer, (int)Integer.MAX_VALUE);
            return str.isEmpty() || str.equals("null") ? JsonNull.INSTANCE : JsonUtils.fromString(str);
        }

        public void encode(ByteBuf buffer, @Nullable JsonElement value) {
            if (value == null || value instanceof JsonNull) {
                Utf8String.write((ByteBuf)buffer, (CharSequence)"", (int)Integer.MAX_VALUE);
            } else {
                Utf8String.write((ByteBuf)buffer, (CharSequence)JsonUtils.toString(value), (int)Integer.MAX_VALUE);
            }
        }
    };
    public static final StreamCodec<ByteBuf, Duration> DURATION = ByteBufCodecs.VAR_LONG.map(Duration::ofMillis, Duration::toMillis);

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> func) {
        return new StreamCodec<B, C>(){

            public C decode(B buf) {
                return func.apply(codec1.decode(buf), codec2.decode(buf), codec3.decode(buf), codec4.decode(buf), codec5.decode(buf), codec6.decode(buf), codec7.decode(buf), codec8.decode(buf));
            }

            public void encode(B buf, C value) {
                codec1.encode(buf, getter1.apply(value));
                codec2.encode(buf, getter2.apply(value));
                codec3.encode(buf, getter3.apply(value));
                codec4.encode(buf, getter4.apply(value));
                codec5.encode(buf, getter5.apply(value));
                codec6.encode(buf, getter6.apply(value));
                codec7.encode(buf, getter7.apply(value));
                codec8.encode(buf, getter8.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, C> func) {
        return new StreamCodec<B, C>(){

            public C decode(B buf) {
                return func.apply(codec1.decode(buf), codec2.decode(buf), codec3.decode(buf), codec4.decode(buf), codec5.decode(buf), codec6.decode(buf), codec7.decode(buf), codec8.decode(buf), codec9.decode(buf));
            }

            public void encode(B buf, C value) {
                codec1.encode(buf, getter1.apply(value));
                codec2.encode(buf, getter2.apply(value));
                codec3.encode(buf, getter3.apply(value));
                codec4.encode(buf, getter4.apply(value));
                codec5.encode(buf, getter5.apply(value));
                codec6.encode(buf, getter6.apply(value));
                codec7.encode(buf, getter7.apply(value));
                codec8.encode(buf, getter8.apply(value));
                codec9.encode(buf, getter9.apply(value));
            }
        };
    }
}

