/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.component;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.EvaluatorException;
import dev.latvian.mods.rhino.NativeJavaMap;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.Nullable;

public interface DataComponentWrapper {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"arguments.item.component.unknown", (Object[])new Object[]{object}));
    public static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((object, object2) -> Component.translatableEscape((String)"arguments.item.component.malformed", (Object[])new Object[]{object, object2}));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_COMPONENT = new SimpleCommandExceptionType((Message)Component.translatable((String)"arguments.item.component.expected"));
    public static final TypeInfo COMPONENT_TYPE = TypeInfo.of(DataComponentType.class);
    public static final Lazy<Map<DataComponentType<?>, TypeInfo>> TYPE_INFOS = Lazy.identityMap(map -> {
        try {
            for (Field field : DataComponents.class.getDeclaredFields()) {
                Type patt0$temp;
                if (field.getType() != DataComponentType.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !((patt0$temp = field.getGenericType()) instanceof ParameterizedType)) continue;
                ParameterizedType t = (ParameterizedType)patt0$temp;
                DataComponentType key = (DataComponentType)field.get(null);
                TypeInfo typeInfo = TypeInfo.of((Type)t.getActualTypeArguments()[0]);
                map.put(key, typeInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        KubeJSPlugins.forEachPlugin(map::put, KubeJSPlugin::registerDataComponentTypeDescriptions);
    });
    public static final Lazy<Set<DataComponentType<?>>> VISUAL_DIFFERENCE = Lazy.of(() -> {
        HashSet<DataComponentType> set = new HashSet<DataComponentType>();
        set.add(DataComponents.DAMAGE);
        set.add(DataComponents.MAX_DAMAGE);
        set.add(DataComponents.ENCHANTMENTS);
        set.add(DataComponents.STORED_ENCHANTMENTS);
        set.add(DataComponents.CUSTOM_MODEL_DATA);
        set.add(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        set.add(DataComponents.DYED_COLOR);
        set.add(DataComponents.MAP_COLOR);
        set.add(DataComponents.POTION_CONTENTS);
        set.add(DataComponents.TRIM);
        set.add(DataComponents.ENTITY_DATA);
        set.add(DataComponents.BLOCK_ENTITY_DATA);
        set.add(DataComponents.FIREWORK_EXPLOSION);
        set.add(DataComponents.FIREWORKS);
        set.add(DataComponents.PROFILE);
        set.add(DataComponents.BANNER_PATTERNS);
        set.add(DataComponents.BASE_COLOR);
        set.add(DataComponents.POT_DECORATIONS);
        set.add(DataComponents.BLOCK_STATE);
        return set;
    });

    public static TypeInfo getTypeInfo(DataComponentType<?> type) {
        return TYPE_INFOS.get().getOrDefault(type, TypeInfo.NONE);
    }

    public static DataComponentType<?> wrapType(Object object) {
        if (object instanceof DataComponentType) {
            return (DataComponentType)object;
        }
        return (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ID.mc(object));
    }

    public static DataComponentMap readMap(@Nullable DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        if (!reader.canRead()) {
            return DataComponentMap.EMPTY;
        }
        DataComponentMap.Builder builder = null;
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead() && reader.peek() != ']') {
                reader.skipWhitespace();
                DataComponentType<?> dataComponentType = DataComponentWrapper.readComponentType(reader);
                reader.skipWhitespace();
                reader.expect('=');
                reader.skipWhitespace();
                int i = reader.getCursor();
                DataResult dataResult = dataComponentType.codecOrThrow().parse(registryOps == null ? NbtOps.INSTANCE : registryOps, (Object)new TagParser(reader).readValue());
                if (builder == null) {
                    builder = DataComponentMap.builder();
                }
                builder.set(dataComponentType, Cast.to(dataResult.getOrThrow(string -> {
                    reader.setCursor(i);
                    return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)dataComponentType.toString(), string);
                })));
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') break;
                reader.skip();
                reader.skipWhitespace();
                if (reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            reader.expect(']');
        }
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag tag = new TagParser(reader).readStruct();
            if (builder == null) {
                builder = DataComponentMap.builder();
            }
            builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return builder == null ? DataComponentMap.EMPTY : builder.build();
    }

    public static DataComponentPatch readPatch(@Nullable DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        reader.skipWhitespace();
        if (!reader.canRead()) {
            return DataComponentPatch.EMPTY;
        }
        DataComponentPatch.Builder builder = null;
        if (reader.canRead() && reader.peek() == '[') {
            reader.skip();
            while (reader.canRead() && reader.peek() != ']') {
                boolean remove;
                reader.skipWhitespace();
                boolean bl = remove = reader.canRead() && reader.peek() == '!';
                if (remove) {
                    reader.skipWhitespace();
                }
                DataComponentType<?> dataComponentType = DataComponentWrapper.readComponentType(reader);
                if (remove) {
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() != ']') {
                        reader.expect(',');
                        reader.skipWhitespace();
                    }
                    if (builder == null) {
                        builder = DataComponentPatch.builder();
                    }
                    builder.remove(dataComponentType);
                    continue;
                }
                reader.skipWhitespace();
                reader.expect('=');
                reader.skipWhitespace();
                int i = reader.getCursor();
                DataResult dataResult = dataComponentType.codecOrThrow().parse(registryOps == null ? NbtOps.INSTANCE : registryOps, (Object)new TagParser(reader).readValue());
                if (builder == null) {
                    builder = DataComponentPatch.builder();
                }
                builder.set(dataComponentType, Cast.to(dataResult.getOrThrow(string -> {
                    reader.setCursor(i);
                    return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)dataComponentType.toString(), string);
                })));
                reader.skipWhitespace();
                if (!reader.canRead() || reader.peek() != ',') break;
                reader.skip();
                reader.skipWhitespace();
                if (reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            reader.expect(']');
        }
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag tag = new TagParser(reader).readStruct();
            if (builder == null) {
                builder = DataComponentPatch.builder();
            }
            builder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return builder == null ? DataComponentPatch.EMPTY : builder.build();
    }

    public static DataComponentType<?> readComponentType(StringReader stringReader) throws CommandSyntaxException {
        if (!stringReader.canRead()) {
            throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)stringReader);
        }
        int i = stringReader.getCursor();
        ResourceLocation resourceLocation = ResourceLocation.read((StringReader)stringReader);
        DataComponentType dataComponentType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(resourceLocation);
        if (dataComponentType != null && !dataComponentType.isTransient()) {
            return dataComponentType;
        }
        stringReader.setCursor(i);
        throw ERROR_UNKNOWN_COMPONENT.createWithContext((ImmutableStringReader)stringReader, (Object)resourceLocation);
    }

    public static DataComponentPredicate readPredicate(@Nullable DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        DataComponentMap map = reader.canRead() ? DataComponentWrapper.readMap(registryOps, reader) : DataComponentMap.EMPTY;
        return map.isEmpty() ? DataComponentPredicate.EMPTY : DataComponentPredicate.allOf((DataComponentMap)map);
    }

    public static boolean filter(Object from, TypeInfo target) {
        String s;
        return from == null || from instanceof DataComponentMap || from instanceof DataComponentPatch || from instanceof Map || from instanceof NativeJavaMap || from instanceof String && ((s = (String)from).isEmpty() || s.charAt(0) == '[');
    }

    @Deprecated(forRemoval=true)
    public static DataComponentMap mapOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readMap(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException("Error parsing DataComponentMap from " + String.valueOf(o), ex);
        }
    }

    @Deprecated(forRemoval=true)
    public static DataComponentMap mapOrEmptyOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readMap(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            return DataComponentMap.EMPTY;
        }
    }

    @Deprecated(forRemoval=true)
    public static DataComponentPatch patchOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readPatch(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException("Error parsing DataComponentPatch from " + String.valueOf(o), ex);
        }
    }

    @Deprecated(forRemoval=true)
    public static DataComponentPatch patchOrEmptyOf(@Nullable DynamicOps<Tag> ops, Object o) {
        try {
            return DataComponentWrapper.readPatch(ops, new StringReader(o.toString()));
        }
        catch (CommandSyntaxException ex) {
            return DataComponentPatch.EMPTY;
        }
    }

    public static DataComponentMap mapOf(Context cx, Object from) {
        return (DataComponentMap)DataComponentWrapper.tryMapOf(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to wrap DataComponentMap: %s".formatted(error)).source(SourceLine.of(cx)));
    }

    public static DataComponentPatch patchOf(Context cx, Object from) {
        return (DataComponentPatch)DataComponentWrapper.tryPatchOf(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to wrap DataComponentPatch: %s".formatted(error)).source(SourceLine.of(cx)));
    }

    public static DataComponentMap mapOrEmptyOf(Context cx, Object from) {
        return DataComponentWrapper.tryMapOf(cx, from).resultOrPartial().orElse(DataComponentMap.EMPTY);
    }

    public static DataComponentPatch patchOrEmptyOf(Context cx, Object from) {
        return DataComponentWrapper.tryPatchOf(cx, from).resultOrPartial().orElse(DataComponentPatch.EMPTY);
    }

    public static DataResult<DataComponentMap> tryMapOf(Context cx, @Nullable Object o) {
        RegistryAccessContainer reg = RegistryAccessContainer.of(cx);
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataComponentMap.class, DataComponentPatch.class, BaseFunction.class, JsonObject.class, CompoundTag.class, Map.class, String.class}, (Object)object, n)) {
            case 0 -> {
                DataResult var5_6;
                DataComponentMap map = (DataComponentMap)object;
                yield var5_6 = DataResult.success((Object)map);
            }
            case 1 -> {
                DataResult var5_7;
                DataComponentPatch patch = (DataComponentPatch)object;
                yield var5_7 = DataResult.success((Object)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)patch));
            }
            case 2 -> {
                DataResult var5_8;
                BaseFunction fn = (BaseFunction)object;
                yield var5_8 = DataComponentWrapper.fnToBuilder(cx, MapBuilder.class, fn, builder -> ((DataComponentMap.Builder)Util.make((Object)DataComponentMap.builder(), (Consumer)builder)).build());
            }
            case 3 -> {
                DataResult var5_9;
                JsonObject json = (JsonObject)object;
                yield var5_9 = DataComponentMap.CODEC.parse(reg.json(), (Object)json);
            }
            case 4 -> {
                DataResult var5_10;
                CompoundTag tag = (CompoundTag)object;
                yield var5_10 = DataComponentMap.CODEC.parse(reg.nbt(), (Object)tag);
            }
            case 5 -> {
                DataResult var5_12;
                Map map = (Map)object;
                DataComponentMap.Builder builder = DataComponentMap.builder();
                Map wrapped = Objects.requireNonNull(cx.optionalMapOf((Object)map, COMPONENT_TYPE, TypeInfo.NONE));
                HashMap<DataComponentType, String> errors = new HashMap<DataComponentType, String>();
                for (Map.Entry entry : wrapped.entrySet()) {
                    DataComponentWrapper.wrapEntry(cx, entry, null, (arg_0, arg_1) -> ((DataComponentMap.Builder)builder).set(arg_0, arg_1), errors::put);
                }
                if (!errors.isEmpty()) {
                    DataResult var5_11;
                    StringJoiner joiner = new StringJoiner("; ");
                    errors.forEach((type, error) -> {
                        ResourceLocation id = reg.access().registryOrThrow(Registries.DATA_COMPONENT_TYPE).getKeyOrNull(type);
                        joiner.add("'%s' -> %s".formatted(id, error));
                    });
                    yield var5_11 = DataResult.error(() -> "Invalid component map format, errored input: [%s]".formatted(joiner.toString()), (Object)builder.build());
                }
                yield var5_12 = DataResult.success((Object)builder.build());
            }
            case -1 -> {
                DataResult var5_13;
                yield var5_13 = DataResult.success((Object)DataComponentMap.EMPTY);
            }
            case 6 -> {
                String s = (String)object;
                try {
                    DataResult var5_14;
                    yield var5_14 = DataResult.success((Object)DataComponentWrapper.readMap(reg.nbt(), new StringReader(s)));
                }
                catch (CommandSyntaxException ex) {
                    DataResult var5_15;
                    yield var5_15 = DataResult.error(() -> "Invalid string format '%s' for DataComponentMap: %s".formatted(s, ex.getMessage()));
                }
            }
            default -> {
                DataResult var5_16;
                yield var5_16 = DataResult.error(() -> "Don't know how to convert %s to DataComponentMap!".formatted(o));
            }
        };
    }

    public static DataResult<DataComponentPatch> tryPatchOf(Context cx, @Nullable Object o) {
        RegistryAccessContainer reg = RegistryAccessContainer.of(cx);
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataComponentPatch.class, BaseFunction.class, JsonObject.class, CompoundTag.class, Map.class, String.class}, (Object)object, n)) {
            case 0 -> {
                DataResult var5_6;
                DataComponentPatch patch = (DataComponentPatch)object;
                yield var5_6 = DataResult.success((Object)patch);
            }
            case 1 -> {
                DataResult var5_7;
                BaseFunction fn = (BaseFunction)object;
                yield var5_7 = DataComponentWrapper.fnToBuilder(cx, PatchBuilder.class, fn, builder -> ((DataComponentPatch.Builder)Util.make((Object)DataComponentPatch.builder(), (Consumer)builder)).build());
            }
            case 2 -> {
                DataResult var5_8;
                JsonObject json = (JsonObject)object;
                yield var5_8 = DataComponentPatch.CODEC.parse(reg.json(), (Object)json);
            }
            case 3 -> {
                DataResult var5_9;
                CompoundTag tag = (CompoundTag)object;
                yield var5_9 = DataComponentPatch.CODEC.parse(reg.nbt(), (Object)tag);
            }
            case 4 -> {
                DataResult var5_11;
                Map map = (Map)object;
                DataComponentPatch.Builder builder = DataComponentPatch.builder();
                Map wrapped = Objects.requireNonNull(cx.optionalMapOf((Object)map, COMPONENT_TYPE, TypeInfo.NONE));
                HashMap<DataComponentType, String> errors = new HashMap<DataComponentType, String>();
                for (Map.Entry entry : wrapped.entrySet()) {
                    DataComponentWrapper.wrapEntry(cx, entry, arg_0 -> ((DataComponentPatch.Builder)builder).remove(arg_0), (arg_0, arg_1) -> ((DataComponentPatch.Builder)builder).set(arg_0, arg_1), errors::put);
                }
                if (!errors.isEmpty()) {
                    DataResult var5_10;
                    StringJoiner joiner = new StringJoiner("; ");
                    errors.forEach((type, error) -> {
                        ResourceLocation id = reg.access().registryOrThrow(Registries.DATA_COMPONENT_TYPE).getKeyOrNull(type);
                        joiner.add("'%s' -> %s".formatted(id, error));
                    });
                    yield var5_10 = DataResult.error(() -> "Invalid component map format, errored input: [%s]".formatted(joiner.toString()), (Object)builder.build());
                }
                yield var5_11 = DataResult.success((Object)builder.build());
            }
            case -1 -> {
                DataResult var5_12;
                yield var5_12 = DataResult.success((Object)DataComponentPatch.EMPTY);
            }
            case 5 -> {
                String s = (String)object;
                try {
                    DataResult var5_13;
                    yield var5_13 = DataResult.success((Object)DataComponentWrapper.readPatch(reg.nbt(), new StringReader(s)));
                }
                catch (CommandSyntaxException ex) {
                    DataResult var5_14;
                    yield var5_14 = DataResult.error(() -> "Invalid string format '%s' for DataComponentPatch: %s".formatted(s, ex.getMessage()));
                }
            }
            default -> {
                DataResult var5_15;
                yield var5_15 = DataResult.error(() -> "Don't know how to convert %s to DataComponentPatch!".formatted(o));
            }
        };
    }

    private static void wrapEntry(Context cx, Map.Entry<DataComponentType<?>, ?> entry, @Nullable Consumer<DataComponentType<?>> ifNull, BiConsumer<DataComponentType, Object> builder, BiConsumer<DataComponentType<?>, String> error) {
        Codec codec;
        RegistryAccessContainer reg = RegistryAccessContainer.of(cx);
        DataComponentType<?> type = entry.getKey();
        TypeInfo valueType = DataComponentWrapper.getTypeInfo(type);
        Object value = entry.getValue();
        if (value == null || value instanceof Undefined) {
            if (ifNull != null) {
                ifNull.accept(type);
            }
            return;
        }
        EvaluatorException evalError = null;
        if (valueType.shouldConvert() && cx.canConvert(value, valueType)) {
            try {
                Object converted = cx.jsToJava(value, valueType);
                if (converted != null) {
                    builder.accept(type, converted);
                    return;
                }
            }
            catch (EvaluatorException e) {
                evalError = e;
            }
        }
        if ((codec = type.codec()) != null) {
            DataResult dataResult = codec.parse(reg.json(), (Object)JsonUtils.of(cx, value));
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success success = (DataResult.Success)dataResult2;
                    builder.accept(type, success.value());
                    break;
                }
                case 1: {
                    DataResult.Error err = (DataResult.Error)dataResult2;
                    error.accept(type, evalError != null ? "Failed to parse component from type wrappers and codec! Native: %s, Codec: %s".formatted(evalError.details(), err.message()) : "Failed to parse component from codec: %s!".formatted(err.message()));
                    break;
                }
            }
        } else {
            error.accept(type, "Component has non-serializable type");
        }
    }

    private static <B, T> DataResult<T> fnToBuilder(Context cx, Class<B> builderType, BaseFunction fn, Function<B, T> build) {
        try {
            Object builder = Cast.to(cx.createInterfaceAdapter(TypeInfo.of(builderType), (ScriptableObject)fn));
            return DataResult.success(build.apply(builder));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to create %s from builder: %s".formatted(builderType.toString(), e));
        }
    }

    public static StringBuilder mapToString(StringBuilder builder, @Nullable DynamicOps<Tag> ops, DataComponentMap map) {
        builder.append('[');
        boolean first = true;
        for (TypedDataComponent comp : map) {
            ResourceLocation id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)comp.type());
            Codec codec = comp.type().codec();
            if (id == null || codec == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(ID.reduce(id)).append('=');
            try {
                Object value = codec == Codec.BOOL ? comp.value() : codec.encodeStart(ops == null ? NbtOps.INSTANCE : ops, Cast.to(comp.value())).getOrThrow();
                builder.append(value);
            }
            catch (Throwable ex) {
                builder.append("ERROR[").append(ex.getMessage()).append("]");
            }
        }
        builder.append(']');
        return builder;
    }

    public static StringBuilder patchToString(StringBuilder builder, @Nullable DynamicOps<Tag> ops, DataComponentPatch patch) {
        builder.append('[');
        boolean first = true;
        for (Map.Entry comp : patch.entrySet()) {
            ResourceLocation id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)comp.getKey()));
            Codec codec = ((DataComponentType)comp.getKey()).codec();
            if (id == null || codec == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            if (((Optional)comp.getValue()).isPresent()) {
                builder.append(ID.reduce(id)).append('=');
                try {
                    Object value = codec == Codec.BOOL ? ((Optional)comp.getValue()).get() : codec.encodeStart(ops == null ? NbtOps.INSTANCE : ops, Cast.to(((Optional)comp.getValue()).get())).getOrThrow();
                    builder.append(value);
                }
                catch (Throwable ex) {
                    builder.append("ERROR[").append(ex.getMessage()).append("]");
                }
                continue;
            }
            builder.append('!').append(ID.reduce(id));
        }
        builder.append(']');
        return builder;
    }

    public static DataComponentPatch visualPatch(DataComponentPatch patch) {
        if (patch.isEmpty()) {
            return DataComponentPatch.EMPTY;
        }
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        for (Map.Entry entry : patch.entrySet()) {
            if (!VISUAL_DIFFERENCE.get().contains(entry.getKey())) continue;
            if (((Optional)entry.getValue()).isPresent()) {
                builder.set((DataComponentType)entry.getKey(), Cast.to(((Optional)entry.getValue()).get()));
                continue;
            }
            builder.remove((DataComponentType)entry.getKey());
        }
        return builder.build();
    }

    public static interface MapBuilder
    extends Consumer<DataComponentMap.Builder> {
        @Override
        public void accept(DataComponentMap.Builder var1);
    }

    public static interface PatchBuilder
    extends Consumer<DataComponentPatch.Builder> {
        @Override
        public void accept(DataComponentPatch.Builder var1);
    }
}

